/* :markup: markdown */

/*----------------------------------------------------------------------------*/
/* This file is generated by the templates/template.rb script and should not  */
/* be modified manually. See                                                  */
/* templates/src/token_type.c.erb                                             */
/* if you are looking to modify the                                           */
/* template                                                                   */
/*----------------------------------------------------------------------------*/

#include <string.h>

#include "prism/ast.h"

/**
 * Returns a string representation of the given token type.
 */
PRISM_EXPORTED_FUNCTION const char *
pm_token_type_name(pm_token_type_t token_type) {
    switch (token_type) {
        case PM_TOKEN_EOF:
            return "EOF";
        case PM_TOKEN_BRACE_RIGHT:
            return "BRACE_RIGHT";
        case PM_TOKEN_COMMA:
            return "COMMA";
        case PM_TOKEN_EMBEXPR_END:
            return "EMBEXPR_END";
        case PM_TOKEN_KEYWORD_DO:
            return "KEYWORD_DO";
        case PM_TOKEN_KEYWORD_ELSE:
            return "KEYWORD_ELSE";
        case PM_TOKEN_KEYWORD_ELSIF:
            return "KEYWORD_ELSIF";
        case PM_TOKEN_KEYWORD_END:
            return "KEYWORD_END";
        case PM_TOKEN_KEYWORD_ENSURE:
            return "KEYWORD_ENSURE";
        case PM_TOKEN_KEYWORD_IN:
            return "KEYWORD_IN";
        case PM_TOKEN_KEYWORD_RESCUE:
            return "KEYWORD_RESCUE";
        case PM_TOKEN_KEYWORD_THEN:
            return "KEYWORD_THEN";
        case PM_TOKEN_KEYWORD_WHEN:
            return "KEYWORD_WHEN";
        case PM_TOKEN_NEWLINE:
            return "NEWLINE";
        case PM_TOKEN_PARENTHESIS_RIGHT:
            return "PARENTHESIS_RIGHT";
        case PM_TOKEN_SEMICOLON:
            return "SEMICOLON";
        case PM_TOKEN_AMPERSAND:
            return "AMPERSAND";
        case PM_TOKEN_AMPERSAND_AMPERSAND:
            return "AMPERSAND_AMPERSAND";
        case PM_TOKEN_AMPERSAND_AMPERSAND_EQUAL:
            return "AMPERSAND_AMPERSAND_EQUAL";
        case PM_TOKEN_AMPERSAND_DOT:
            return "AMPERSAND_DOT";
        case PM_TOKEN_AMPERSAND_EQUAL:
            return "AMPERSAND_EQUAL";
        case PM_TOKEN_BACKTICK:
            return "BACKTICK";
        case PM_TOKEN_BACK_REFERENCE:
            return "BACK_REFERENCE";
        case PM_TOKEN_BANG:
            return "BANG";
        case PM_TOKEN_BANG_EQUAL:
            return "BANG_EQUAL";
        case PM_TOKEN_BANG_TILDE:
            return "BANG_TILDE";
        case PM_TOKEN_BRACE_LEFT:
            return "BRACE_LEFT";
        case PM_TOKEN_BRACKET_LEFT:
            return "BRACKET_LEFT";
        case PM_TOKEN_BRACKET_LEFT_ARRAY:
            return "BRACKET_LEFT_ARRAY";
        case PM_TOKEN_BRACKET_LEFT_RIGHT:
            return "BRACKET_LEFT_RIGHT";
        case PM_TOKEN_BRACKET_LEFT_RIGHT_EQUAL:
            return "BRACKET_LEFT_RIGHT_EQUAL";
        case PM_TOKEN_BRACKET_RIGHT:
            return "BRACKET_RIGHT";
        case PM_TOKEN_CARET:
            return "CARET";
        case PM_TOKEN_CARET_EQUAL:
            return "CARET_EQUAL";
        case PM_TOKEN_CHARACTER_LITERAL:
            return "CHARACTER_LITERAL";
        case PM_TOKEN_CLASS_VARIABLE:
            return "CLASS_VARIABLE";
        case PM_TOKEN_COLON:
            return "COLON";
        case PM_TOKEN_COLON_COLON:
            return "COLON_COLON";
        case PM_TOKEN_COMMENT:
            return "COMMENT";
        case PM_TOKEN_CONSTANT:
            return "CONSTANT";
        case PM_TOKEN_DOT:
            return "DOT";
        case PM_TOKEN_DOT_DOT:
            return "DOT_DOT";
        case PM_TOKEN_DOT_DOT_DOT:
            return "DOT_DOT_DOT";
        case PM_TOKEN_EMBDOC_BEGIN:
            return "EMBDOC_BEGIN";
        case PM_TOKEN_EMBDOC_END:
            return "EMBDOC_END";
        case PM_TOKEN_EMBDOC_LINE:
            return "EMBDOC_LINE";
        case PM_TOKEN_EMBEXPR_BEGIN:
            return "EMBEXPR_BEGIN";
        case PM_TOKEN_EMBVAR:
            return "EMBVAR";
        case PM_TOKEN_EQUAL:
            return "EQUAL";
        case PM_TOKEN_EQUAL_EQUAL:
            return "EQUAL_EQUAL";
        case PM_TOKEN_EQUAL_EQUAL_EQUAL:
            return "EQUAL_EQUAL_EQUAL";
        case PM_TOKEN_EQUAL_GREATER:
            return "EQUAL_GREATER";
        case PM_TOKEN_EQUAL_TILDE:
            return "EQUAL_TILDE";
        case PM_TOKEN_FLOAT:
            return "FLOAT";
        case PM_TOKEN_FLOAT_IMAGINARY:
            return "FLOAT_IMAGINARY";
        case PM_TOKEN_FLOAT_RATIONAL:
            return "FLOAT_RATIONAL";
        case PM_TOKEN_FLOAT_RATIONAL_IMAGINARY:
            return "FLOAT_RATIONAL_IMAGINARY";
        case PM_TOKEN_GLOBAL_VARIABLE:
            return "GLOBAL_VARIABLE";
        case PM_TOKEN_GREATER:
            return "GREATER";
        case PM_TOKEN_GREATER_EQUAL:
            return "GREATER_EQUAL";
        case PM_TOKEN_GREATER_GREATER:
            return "GREATER_GREATER";
        case PM_TOKEN_GREATER_GREATER_EQUAL:
            return "GREATER_GREATER_EQUAL";
        case PM_TOKEN_HEREDOC_END:
            return "HEREDOC_END";
        case PM_TOKEN_HEREDOC_START:
            return "HEREDOC_START";
        case PM_TOKEN_IDENTIFIER:
            return "IDENTIFIER";
        case PM_TOKEN_IGNORED_NEWLINE:
            return "IGNORED_NEWLINE";
        case PM_TOKEN_INSTANCE_VARIABLE:
            return "INSTANCE_VARIABLE";
        case PM_TOKEN_INTEGER:
            return "INTEGER";
        case PM_TOKEN_INTEGER_IMAGINARY:
            return "INTEGER_IMAGINARY";
        case PM_TOKEN_INTEGER_RATIONAL:
            return "INTEGER_RATIONAL";
        case PM_TOKEN_INTEGER_RATIONAL_IMAGINARY:
            return "INTEGER_RATIONAL_IMAGINARY";
        case PM_TOKEN_KEYWORD_ALIAS:
            return "KEYWORD_ALIAS";
        case PM_TOKEN_KEYWORD_AND:
            return "KEYWORD_AND";
        case PM_TOKEN_KEYWORD_BEGIN:
            return "KEYWORD_BEGIN";
        case PM_TOKEN_KEYWORD_BEGIN_UPCASE:
            return "KEYWORD_BEGIN_UPCASE";
        case PM_TOKEN_KEYWORD_BREAK:
            return "KEYWORD_BREAK";
        case PM_TOKEN_KEYWORD_CASE:
            return "KEYWORD_CASE";
        case PM_TOKEN_KEYWORD_CLASS:
            return "KEYWORD_CLASS";
        case PM_TOKEN_KEYWORD_DEF:
            return "KEYWORD_DEF";
        case PM_TOKEN_KEYWORD_DEFINED:
            return "KEYWORD_DEFINED";
        case PM_TOKEN_KEYWORD_DO_LOOP:
            return "KEYWORD_DO_LOOP";
        case PM_TOKEN_KEYWORD_END_UPCASE:
            return "KEYWORD_END_UPCASE";
        case PM_TOKEN_KEYWORD_FALSE:
            return "KEYWORD_FALSE";
        case PM_TOKEN_KEYWORD_FOR:
            return "KEYWORD_FOR";
        case PM_TOKEN_KEYWORD_IF:
            return "KEYWORD_IF";
        case PM_TOKEN_KEYWORD_IF_MODIFIER:
            return "KEYWORD_IF_MODIFIER";
        case PM_TOKEN_KEYWORD_MODULE:
            return "KEYWORD_MODULE";
        case PM_TOKEN_KEYWORD_NEXT:
            return "KEYWORD_NEXT";
        case PM_TOKEN_KEYWORD_NIL:
            return "KEYWORD_NIL";
        case PM_TOKEN_KEYWORD_NOT:
            return "KEYWORD_NOT";
        case PM_TOKEN_KEYWORD_OR:
            return "KEYWORD_OR";
        case PM_TOKEN_KEYWORD_REDO:
            return "KEYWORD_REDO";
        case PM_TOKEN_KEYWORD_RESCUE_MODIFIER:
            return "KEYWORD_RESCUE_MODIFIER";
        case PM_TOKEN_KEYWORD_RETRY:
            return "KEYWORD_RETRY";
        case PM_TOKEN_KEYWORD_RETURN:
            return "KEYWORD_RETURN";
        case PM_TOKEN_KEYWORD_SELF:
            return "KEYWORD_SELF";
        case PM_TOKEN_KEYWORD_SUPER:
            return "KEYWORD_SUPER";
        case PM_TOKEN_KEYWORD_TRUE:
            return "KEYWORD_TRUE";
        case PM_TOKEN_KEYWORD_UNDEF:
            return "KEYWORD_UNDEF";
        case PM_TOKEN_KEYWORD_UNLESS:
            return "KEYWORD_UNLESS";
        case PM_TOKEN_KEYWORD_UNLESS_MODIFIER:
            return "KEYWORD_UNLESS_MODIFIER";
        case PM_TOKEN_KEYWORD_UNTIL:
            return "KEYWORD_UNTIL";
        case PM_TOKEN_KEYWORD_UNTIL_MODIFIER:
            return "KEYWORD_UNTIL_MODIFIER";
        case PM_TOKEN_KEYWORD_WHILE:
            return "KEYWORD_WHILE";
        case PM_TOKEN_KEYWORD_WHILE_MODIFIER:
            return "KEYWORD_WHILE_MODIFIER";
        case PM_TOKEN_KEYWORD_YIELD:
            return "KEYWORD_YIELD";
        case PM_TOKEN_KEYWORD___ENCODING__:
            return "KEYWORD___ENCODING__";
        case PM_TOKEN_KEYWORD___FILE__:
            return "KEYWORD___FILE__";
        case PM_TOKEN_KEYWORD___LINE__:
            return "KEYWORD___LINE__";
        case PM_TOKEN_LABEL:
            return "LABEL";
        case PM_TOKEN_LABEL_END:
            return "LABEL_END";
        case PM_TOKEN_LAMBDA_BEGIN:
            return "LAMBDA_BEGIN";
        case PM_TOKEN_LESS:
            return "LESS";
        case PM_TOKEN_LESS_EQUAL:
            return "LESS_EQUAL";
        case PM_TOKEN_LESS_EQUAL_GREATER:
            return "LESS_EQUAL_GREATER";
        case PM_TOKEN_LESS_LESS:
            return "LESS_LESS";
        case PM_TOKEN_LESS_LESS_EQUAL:
            return "LESS_LESS_EQUAL";
        case PM_TOKEN_METHOD_NAME:
            return "METHOD_NAME";
        case PM_TOKEN_MINUS:
            return "MINUS";
        case PM_TOKEN_MINUS_EQUAL:
            return "MINUS_EQUAL";
        case PM_TOKEN_MINUS_GREATER:
            return "MINUS_GREATER";
        case PM_TOKEN_NUMBERED_REFERENCE:
            return "NUMBERED_REFERENCE";
        case PM_TOKEN_PARENTHESIS_LEFT:
            return "PARENTHESIS_LEFT";
        case PM_TOKEN_PARENTHESIS_LEFT_PARENTHESES:
            return "PARENTHESIS_LEFT_PARENTHESES";
        case PM_TOKEN_PERCENT:
            return "PERCENT";
        case PM_TOKEN_PERCENT_EQUAL:
            return "PERCENT_EQUAL";
        case PM_TOKEN_PERCENT_LOWER_I:
            return "PERCENT_LOWER_I";
        case PM_TOKEN_PERCENT_LOWER_W:
            return "PERCENT_LOWER_W";
        case PM_TOKEN_PERCENT_LOWER_X:
            return "PERCENT_LOWER_X";
        case PM_TOKEN_PERCENT_UPPER_I:
            return "PERCENT_UPPER_I";
        case PM_TOKEN_PERCENT_UPPER_W:
            return "PERCENT_UPPER_W";
        case PM_TOKEN_PIPE:
            return "PIPE";
        case PM_TOKEN_PIPE_EQUAL:
            return "PIPE_EQUAL";
        case PM_TOKEN_PIPE_PIPE:
            return "PIPE_PIPE";
        case PM_TOKEN_PIPE_PIPE_EQUAL:
            return "PIPE_PIPE_EQUAL";
        case PM_TOKEN_PLUS:
            return "PLUS";
        case PM_TOKEN_PLUS_EQUAL:
            return "PLUS_EQUAL";
        case PM_TOKEN_QUESTION_MARK:
            return "QUESTION_MARK";
        case PM_TOKEN_REGEXP_BEGIN:
            return "REGEXP_BEGIN";
        case PM_TOKEN_REGEXP_END:
            return "REGEXP_END";
        case PM_TOKEN_SLASH:
            return "SLASH";
        case PM_TOKEN_SLASH_EQUAL:
            return "SLASH_EQUAL";
        case PM_TOKEN_STAR:
            return "STAR";
        case PM_TOKEN_STAR_EQUAL:
            return "STAR_EQUAL";
        case PM_TOKEN_STAR_STAR:
            return "STAR_STAR";
        case PM_TOKEN_STAR_STAR_EQUAL:
            return "STAR_STAR_EQUAL";
        case PM_TOKEN_STRING_BEGIN:
            return "STRING_BEGIN";
        case PM_TOKEN_STRING_CONTENT:
            return "STRING_CONTENT";
        case PM_TOKEN_STRING_END:
            return "STRING_END";
        case PM_TOKEN_SYMBOL_BEGIN:
            return "SYMBOL_BEGIN";
        case PM_TOKEN_TILDE:
            return "TILDE";
        case PM_TOKEN_UAMPERSAND:
            return "UAMPERSAND";
        case PM_TOKEN_UCOLON_COLON:
            return "UCOLON_COLON";
        case PM_TOKEN_UDOT_DOT:
            return "UDOT_DOT";
        case PM_TOKEN_UDOT_DOT_DOT:
            return "UDOT_DOT_DOT";
        case PM_TOKEN_UMINUS:
            return "UMINUS";
        case PM_TOKEN_UMINUS_NUM:
            return "UMINUS_NUM";
        case PM_TOKEN_UPLUS:
            return "UPLUS";
        case PM_TOKEN_USTAR:
            return "USTAR";
        case PM_TOKEN_USTAR_STAR:
            return "USTAR_STAR";
        case PM_TOKEN_WORDS_SEP:
            return "WORDS_SEP";
        case PM_TOKEN___END__:
            return "__END__";
        case PM_TOKEN_MISSING:
            return "MISSING";
        case PM_TOKEN_NOT_PROVIDED:
            return "NOT_PROVIDED";
        case PM_TOKEN_MAXIMUM:
            assert(false && "unreachable");
            return "";
    }

    // Provide a default, because some compilers can't determine that the above
    // switch is exhaustive.
    assert(false && "unreachable");
    return "";
}

/**
 * Returns the human name of the given token type.
 */
const char *
pm_token_type_human(pm_token_type_t token_type) {
    switch (token_type) {
        case PM_TOKEN_EOF:
            return "end-of-input";
        case PM_TOKEN_MISSING:
            return "missing token";
        case PM_TOKEN_NOT_PROVIDED:
            return "not provided token";
        case PM_TOKEN_AMPERSAND:
            return "'&'";
        case PM_TOKEN_AMPERSAND_AMPERSAND:
            return "'&&'";
        case PM_TOKEN_AMPERSAND_AMPERSAND_EQUAL:
            return "'&&='";
        case PM_TOKEN_AMPERSAND_DOT:
            return "'&.'";
        case PM_TOKEN_AMPERSAND_EQUAL:
            return "'&='";
        case PM_TOKEN_BACKTICK:
            return "'`'";
        case PM_TOKEN_BACK_REFERENCE:
            return "back reference";
        case PM_TOKEN_BANG:
            return "'!'";
        case PM_TOKEN_BANG_EQUAL:
            return "'!='";
        case PM_TOKEN_BANG_TILDE:
            return "'!~'";
        case PM_TOKEN_BRACE_LEFT:
            return "'{'";
        case PM_TOKEN_BRACE_RIGHT:
            return "'}'";
        case PM_TOKEN_BRACKET_LEFT:
            return "'['";
        case PM_TOKEN_BRACKET_LEFT_ARRAY:
            return "'['";
        case PM_TOKEN_BRACKET_LEFT_RIGHT:
            return "'[]'";
        case PM_TOKEN_BRACKET_LEFT_RIGHT_EQUAL:
            return "'[]='";
        case PM_TOKEN_BRACKET_RIGHT:
            return "']'";
        case PM_TOKEN_CARET:
            return "'^'";
        case PM_TOKEN_CARET_EQUAL:
            return "'^='";
        case PM_TOKEN_CHARACTER_LITERAL:
            return "character literal";
        case PM_TOKEN_CLASS_VARIABLE:
            return "class variable";
        case PM_TOKEN_COLON:
            return "':'";
        case PM_TOKEN_COLON_COLON:
            return "'::'";
        case PM_TOKEN_COMMA:
            return "','";
        case PM_TOKEN_COMMENT:
            return "comment";
        case PM_TOKEN_CONSTANT:
            return "constant";
        case PM_TOKEN_DOT:
            return "'.'";
        case PM_TOKEN_DOT_DOT:
            return "..";
        case PM_TOKEN_DOT_DOT_DOT:
            return "...";
        case PM_TOKEN_EMBDOC_BEGIN:
            return "'=begin'";
        case PM_TOKEN_EMBDOC_END:
            return "'=end'";
        case PM_TOKEN_EMBDOC_LINE:
            return "embedded documentation line";
        case PM_TOKEN_EMBEXPR_BEGIN:
            return "'#{'";
        case PM_TOKEN_EMBEXPR_END:
            return "'}'";
        case PM_TOKEN_EMBVAR:
            return "'#'";
        case PM_TOKEN_EQUAL:
            return "'='";
        case PM_TOKEN_EQUAL_EQUAL:
            return "'=='";
        case PM_TOKEN_EQUAL_EQUAL_EQUAL:
            return "'==='";
        case PM_TOKEN_EQUAL_GREATER:
            return "'=>'";
        case PM_TOKEN_EQUAL_TILDE:
            return "'=~'";
        case PM_TOKEN_FLOAT:
            return "float";
        case PM_TOKEN_FLOAT_IMAGINARY:
            return "imaginary";
        case PM_TOKEN_FLOAT_RATIONAL:
            return "rational";
        case PM_TOKEN_FLOAT_RATIONAL_IMAGINARY:
            return "imaginary";
        case PM_TOKEN_GLOBAL_VARIABLE:
            return "global variable";
        case PM_TOKEN_GREATER:
            return "'>'";
        case PM_TOKEN_GREATER_EQUAL:
            return "'>='";
        case PM_TOKEN_GREATER_GREATER:
            return ">>";
        case PM_TOKEN_GREATER_GREATER_EQUAL:
            return ">>=";
        case PM_TOKEN_HEREDOC_END:
            return "heredoc ending";
        case PM_TOKEN_HEREDOC_START:
            return "heredoc beginning";
        case PM_TOKEN_IDENTIFIER:
            return "local variable or method";
        case PM_TOKEN_IGNORED_NEWLINE:
            return "ignored newline";
        case PM_TOKEN_INSTANCE_VARIABLE:
            return "instance variable";
        case PM_TOKEN_INTEGER:
            return "integer";
        case PM_TOKEN_INTEGER_IMAGINARY:
            return "imaginary";
        case PM_TOKEN_INTEGER_RATIONAL:
            return "rational";
        case PM_TOKEN_INTEGER_RATIONAL_IMAGINARY:
            return "imaginary";
        case PM_TOKEN_KEYWORD_ALIAS:
            return "'alias'";
        case PM_TOKEN_KEYWORD_AND:
            return "'and'";
        case PM_TOKEN_KEYWORD_BEGIN:
            return "'begin'";
        case PM_TOKEN_KEYWORD_BEGIN_UPCASE:
            return "'BEGIN'";
        case PM_TOKEN_KEYWORD_BREAK:
            return "'break'";
        case PM_TOKEN_KEYWORD_CASE:
            return "'case'";
        case PM_TOKEN_KEYWORD_CLASS:
            return "'class'";
        case PM_TOKEN_KEYWORD_DEF:
            return "'def'";
        case PM_TOKEN_KEYWORD_DEFINED:
            return "'defined?'";
        case PM_TOKEN_KEYWORD_DO:
            return "'do'";
        case PM_TOKEN_KEYWORD_DO_LOOP:
            return "'do'";
        case PM_TOKEN_KEYWORD_ELSE:
            return "'else'";
        case PM_TOKEN_KEYWORD_ELSIF:
            return "'elsif'";
        case PM_TOKEN_KEYWORD_END:
            return "'end'";
        case PM_TOKEN_KEYWORD_END_UPCASE:
            return "'END'";
        case PM_TOKEN_KEYWORD_ENSURE:
            return "'ensure'";
        case PM_TOKEN_KEYWORD_FALSE:
            return "'false'";
        case PM_TOKEN_KEYWORD_FOR:
            return "'for'";
        case PM_TOKEN_KEYWORD_IF:
            return "'if'";
        case PM_TOKEN_KEYWORD_IF_MODIFIER:
            return "'if'";
        case PM_TOKEN_KEYWORD_IN:
            return "'in'";
        case PM_TOKEN_KEYWORD_MODULE:
            return "'module'";
        case PM_TOKEN_KEYWORD_NEXT:
            return "'next'";
        case PM_TOKEN_KEYWORD_NIL:
            return "'nil'";
        case PM_TOKEN_KEYWORD_NOT:
            return "'not'";
        case PM_TOKEN_KEYWORD_OR:
            return "'or'";
        case PM_TOKEN_KEYWORD_REDO:
            return "'redo'";
        case PM_TOKEN_KEYWORD_RESCUE:
            return "'rescue'";
        case PM_TOKEN_KEYWORD_RESCUE_MODIFIER:
            return "'rescue' modifier";
        case PM_TOKEN_KEYWORD_RETRY:
            return "'retry'";
        case PM_TOKEN_KEYWORD_RETURN:
            return "'return'";
        case PM_TOKEN_KEYWORD_SELF:
            return "'self'";
        case PM_TOKEN_KEYWORD_SUPER:
            return "'super'";
        case PM_TOKEN_KEYWORD_THEN:
            return "'then'";
        case PM_TOKEN_KEYWORD_TRUE:
            return "'true'";
        case PM_TOKEN_KEYWORD_UNDEF:
            return "'undef'";
        case PM_TOKEN_KEYWORD_UNLESS:
            return "'unless'";
        case PM_TOKEN_KEYWORD_UNLESS_MODIFIER:
            return "'unless'";
        case PM_TOKEN_KEYWORD_UNTIL:
            return "'until'";
        case PM_TOKEN_KEYWORD_UNTIL_MODIFIER:
            return "'until'";
        case PM_TOKEN_KEYWORD_WHEN:
            return "'when'";
        case PM_TOKEN_KEYWORD_WHILE:
            return "'while'";
        case PM_TOKEN_KEYWORD_WHILE_MODIFIER:
            return "'while'";
        case PM_TOKEN_KEYWORD_YIELD:
            return "'yield'";
        case PM_TOKEN_KEYWORD___ENCODING__:
            return "'__ENCODING__'";
        case PM_TOKEN_KEYWORD___FILE__:
            return "'__FILE__'";
        case PM_TOKEN_KEYWORD___LINE__:
            return "'__LINE__'";
        case PM_TOKEN_LABEL:
            return "label";
        case PM_TOKEN_LABEL_END:
            return "label terminator";
        case PM_TOKEN_LAMBDA_BEGIN:
            return "'{'";
        case PM_TOKEN_LESS:
            return "'<'";
        case PM_TOKEN_LESS_EQUAL:
            return "'<='";
        case PM_TOKEN_LESS_EQUAL_GREATER:
            return "'<=>'";
        case PM_TOKEN_LESS_LESS:
            return "<<";
        case PM_TOKEN_LESS_LESS_EQUAL:
            return "<<=";
        case PM_TOKEN_METHOD_NAME:
            return "method name";
        case PM_TOKEN_MINUS:
            return "'-'";
        case PM_TOKEN_MINUS_EQUAL:
            return "'-='";
        case PM_TOKEN_MINUS_GREATER:
            return "'->'";
        case PM_TOKEN_NEWLINE:
            return "newline";
        case PM_TOKEN_NUMBERED_REFERENCE:
            return "numbered reference";
        case PM_TOKEN_PARENTHESIS_LEFT:
            return "'('";
        case PM_TOKEN_PARENTHESIS_LEFT_PARENTHESES:
            return "'('";
        case PM_TOKEN_PARENTHESIS_RIGHT:
            return "')'";
        case PM_TOKEN_PERCENT:
            return "'%'";
        case PM_TOKEN_PERCENT_EQUAL:
            return "'%='";
        case PM_TOKEN_PERCENT_LOWER_I:
            return "'%i'";
        case PM_TOKEN_PERCENT_LOWER_W:
            return "'%w'";
        case PM_TOKEN_PERCENT_LOWER_X:
            return "'%x'";
        case PM_TOKEN_PERCENT_UPPER_I:
            return "'%I'";
        case PM_TOKEN_PERCENT_UPPER_W:
            return "'%W'";
        case PM_TOKEN_PIPE:
            return "'|'";
        case PM_TOKEN_PIPE_EQUAL:
            return "'|='";
        case PM_TOKEN_PIPE_PIPE:
            return "'||'";
        case PM_TOKEN_PIPE_PIPE_EQUAL:
            return "'||='";
        case PM_TOKEN_PLUS:
            return "'+'";
        case PM_TOKEN_PLUS_EQUAL:
            return "'+='";
        case PM_TOKEN_QUESTION_MARK:
            return "'?'";
        case PM_TOKEN_REGEXP_BEGIN:
            return "regular expression beginning";
        case PM_TOKEN_REGEXP_END:
            return "regular expression ending";
        case PM_TOKEN_SEMICOLON:
            return "';'";
        case PM_TOKEN_SLASH:
            return "'/'";
        case PM_TOKEN_SLASH_EQUAL:
            return "'/='";
        case PM_TOKEN_STAR:
            return "'*'";
        case PM_TOKEN_STAR_EQUAL:
            return "'*='";
        case PM_TOKEN_STAR_STAR:
            return "'**'";
        case PM_TOKEN_STAR_STAR_EQUAL:
            return "'**='";
        case PM_TOKEN_STRING_BEGIN:
            return "string literal";
        case PM_TOKEN_STRING_CONTENT:
            return "string content";
        case PM_TOKEN_STRING_END:
            return "string ending";
        case PM_TOKEN_SYMBOL_BEGIN:
            return "symbol literal";
        case PM_TOKEN_TILDE:
            return "'~'";
        case PM_TOKEN_UAMPERSAND:
            return "'&'";
        case PM_TOKEN_UCOLON_COLON:
            return "'::'";
        case PM_TOKEN_UDOT_DOT:
            return "'..'";
        case PM_TOKEN_UDOT_DOT_DOT:
            return "'...'";
        case PM_TOKEN_UMINUS:
            return "'-'";
        case PM_TOKEN_UMINUS_NUM:
            return "'-'";
        case PM_TOKEN_UPLUS:
            return "'+'";
        case PM_TOKEN_USTAR:
            return "*";
        case PM_TOKEN_USTAR_STAR:
            return "**";
        case PM_TOKEN_WORDS_SEP:
            return "string separator";
        case PM_TOKEN___END__:
            return "'__END__'";
        case PM_TOKEN_MAXIMUM:
            assert(false && "unreachable");
            return "";
    }

    // Provide a default, because some compilers can't determine that the above
    // switch is exhaustive.
    assert(false && "unreachable");
    return "";
}
