.TH "ZIP_SOURCE_DATA" "3" "August 1, 2008" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_buffer\fR
\- create zip data source from buffer
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIstruct\ zip_source\ *\fR
.br
\fBzip_source_buffer\fR(\fIstruct zip *archive\fR,\ \fIconst void *data\fR,\ \fIzip_uint64_t len\fR,\ \fIint freep\fR);
.SH "DESCRIPTION"
The function
\fBzip_source_buffer\fR()
creates a zip source from the buffer
\fIdata\fR
of size
\fIlen\fR.
If
\fIfreep\fR
is non-zero, the buffer will be freed when it is no longer needed.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_buffer\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIlen\fR
is greater than zero and
\fIdata\fR
is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
