/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/icon.h>

        #include <wx/iconloc.h>
        #include <wx/bitmap.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxIcon* _wxIcon_ctor(const wxBitmap* bmp)
    {
        wxIcon* icon = new wxIcon();
        icon->CopyFromBitmap(*bmp);
        return icon;
    }
    bool _wxIcon_CreateFromHICON(wxIcon* self, long hicon)
    {
        #ifdef __WXMSW__
            return self->CreateFromHICON((WXHICON)hicon);
        #else
            return false;
        #endif
    }
    int _wxIcon___nonzero__(wxIcon* self)
    {
        return self->IsOk();
    }
    int _wxIcon___bool__(wxIcon* self)
    {
        return self->IsOk();
    }
    long _wxIcon_GetHandle(wxIcon* self)
    {
        #ifdef __WXMSW__
            return (long)self->GetHandle();
        #else
            return 0;
        #endif
    }
    void _wxIcon_SetHandle(wxIcon* self, long handle)
    {
        #ifdef __WXMSW__
            self->SetHandle((WXHANDLE)handle);
        #endif
    }


PyDoc_STRVAR(doc_wxIcon_CreateFromHICON, "CreateFromHICON(hicon) -> bool\n"
"\n"
"MSW-only method to create a wx.Icon from a native icon handle.");

extern "C" {static PyObject *meth_wxIcon_CreateFromHICON(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_CreateFromHICON(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long hicon;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_hicon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxIcon, &sipCpp, &hicon))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon_CreateFromHICON(sipCpp, hicon);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_CreateFromHICON, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_CopyFromBitmap, "CopyFromBitmap(bmp)\n"
"\n"
"Copies bmp bitmap to this icon.");

extern "C" {static PyObject *meth_wxIcon_CopyFromBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_CopyFromBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxBitmap* bmp;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxIcon, &sipCpp, sipType_wxBitmap, &bmp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CopyFromBitmap(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_CopyFromBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetDepth, "GetDepth() -> int\n"
"\n"
"Gets the colour depth of the icon.");

extern "C" {static PyObject *meth_wxIcon_GetDepth(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetDepth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDepth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetHeight, "GetHeight() -> int\n"
"\n"
"Gets the height of the icon in pixels.");

extern "C" {static PyObject *meth_wxIcon_GetHeight(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetWidth, "GetWidth() -> int\n"
"\n"
"Gets the width of the icon in pixels.");

extern "C" {static PyObject *meth_wxIcon_GetWidth(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if icon data is present.");

extern "C" {static PyObject *meth_wxIcon_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_LoadFile, "LoadFile(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> bool\n"
"\n"
"Loads an icon from a file or resource.");

extern "C" {static PyObject *meth_wxIcon_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int desiredWidth = -1;
        int desiredHeight = -1;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_desiredWidth,
            sipName_desiredHeight,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|Eii", &sipSelf, sipType_wxIcon, &sipCpp, sipType_wxString,&name, &nameState, sipType_wxBitmapType, &type, &desiredWidth, &desiredHeight))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*name,type,desiredWidth,desiredHeight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetDepth, "SetDepth(depth)\n"
"\n"
"Sets the depth member (does not affect the icon data).");

extern "C" {static PyObject *meth_wxIcon_SetDepth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetDepth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int depth;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_depth,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &depth))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDepth(depth);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetDepth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetHeight, "SetHeight(height)\n"
"\n"
"Sets the height member (does not affect the icon data).");

extern "C" {static PyObject *meth_wxIcon_SetHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int height;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeight(height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetWidth, "SetWidth(width)\n"
"\n"
"Sets the width member (does not affect the icon data).");

extern "C" {static PyObject *meth_wxIcon_SetWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxIcon, &sipCpp, &width))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWidth(width);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_GetHandle, "GetHandle() -> long");

extern "C" {static PyObject *meth_wxIcon_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxIcon_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxIcon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxIcon, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_GetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxIcon_SetHandle, "SetHandle(handle)");

extern "C" {static PyObject *meth_wxIcon_SetHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxIcon_SetHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long handle;
         ::wxIcon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxIcon, &sipCpp, &handle))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxIcon_SetHandle(sipCpp, handle);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_Icon, sipName_SetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxIcon___bool__(PyObject *);}
static int slot_wxIcon___bool__(PyObject *sipSelf)
{
     ::wxIcon *sipCpp = reinterpret_cast< ::wxIcon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxIcon));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static int slot_wxIcon___nonzero__(PyObject *);}
static int slot_wxIcon___nonzero__(PyObject *sipSelf)
{
     ::wxIcon *sipCpp = reinterpret_cast< ::wxIcon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxIcon));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxIcon___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxIcon(void *, const sipTypeDef *);}
static void *cast_wxIcon(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxIcon *sipCpp = reinterpret_cast< ::wxIcon *>(sipCppV);

    if (targetType == sipType_wxGDIObject)
        return static_cast< ::wxGDIObject *>(sipCpp);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxIcon(void *, int);}
static void release_wxIcon(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxIcon *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxIcon(void *, SIP_SSIZE_T, void *);}
static void assign_wxIcon(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxIcon *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxIcon *>(sipSrc);
}


extern "C" {static void *array_wxIcon(SIP_SSIZE_T);}
static void *array_wxIcon(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxIcon[sipNrElem];
}


extern "C" {static void *copy_wxIcon(const void *, SIP_SSIZE_T);}
static void *copy_wxIcon(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxIcon(reinterpret_cast<const  ::wxIcon *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxIcon(sipSimpleWrapper *);}
static void dealloc_wxIcon(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxIcon(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxIcon(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxIcon(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxIcon *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIcon();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxIcon* icon;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIcon, &icon))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIcon(*icon);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
         ::wxBitmapType type = wxBITMAP_TYPE_ANY;
        int desiredWidth = -1;
        int desiredHeight = -1;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_type,
            sipName_desiredWidth,
            sipName_desiredHeight,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|Eii", sipType_wxString,&name, &nameState, sipType_wxBitmapType, &type, &desiredWidth, &desiredHeight))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIcon(*name,type,desiredWidth,desiredHeight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxIconLocation* loc;

        static const char *sipKwdList[] = {
            sipName_loc,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxIconLocation, &loc))
        {

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxIcon(*loc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxBitmap* bmp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bmp))
        {
        PyErr_Clear();
        sipCpp = _wxIcon_ctor(bmp);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxIcon[] = {{204, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxIcon[] = {
    {(void *)slot_wxIcon___bool__, bool_slot},
    {(void *)slot_wxIcon___nonzero__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxIcon[] = {
    {SIP_MLNAME_CAST(sipName_CopyFromBitmap), SIP_MLMETH_CAST(meth_wxIcon_CopyFromBitmap), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_CopyFromBitmap)},
    {SIP_MLNAME_CAST(sipName_CreateFromHICON), SIP_MLMETH_CAST(meth_wxIcon_CreateFromHICON), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_CreateFromHICON)},
    {SIP_MLNAME_CAST(sipName_GetDepth), meth_wxIcon_GetDepth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIcon_GetDepth)},
    {SIP_MLNAME_CAST(sipName_GetHandle), meth_wxIcon_GetHandle, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIcon_GetHandle)},
    {SIP_MLNAME_CAST(sipName_GetHeight), meth_wxIcon_GetHeight, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIcon_GetHeight)},
    {SIP_MLNAME_CAST(sipName_GetWidth), meth_wxIcon_GetWidth, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIcon_GetWidth)},
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxIcon_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxIcon_IsOk)},
    {SIP_MLNAME_CAST(sipName_LoadFile), SIP_MLMETH_CAST(meth_wxIcon_LoadFile), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_LoadFile)},
    {SIP_MLNAME_CAST(sipName_SetDepth), SIP_MLMETH_CAST(meth_wxIcon_SetDepth), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_SetDepth)},
    {SIP_MLNAME_CAST(sipName_SetHandle), SIP_MLMETH_CAST(meth_wxIcon_SetHandle), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_SetHandle)},
    {SIP_MLNAME_CAST(sipName_SetHeight), SIP_MLMETH_CAST(meth_wxIcon_SetHeight), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_SetHeight)},
    {SIP_MLNAME_CAST(sipName_SetWidth), SIP_MLMETH_CAST(meth_wxIcon_SetWidth), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxIcon_SetWidth)}
};

sipVariableDef variables_wxIcon[] = {
    {PropertyVariable, sipName_Width, &methods_wxIcon[5], &methods_wxIcon[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Height, &methods_wxIcon[4], &methods_wxIcon[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Handle, &methods_wxIcon[3], &methods_wxIcon[9], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Depth, &methods_wxIcon[2], &methods_wxIcon[8], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxIcon, "Icon()\n"
"Icon(icon)\n"
"Icon(name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1)\n"
"Icon(loc)\n"
"Icon(bmp)\n"
"\n"
"An icon is a small rectangular bitmap usually used for denoting a\n"
"minimized application.");


sipClassTypeDef sipTypeDef__core_wxIcon = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxIcon,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Icon,
        {0, 0, 1},
        12, methods_wxIcon,
        0, SIP_NULLPTR,
        4, variables_wxIcon,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxIcon,
    -1,
    -1,
    supers_wxIcon,
    slots_wxIcon,
    init_type_wxIcon,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxIcon,
    assign_wxIcon,
    array_wxIcon,
    copy_wxIcon,
    release_wxIcon,
    cast_wxIcon,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
