#line 1 "numpy/core/src/umath/clip.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/**
 * This module provides the inner loops for the clip ufunc
 */
#define _UMATHMODULE
#define _MULTIARRAYMODULE
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "Python.h"

#include "numpy/halffloat.h"
#include "numpy/npy_math.h"
#include "numpy/ndarraytypes.h"
#include "numpy/npy_common.h"
#include "numpy/utils.h"
#include "fast_loop_macros.h"

/*
 * Produce macros that perform nan/nat-propagating min and max
 */

#line 26
#define _NPY_BOOL_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_BOOL_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_BYTE_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_BYTE_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_UBYTE_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_UBYTE_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_SHORT_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_SHORT_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_USHORT_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_USHORT_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_INT_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_INT_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_UINT_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_UINT_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_LONG_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_LONG_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_ULONG_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_ULONG_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_LONGLONG_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_LONGLONG_MAX(a, b) PyArray_MAX(a, b)

#line 26
#define _NPY_ULONGLONG_MIN(a, b) PyArray_MIN(a, b)
#define _NPY_ULONGLONG_MAX(a, b) PyArray_MAX(a, b)


#define _NPY_HALF_MIN(a, b) (npy_half_isnan(a) || npy_half_le(a, b) ? (a) : (b))
#define _NPY_HALF_MAX(a, b) (npy_half_isnan(a) || npy_half_ge(a, b) ? (a) : (b))

#line 36
#define _NPY_FLOAT_MIN(a, b) (npy_isnan(a) ? (a) : PyArray_MIN(a, b))
#define _NPY_FLOAT_MAX(a, b) (npy_isnan(a) ? (a) : PyArray_MAX(a, b))

#line 36
#define _NPY_DOUBLE_MIN(a, b) (npy_isnan(a) ? (a) : PyArray_MIN(a, b))
#define _NPY_DOUBLE_MAX(a, b) (npy_isnan(a) ? (a) : PyArray_MAX(a, b))

#line 36
#define _NPY_LONGDOUBLE_MIN(a, b) (npy_isnan(a) ? (a) : PyArray_MIN(a, b))
#define _NPY_LONGDOUBLE_MAX(a, b) (npy_isnan(a) ? (a) : PyArray_MAX(a, b))


#line 43
#define _NPY_CFLOAT_MIN(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CLT(a, b) ? (a) : (b))
#define _NPY_CFLOAT_MAX(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CGT(a, b) ? (a) : (b))

#line 43
#define _NPY_CDOUBLE_MIN(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CLT(a, b) ? (a) : (b))
#define _NPY_CDOUBLE_MAX(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CGT(a, b) ? (a) : (b))

#line 43
#define _NPY_CLONGDOUBLE_MIN(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CLT(a, b) ? (a) : (b))
#define _NPY_CLONGDOUBLE_MAX(a, b) (npy_isnan((a).real) || npy_isnan((a).imag) || PyArray_CGT(a, b) ? (a) : (b))


#line 50
#define _NPY_DATETIME_MIN(a, b) ( \
    (a) == NPY_DATETIME_NAT ? (a) : \
    (b) == NPY_DATETIME_NAT ? (b) : \
    (a) < (b) ? (a) : (b) \
)
#define _NPY_DATETIME_MAX(a, b) ( \
    (a) == NPY_DATETIME_NAT ? (a) : \
    (b) == NPY_DATETIME_NAT ? (b) : \
    (a) > (b) ? (a) : (b) \
)

#line 50
#define _NPY_TIMEDELTA_MIN(a, b) ( \
    (a) == NPY_DATETIME_NAT ? (a) : \
    (b) == NPY_DATETIME_NAT ? (b) : \
    (a) < (b) ? (a) : (b) \
)
#define _NPY_TIMEDELTA_MAX(a, b) ( \
    (a) == NPY_DATETIME_NAT ? (a) : \
    (b) == NPY_DATETIME_NAT ? (b) : \
    (a) > (b) ? (a) : (b) \
)


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_BOOL_MIN(_NPY_BOOL_MAX((x), (min)), (max))

NPY_NO_EXPORT void
BOOL_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_bool min_val = *(npy_bool *)args[1];
        npy_bool max_val = *(npy_bool *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_bool) && os1 == sizeof(npy_bool)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_bool *)op1 = _NPY_CLIP(*(npy_bool *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_bool *)op1 = _NPY_CLIP(*(npy_bool *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_bool *)op1 = _NPY_CLIP(*(npy_bool *)ip1, *(npy_bool *)ip2, *(npy_bool *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_BOOL_MAX
#undef _NPY_BOOL_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_BYTE_MIN(_NPY_BYTE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
BYTE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_byte min_val = *(npy_byte *)args[1];
        npy_byte max_val = *(npy_byte *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_byte) && os1 == sizeof(npy_byte)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_byte *)op1 = _NPY_CLIP(*(npy_byte *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_byte *)op1 = _NPY_CLIP(*(npy_byte *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_byte *)op1 = _NPY_CLIP(*(npy_byte *)ip1, *(npy_byte *)ip2, *(npy_byte *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_BYTE_MAX
#undef _NPY_BYTE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_UBYTE_MIN(_NPY_UBYTE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
UBYTE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_ubyte min_val = *(npy_ubyte *)args[1];
        npy_ubyte max_val = *(npy_ubyte *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_ubyte) && os1 == sizeof(npy_ubyte)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ubyte *)op1 = _NPY_CLIP(*(npy_ubyte *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ubyte *)op1 = _NPY_CLIP(*(npy_ubyte *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_ubyte *)op1 = _NPY_CLIP(*(npy_ubyte *)ip1, *(npy_ubyte *)ip2, *(npy_ubyte *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_UBYTE_MAX
#undef _NPY_UBYTE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_SHORT_MIN(_NPY_SHORT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
SHORT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_short min_val = *(npy_short *)args[1];
        npy_short max_val = *(npy_short *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_short) && os1 == sizeof(npy_short)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_short *)op1 = _NPY_CLIP(*(npy_short *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_short *)op1 = _NPY_CLIP(*(npy_short *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_short *)op1 = _NPY_CLIP(*(npy_short *)ip1, *(npy_short *)ip2, *(npy_short *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_SHORT_MAX
#undef _NPY_SHORT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_USHORT_MIN(_NPY_USHORT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
USHORT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_ushort min_val = *(npy_ushort *)args[1];
        npy_ushort max_val = *(npy_ushort *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_ushort) && os1 == sizeof(npy_ushort)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ushort *)op1 = _NPY_CLIP(*(npy_ushort *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ushort *)op1 = _NPY_CLIP(*(npy_ushort *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_ushort *)op1 = _NPY_CLIP(*(npy_ushort *)ip1, *(npy_ushort *)ip2, *(npy_ushort *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_USHORT_MAX
#undef _NPY_USHORT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_INT_MIN(_NPY_INT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
INT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_int min_val = *(npy_int *)args[1];
        npy_int max_val = *(npy_int *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_int) && os1 == sizeof(npy_int)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_int *)op1 = _NPY_CLIP(*(npy_int *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_int *)op1 = _NPY_CLIP(*(npy_int *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_int *)op1 = _NPY_CLIP(*(npy_int *)ip1, *(npy_int *)ip2, *(npy_int *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_INT_MAX
#undef _NPY_INT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_UINT_MIN(_NPY_UINT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
UINT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_uint min_val = *(npy_uint *)args[1];
        npy_uint max_val = *(npy_uint *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_uint) && os1 == sizeof(npy_uint)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_uint *)op1 = _NPY_CLIP(*(npy_uint *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_uint *)op1 = _NPY_CLIP(*(npy_uint *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_uint *)op1 = _NPY_CLIP(*(npy_uint *)ip1, *(npy_uint *)ip2, *(npy_uint *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_UINT_MAX
#undef _NPY_UINT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_LONG_MIN(_NPY_LONG_MAX((x), (min)), (max))

NPY_NO_EXPORT void
LONG_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_long min_val = *(npy_long *)args[1];
        npy_long max_val = *(npy_long *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_long) && os1 == sizeof(npy_long)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_long *)op1 = _NPY_CLIP(*(npy_long *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_long *)op1 = _NPY_CLIP(*(npy_long *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_long *)op1 = _NPY_CLIP(*(npy_long *)ip1, *(npy_long *)ip2, *(npy_long *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_LONG_MAX
#undef _NPY_LONG_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_ULONG_MIN(_NPY_ULONG_MAX((x), (min)), (max))

NPY_NO_EXPORT void
ULONG_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_ulong min_val = *(npy_ulong *)args[1];
        npy_ulong max_val = *(npy_ulong *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_ulong) && os1 == sizeof(npy_ulong)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ulong *)op1 = _NPY_CLIP(*(npy_ulong *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ulong *)op1 = _NPY_CLIP(*(npy_ulong *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_ulong *)op1 = _NPY_CLIP(*(npy_ulong *)ip1, *(npy_ulong *)ip2, *(npy_ulong *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_ULONG_MAX
#undef _NPY_ULONG_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_LONGLONG_MIN(_NPY_LONGLONG_MAX((x), (min)), (max))

NPY_NO_EXPORT void
LONGLONG_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_longlong min_val = *(npy_longlong *)args[1];
        npy_longlong max_val = *(npy_longlong *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_longlong) && os1 == sizeof(npy_longlong)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_longlong *)op1 = _NPY_CLIP(*(npy_longlong *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_longlong *)op1 = _NPY_CLIP(*(npy_longlong *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_longlong *)op1 = _NPY_CLIP(*(npy_longlong *)ip1, *(npy_longlong *)ip2, *(npy_longlong *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_LONGLONG_MAX
#undef _NPY_LONGLONG_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_ULONGLONG_MIN(_NPY_ULONGLONG_MAX((x), (min)), (max))

NPY_NO_EXPORT void
ULONGLONG_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_ulonglong min_val = *(npy_ulonglong *)args[1];
        npy_ulonglong max_val = *(npy_ulonglong *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_ulonglong) && os1 == sizeof(npy_ulonglong)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ulonglong *)op1 = _NPY_CLIP(*(npy_ulonglong *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_ulonglong *)op1 = _NPY_CLIP(*(npy_ulonglong *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_ulonglong *)op1 = _NPY_CLIP(*(npy_ulonglong *)ip1, *(npy_ulonglong *)ip2, *(npy_ulonglong *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_ULONGLONG_MAX
#undef _NPY_ULONGLONG_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_HALF_MIN(_NPY_HALF_MAX((x), (min)), (max))

NPY_NO_EXPORT void
HALF_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_half min_val = *(npy_half *)args[1];
        npy_half max_val = *(npy_half *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_half) && os1 == sizeof(npy_half)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_half *)op1 = _NPY_CLIP(*(npy_half *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_half *)op1 = _NPY_CLIP(*(npy_half *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_half *)op1 = _NPY_CLIP(*(npy_half *)ip1, *(npy_half *)ip2, *(npy_half *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_HALF_MAX
#undef _NPY_HALF_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_FLOAT_MIN(_NPY_FLOAT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
FLOAT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_float min_val = *(npy_float *)args[1];
        npy_float max_val = *(npy_float *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_float) && os1 == sizeof(npy_float)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_float *)op1 = _NPY_CLIP(*(npy_float *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_float *)op1 = _NPY_CLIP(*(npy_float *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_float *)op1 = _NPY_CLIP(*(npy_float *)ip1, *(npy_float *)ip2, *(npy_float *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_FLOAT_MAX
#undef _NPY_FLOAT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_DOUBLE_MIN(_NPY_DOUBLE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
DOUBLE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_double min_val = *(npy_double *)args[1];
        npy_double max_val = *(npy_double *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_double) && os1 == sizeof(npy_double)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_double *)op1 = _NPY_CLIP(*(npy_double *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_double *)op1 = _NPY_CLIP(*(npy_double *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_double *)op1 = _NPY_CLIP(*(npy_double *)ip1, *(npy_double *)ip2, *(npy_double *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_DOUBLE_MAX
#undef _NPY_DOUBLE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_LONGDOUBLE_MIN(_NPY_LONGDOUBLE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
LONGDOUBLE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_longdouble min_val = *(npy_longdouble *)args[1];
        npy_longdouble max_val = *(npy_longdouble *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_longdouble) && os1 == sizeof(npy_longdouble)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_longdouble *)op1 = _NPY_CLIP(*(npy_longdouble *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_longdouble *)op1 = _NPY_CLIP(*(npy_longdouble *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_longdouble *)op1 = _NPY_CLIP(*(npy_longdouble *)ip1, *(npy_longdouble *)ip2, *(npy_longdouble *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_LONGDOUBLE_MAX
#undef _NPY_LONGDOUBLE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_CFLOAT_MIN(_NPY_CFLOAT_MAX((x), (min)), (max))

NPY_NO_EXPORT void
CFLOAT_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_cfloat min_val = *(npy_cfloat *)args[1];
        npy_cfloat max_val = *(npy_cfloat *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_cfloat) && os1 == sizeof(npy_cfloat)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_cfloat *)op1 = _NPY_CLIP(*(npy_cfloat *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_cfloat *)op1 = _NPY_CLIP(*(npy_cfloat *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_cfloat *)op1 = _NPY_CLIP(*(npy_cfloat *)ip1, *(npy_cfloat *)ip2, *(npy_cfloat *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_CFLOAT_MAX
#undef _NPY_CFLOAT_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_CDOUBLE_MIN(_NPY_CDOUBLE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
CDOUBLE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_cdouble min_val = *(npy_cdouble *)args[1];
        npy_cdouble max_val = *(npy_cdouble *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_cdouble) && os1 == sizeof(npy_cdouble)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_cdouble *)op1 = _NPY_CLIP(*(npy_cdouble *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_cdouble *)op1 = _NPY_CLIP(*(npy_cdouble *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_cdouble *)op1 = _NPY_CLIP(*(npy_cdouble *)ip1, *(npy_cdouble *)ip2, *(npy_cdouble *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_CDOUBLE_MAX
#undef _NPY_CDOUBLE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_CLONGDOUBLE_MIN(_NPY_CLONGDOUBLE_MAX((x), (min)), (max))

NPY_NO_EXPORT void
CLONGDOUBLE_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_clongdouble min_val = *(npy_clongdouble *)args[1];
        npy_clongdouble max_val = *(npy_clongdouble *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_clongdouble) && os1 == sizeof(npy_clongdouble)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_clongdouble *)op1 = _NPY_CLIP(*(npy_clongdouble *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_clongdouble *)op1 = _NPY_CLIP(*(npy_clongdouble *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_clongdouble *)op1 = _NPY_CLIP(*(npy_clongdouble *)ip1, *(npy_clongdouble *)ip2, *(npy_clongdouble *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_CLONGDOUBLE_MAX
#undef _NPY_CLONGDOUBLE_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_DATETIME_MIN(_NPY_DATETIME_MAX((x), (min)), (max))

NPY_NO_EXPORT void
DATETIME_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_datetime min_val = *(npy_datetime *)args[1];
        npy_datetime max_val = *(npy_datetime *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_datetime) && os1 == sizeof(npy_datetime)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_datetime *)op1 = _NPY_CLIP(*(npy_datetime *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_datetime *)op1 = _NPY_CLIP(*(npy_datetime *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_datetime *)op1 = _NPY_CLIP(*(npy_datetime *)ip1, *(npy_datetime *)ip2, *(npy_datetime *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_DATETIME_MAX
#undef _NPY_DATETIME_MIN


#line 77

#define _NPY_CLIP(x, min, max) \
    _NPY_TIMEDELTA_MIN(_NPY_TIMEDELTA_MAX((x), (min)), (max))

NPY_NO_EXPORT void
TIMEDELTA_clip(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (steps[1] == 0 && steps[2] == 0) {
        /* min and max are constant throughout the loop, the most common case */
        /* NOTE: it may be possible to optimize these checks for nan */
        npy_timedelta min_val = *(npy_timedelta *)args[1];
        npy_timedelta max_val = *(npy_timedelta *)args[2];

        char *ip1 = args[0], *op1 = args[3];
        npy_intp is1 = steps[0], os1 = steps[3];
        npy_intp n = dimensions[0];

        /* contiguous, branch to let the compiler optimize */
        if (is1 == sizeof(npy_timedelta) && os1 == sizeof(npy_timedelta)) {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_timedelta *)op1 = _NPY_CLIP(*(npy_timedelta *)ip1, min_val, max_val);
            }
        }
        else {
            for(npy_intp i = 0; i < n; i++, ip1 += is1, op1 += os1) {
                *(npy_timedelta *)op1 = _NPY_CLIP(*(npy_timedelta *)ip1, min_val, max_val);
            }
        }
    }
    else {
        TERNARY_LOOP {
            *(npy_timedelta *)op1 = _NPY_CLIP(*(npy_timedelta *)ip1, *(npy_timedelta *)ip2, *(npy_timedelta *)ip3);
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

// clean up the macros we defined above
#undef _NPY_CLIP
#undef _NPY_TIMEDELTA_MAX
#undef _NPY_TIMEDELTA_MIN



