/* Generated by re2c 3.0 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@php.net>                                 |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
ZEND_API size_t ini_scanner_globals_offset;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

#define ZEND_SYSTEM_INI CG(ini_parser_unbuffered_errors)

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, ZEND_SYSTEM_INI))


#define RETURN_TOKEN(type, str, len) {                             \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED &&            \
		(YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW))) {\
		zend_ini_copy_typed_value(ini_lval, type, str, len);       \
	} else {                                                       \
		zend_ini_copy_value(ini_lval, str, len);                   \
	}                                                              \
	return type;                                                   \
}

static inline zend_result convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow, NULL)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner() */
static zend_result init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner() */
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno() */
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename() */
ZEND_COLD char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning() */
zend_result zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning() */
zend_result zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string() */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy9;
		}
		switch (yych) {
			case '\t': goto yy4;
			case '\n': goto yy6;
			case '\r': goto yy8;
			case ' ':
			case '!':
			case '"':
			case '$':
			case '&':
			case '(':
			case ')':
			case '^':
			case '{':
			case '|':
			case '}':
			case '~': goto yy10;
			case ';': goto yy11;
			case '=': goto yy12;
			case 'F':
			case 'f': goto yy13;
			case 'N':
			case 'n': goto yy14;
			case 'O':
			case 'o': goto yy15;
			case 'T':
			case 't': goto yy16;
			case 'Y':
			case 'y': goto yy17;
			case '[': goto yy18;
			default: goto yy1;
		}
yy1:
		YYDEBUG(1, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy2:
		YYDEBUG(2, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy1;
		}
		if (yych <= '=') goto yy3;
		if (yych <= '[') goto yy19;
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy4;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy5;
			if (yych <= '\n') goto yy6;
			if (yych >= '\r') goto yy8;
		} else {
			if (yych <= ';') {
				if (yych >= ';') goto yy11;
			} else {
				if (yych == '=') goto yy12;
			}
		}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy6;
		goto yy7;
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy9;
		}
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy1;
					if (yych <= '\t') goto yy4;
					goto yy6;
				} else {
					if (yych == '\r') goto yy8;
					goto yy1;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy1;
					goto yy3;
				} else {
					if (yych == '&') goto yy3;
					goto yy1;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy3;
					if (yych <= ':') goto yy1;
					goto yy11;
				} else {
					if (yych == '=') goto yy12;
					goto yy1;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy19;
					if (yych <= ']') goto yy1;
					goto yy3;
				} else {
					if (yych <= 'z') goto yy1;
					if (yych <= '~') goto yy3;
					goto yy1;
				}
			}
		}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy11;
		}
		if (yych <= '\n') goto yy20;
		goto yy22;
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy12;
		if (yych == ' ') goto yy12;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_RAW);
	} else {
		BEGIN(ST_VALUE);
	}
	return '=';
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy23;
		if (yych == 'a') goto yy23;
		goto yy2;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy24;
			if (yych <= 'T') goto yy2;
			goto yy26;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy2;
				goto yy24;
			} else {
				if (yych == 'u') goto yy26;
				goto yy2;
			}
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy27;
			if (yych <= 'M') goto yy2;
			goto yy28;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy2;
				goto yy27;
			} else {
				if (yych == 'n') goto yy28;
				goto yy2;
			}
		}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy30;
		if (yych == 'r') goto yy30;
		goto yy2;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy31;
		if (yych == 'e') goto yy31;
		goto yy2;
yy18:
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_SECTION_RAW);
	} else {
		BEGIN(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy19;
		if (yych == ' ') goto yy19;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	BEGIN(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy20;
		goto yy21;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy32;
		if (yych == 'l') goto yy32;
		goto yy2;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy2;
					if (yych <= '\t') goto yy33;
				} else {
					if (yych != '\r') goto yy2;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy34;
					if (yych >= '#') goto yy2;
				} else {
					if (yych == '%') goto yy2;
					if (yych >= '\'') goto yy2;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy25;
					if (yych <= ':') goto yy2;
				} else {
					if (yych == '=') goto yy25;
					if (yych <= 'M') goto yy2;
					goto yy35;
				}
			} else {
				if (yych <= 'm') {
					if (yych != '^') goto yy2;
				} else {
					if (yych <= 'n') goto yy35;
					if (yych <= 'z') goto yy2;
					if (yych >= 0x7F) goto yy2;
				}
			}
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy36;
		if (yych == 'l') goto yy36;
		goto yy2;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy34;
		if (yych == 'f') goto yy34;
		goto yy2;
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy1;
					if (yych <= '\t') goto yy37;
				} else {
					if (yych != '\r') goto yy1;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy28;
					if (yych >= '#') goto yy1;
				} else {
					if (yych == '%') goto yy1;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy1;
					if (yych >= '*') goto yy1;
				} else {
					if (yych == '<') goto yy1;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy19;
					goto yy1;
				} else {
					if (yych <= '^') goto yy29;
					if (yych <= 'z') goto yy1;
					if (yych >= 0x7F) goto yy1;
				}
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy38;
		if (yych == 'u') goto yy38;
		goto yy2;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy28;
		if (yych == 's') goto yy28;
		goto yy2;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy35;
		if (yych == 's') goto yy35;
		goto yy2;
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy33;
		if (yych == ' ') goto yy33;
		goto yy25;
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy1;
					if (yych <= '\t') goto yy33;
					goto yy25;
				} else {
					if (yych == '\r') goto yy25;
					goto yy1;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy34;
					if (yych <= '"') goto yy25;
					goto yy1;
				} else {
					if (yych == '%') goto yy1;
					goto yy25;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy1;
					if (yych <= ')') goto yy25;
					goto yy1;
				} else {
					if (yych == '<') goto yy1;
					goto yy25;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy19;
					goto yy1;
				} else {
					if (yych <= '^') goto yy25;
					if (yych <= 'z') goto yy1;
					if (yych <= '~') goto yy25;
					goto yy1;
				}
			}
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy34;
		if (yych == 'e') goto yy34;
		goto yy2;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy39;
		if (yych == 'l') goto yy39;
		goto yy2;
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy37;
		if (yych == ' ') goto yy37;
		goto yy29;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy28;
		if (yych == 'e') goto yy28;
		goto yy2;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy1;
					if (yych <= '\t') goto yy41;
				} else {
					if (yych != '\r') goto yy1;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych >= '#') goto yy1;
				} else {
					if (yych == '%') goto yy1;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy1;
					if (yych >= '*') goto yy1;
				} else {
					if (yych == '<') goto yy1;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy19;
					goto yy1;
				} else {
					if (yych <= '^') goto yy40;
					if (yych <= 'z') goto yy1;
					if (yych >= 0x7F) goto yy1;
				}
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy41;
		if (yych == ' ') goto yy41;
		goto yy40;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(42, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy43;
					if (yych <= '\n') goto yy47;
				} else {
					if (yych <= '\r') goto yy47;
					if (yych >= '"') goto yy49;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy50;
				} else {
					if (yych <= '\'') goto yy51;
					if (yych <= ',') goto yy43;
					if (yych <= '.') goto yy52;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy53;
					if (yych >= ';') goto yy47;
				} else {
					if (yych <= '@') goto yy43;
					if (yych <= 'Z') goto yy55;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy57;
					if (yych <= ']') goto yy58;
				} else {
					if (yych == '`') goto yy43;
					if (yych <= 'z') goto yy55;
				}
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy44:
		YYDEBUG(44, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy43;
		}
		if (yych <= '"') goto yy45;
		if (yych <= '$') goto yy59;
		if (yych <= ';') goto yy45;
		if (yych <= '\\') goto yy57;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy43;
				if (yych <= '\n') goto yy45;
				if (yych <= '\f') goto yy43;
				goto yy45;
			} else {
				if (yych == '"') goto yy49;
				if (yych <= '#') goto yy43;
				goto yy59;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy45;
				if (yych <= ':') goto yy43;
				goto yy45;
			} else {
				if (yych <= '[') goto yy43;
				if (yych <= '\\') goto yy57;
				if (yych <= ']') goto yy58;
				goto yy43;
			}
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy49:
		YYDEBUG(49, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy48;
			if (yych <= '[') goto yy43;
			goto yy61;
		} else {
			if (yych == '{') goto yy62;
			goto yy43;
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		goto yy48;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy44;
		if (yych <= '9') goto yy64;
		goto yy44;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy53;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy54;
				if (yych <= '\f') goto yy43;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy43;
				} else {
					if (yych == '$') goto yy59;
					goto yy43;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy54;
				if (yych == '.') goto yy64;
				goto yy43;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy43;
				} else {
					if (yych <= '\\') goto yy57;
					if (yych >= '^') goto yy43;
				}
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy55;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy56;
				if (yych <= '\f') goto yy43;
			} else {
				if (yych == '"') goto yy56;
				if (yych <= '#') goto yy43;
				goto yy59;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy56;
				if (yych <= ':') goto yy43;
			} else {
				if (yych <= '[') goto yy43;
				if (yych <= '\\') goto yy57;
				if (yych >= '^') goto yy43;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		goto yy43;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy60;
			if (yych <= '[') goto yy43;
			goto yy61;
		} else {
			if (yych != '{') goto yy43;
		}
yy60:
		YYDEBUG(60, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy45;
			} else {
				goto yy54;
			}
		} else {
			goto yy56;
		}
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy61;
		}
		goto yy43;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		goto yy65;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy54;
				if (yych <= '\f') goto yy43;
				goto yy54;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy43;
					goto yy54;
				} else {
					if (yych == '$') goto yy59;
					goto yy43;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy54;
				if (yych <= '/') goto yy43;
				if (yych <= '9') goto yy64;
				goto yy43;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy54;
					goto yy43;
				} else {
					if (yych <= '\\') goto yy57;
					if (yych <= ']') goto yy54;
					goto yy43;
				}
			}
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(66, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy70;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy67;
					if (yych <= '\n') goto yy71;
				} else {
					if (yych <= '\r') goto yy71;
					if (yych >= '"') goto yy73;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy74;
				} else {
					if (yych <= '\'') goto yy75;
					if (yych <= ',') goto yy67;
					if (yych <= '.') goto yy76;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy77;
					if (yych >= ';') goto yy71;
				} else {
					if (yych <= '@') goto yy67;
					if (yych <= 'Z') goto yy79;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy81;
					if (yych <= ']') goto yy82;
				} else {
					if (yych == '`') goto yy67;
					if (yych <= 'z') goto yy79;
				}
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy68:
		YYDEBUG(68, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy67;
		}
		if (yych <= '"') goto yy69;
		if (yych <= '$') goto yy84;
		if (yych <= ';') goto yy69;
		if (yych <= '\\') goto yy81;
yy69:
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy70;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy67;
				if (yych <= '\n') goto yy69;
				if (yych <= '\f') goto yy67;
				goto yy69;
			} else {
				if (yych == '"') goto yy73;
				if (yych <= '#') goto yy67;
				goto yy84;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy69;
				if (yych <= ':') goto yy67;
				goto yy69;
			} else {
				if (yych <= '[') goto yy67;
				if (yych <= '\\') goto yy81;
				if (yych <= ']') goto yy69;
				goto yy67;
			}
		}
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '[') goto yy67;
			goto yy86;
		} else {
			if (yych == '{') goto yy87;
			goto yy67;
		}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy72;
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy68;
		if (yych <= '9') goto yy89;
		goto yy68;
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy77;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy78;
				if (yych <= '\f') goto yy67;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy67;
				} else {
					if (yych == '$') goto yy84;
					goto yy67;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy78;
				if (yych == '.') goto yy89;
				goto yy67;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy67;
				} else {
					if (yych <= '\\') goto yy81;
					if (yych >= '^') goto yy67;
				}
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy79;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy80;
				if (yych <= '\f') goto yy67;
			} else {
				if (yych == '"') goto yy80;
				if (yych <= '#') goto yy67;
				goto yy84;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy80;
				if (yych <= ':') goto yy67;
			} else {
				if (yych <= '[') goto yy67;
				if (yych <= '\\') goto yy81;
				if (yych >= '^') goto yy67;
			}
		}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		goto yy67;
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy83;
			if (yych <= '\t') goto yy82;
			if (yych <= '\n') goto yy90;
		} else {
			if (yych <= '\r') goto yy91;
			if (yych == ' ') goto yy82;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '[') goto yy67;
			goto yy86;
		} else {
			if (yych != '{') goto yy67;
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy69;
			} else {
				goto yy78;
			}
		} else {
			goto yy80;
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy86;
		}
		goto yy67;
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy92;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy78;
				if (yych <= '\f') goto yy67;
				goto yy78;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy67;
					goto yy78;
				} else {
					if (yych == '$') goto yy84;
					goto yy67;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy78;
				if (yych <= '/') goto yy67;
				if (yych <= '9') goto yy89;
				goto yy67;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy78;
					goto yy67;
				} else {
					if (yych <= '\\') goto yy81;
					if (yych <= ']') goto yy78;
					goto yy67;
				}
			}
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		++YYCURSOR;
		goto yy83;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy90;
		goto yy83;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(93, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy99;
		}
		switch (yych) {
			case 0x00: goto yy94;
			case '\t':
			case '\n': goto yy101;
			case '\r': goto yy103;
			case ' ':
			case '!':
			case '&':
			case '(':
			case ')':
			case '^':
			case '|':
			case '~': goto yy104;
			case '"': goto yy105;
			case '$': goto yy106;
			case '\'': goto yy107;
			case '-':
			case '.': goto yy108;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9': goto yy109;
			case ';': goto yy111;
			case '=': goto yy112;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'z': goto yy113;
			case 'F':
			case 'f': goto yy115;
			case 'N':
			case 'n': goto yy116;
			case 'O':
			case 'o': goto yy117;
			case 'T':
			case 't': goto yy118;
			case 'Y':
			case 'y': goto yy119;
			default: goto yy96;
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy97:
		YYDEBUG(97, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy96;
		}
		if (yych <= '"') goto yy98;
		if (yych <= '$') goto yy120;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy99;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy100;
			if (yych <= '\n') goto yy101;
			if (yych >= '\r') goto yy103;
		} else {
			if (yych <= '"') {
				if (yych >= '"') goto yy105;
			} else {
				if (yych == ';') goto yy111;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy101;
		goto yy102;
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy104;
		if (yych == ' ') goto yy104;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy95;
			if (yych <= '[') goto yy96;
			goto yy122;
		} else {
			if (yych == '{') goto yy123;
			goto yy96;
		}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy124;
		}
		goto yy95;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy97;
		if (yych <= '9') goto yy125;
		goto yy97;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy109;
		}
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy110;
					if (yych <= 0x08) goto yy96;
				} else {
					if (yych != '\r') goto yy96;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy110;
					if (yych <= '#') goto yy96;
					goto yy120;
				} else {
					if (yych <= '%') goto yy96;
					if (yych >= '*') goto yy96;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '.') goto yy125;
					if (yych <= ':') goto yy96;
				} else {
					if (yych != '=') goto yy96;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy110;
					if (yych <= '{') goto yy96;
				} else {
					if (yych != '~') goto yy96;
				}
			}
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy111;
		}
		if (yych <= '\n') goto yy126;
		goto yy128;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy113;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy96;
				} else {
					if (yych <= '\n') goto yy114;
					if (yych <= '\f') goto yy96;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy96;
					if (yych >= '#') goto yy96;
				} else {
					if (yych <= '$') goto yy120;
					if (yych <= '%') goto yy96;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy96;
				} else {
					if (yych != '=') goto yy96;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy114;
					if (yych <= '{') goto yy96;
				} else {
					if (yych != '~') goto yy96;
				}
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					goto yy97;
				} else {
					if (yych <= '9') goto yy113;
					if (yych == ';') goto yy114;
					goto yy97;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy114;
					if (yych <= '@') goto yy97;
					goto yy129;
				} else {
					if (yych <= 'Z') goto yy113;
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					goto yy113;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy97;
					if (yych <= 'a') goto yy129;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					if (yych <= '\n') goto yy114;
					goto yy97;
				} else {
					if (yych <= '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					if (yych <= '"') goto yy114;
					goto yy97;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					if (yych <= '9') goto yy113;
					goto yy97;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy114;
						goto yy97;
					} else {
						if (yych <= '=') goto yy114;
						if (yych <= '@') goto yy97;
						goto yy113;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy130;
					if (yych == 'U') goto yy132;
					goto yy113;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy97;
						goto yy114;
					} else {
						if (yych == '`') goto yy97;
						goto yy113;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy130;
					if (yych == 'u') goto yy132;
					goto yy113;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy97;
						goto yy114;
					} else {
						if (yych == '~') goto yy114;
						goto yy97;
					}
				}
			}
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					if (yych <= '\n') goto yy114;
					goto yy97;
				} else {
					if (yych <= '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					if (yych <= '"') goto yy114;
					goto yy97;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					if (yych <= '9') goto yy113;
					goto yy97;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy114;
						goto yy97;
					} else {
						if (yych <= '=') goto yy114;
						if (yych <= '@') goto yy97;
						goto yy113;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy133;
					if (yych == 'N') goto yy134;
					goto yy113;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy97;
						goto yy114;
					} else {
						if (yych == '`') goto yy97;
						goto yy113;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy133;
					if (yych == 'n') goto yy134;
					goto yy113;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy97;
						goto yy114;
					} else {
						if (yych == '~') goto yy114;
						goto yy97;
					}
				}
			}
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'R') goto yy136;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy136;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'E') goto yy137;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy137;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy121;
			if (yych <= '[') goto yy96;
			goto yy122;
		} else {
			if (yych != '{') goto yy96;
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy98;
				} else {
					goto yy110;
				}
			} else {
				goto yy114;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy131;
				} else {
					goto yy135;
				}
			} else {
				goto yy148;
			}
		}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy138;
		}
		goto yy96;
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy124;
		}
		goto yy139;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy110;
					if (yych <= 0x08) goto yy96;
					goto yy110;
				} else {
					if (yych == '\r') goto yy110;
					goto yy96;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy110;
					if (yych <= '#') goto yy96;
					goto yy120;
				} else {
					if (yych <= '%') goto yy96;
					if (yych <= ')') goto yy110;
					goto yy96;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy125;
					if (yych <= ':') goto yy96;
					goto yy110;
				} else {
					if (yych == '=') goto yy110;
					goto yy96;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy110;
					if (yych <= '{') goto yy96;
					goto yy110;
				} else {
					if (yych == '~') goto yy110;
					goto yy96;
				}
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		++YYCURSOR;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy126;
		goto yy127;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'L') goto yy140;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy140;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy131;
					if (yych <= 0x08) goto yy97;
					if (yych <= '\t') goto yy141;
				} else {
					if (yych == '\r') goto yy131;
					if (yych <= 0x1F) goto yy97;
					goto yy141;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy131;
					if (yych <= '%') goto yy97;
					if (yych >= '*') goto yy97;
				} else {
					if (yych <= '9') goto yy113;
					if (yych != ';') goto yy97;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy131;
					if (yych <= '@') goto yy97;
					if (yych <= 'M') goto yy113;
					goto yy142;
				} else {
					if (yych <= 'Z') goto yy113;
					if (yych <= ']') goto yy97;
					if (yych >= '_') goto yy113;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy97;
					if (yych == 'n') goto yy142;
					goto yy113;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy97;
					} else {
						if (yych != '~') goto yy97;
					}
				}
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'L') goto yy143;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy143;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'F') goto yy144;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy144;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy113;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy97;
				} else {
					if (yych <= '\t') goto yy145;
					if (yych >= '\v') goto yy97;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy135;
					if (yych <= 0x1F) goto yy97;
					goto yy145;
				} else {
					if (yych <= '"') goto yy135;
					if (yych <= '%') goto yy97;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy97;
				} else {
					if (yych != '=') goto yy97;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy135;
					if (yych <= '{') goto yy97;
				} else {
					if (yych != '~') goto yy97;
				}
			}
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'U') goto yy146;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy146;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'S') goto yy134;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy134;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy138;
		}
		if (yych <= 0x00) goto yy98;
		if (yych == '\\') goto yy122;
		goto yy96;
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'S') goto yy142;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy142;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy141;
		if (yych == ' ') goto yy141;
		goto yy131;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'E') goto yy144;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy144;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'L') goto yy147;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy147;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy113;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy131;
					goto yy97;
				} else {
					if (yych <= '\t') goto yy141;
					if (yych <= '\n') goto yy131;
					goto yy97;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy131;
					if (yych <= 0x1F) goto yy97;
					goto yy141;
				} else {
					if (yych <= '"') goto yy131;
					if (yych <= '%') goto yy97;
					goto yy131;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy97;
					goto yy131;
				} else {
					if (yych == '=') goto yy131;
					goto yy97;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy131;
					if (yych <= '{') goto yy97;
					goto yy131;
				} else {
					if (yych == '~') goto yy131;
					goto yy97;
				}
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy145;
		if (yych == ' ') goto yy145;
		goto yy135;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy114;
					if (yych <= 0x08) goto yy97;
					goto yy114;
				} else {
					if (yych == '\r') goto yy114;
					if (yych <= 0x1F) goto yy97;
					goto yy114;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy97;
					if (yych <= ')') goto yy114;
					if (yych <= '/') goto yy97;
					goto yy113;
				} else {
					if (yych == ';') goto yy114;
					if (yych <= '<') goto yy97;
					goto yy114;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy97;
					if (yych == 'E') goto yy134;
					goto yy113;
				} else {
					if (yych <= ']') goto yy97;
					if (yych <= '^') goto yy114;
					if (yych <= '_') goto yy113;
					goto yy97;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy134;
					if (yych <= 'z') goto yy113;
					goto yy97;
				} else {
					if (yych == '}') goto yy97;
					if (yych <= '~') goto yy114;
					goto yy97;
				}
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy113;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy97;
				} else {
					if (yych <= '\t') goto yy149;
					if (yych >= '\v') goto yy97;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy148;
					if (yych <= 0x1F) goto yy97;
					goto yy149;
				} else {
					if (yych <= '"') goto yy148;
					if (yych <= '%') goto yy97;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy97;
				} else {
					if (yych != '=') goto yy97;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy148;
					if (yych <= '{') goto yy97;
				} else {
					if (yych != '~') goto yy97;
				}
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\t') goto yy149;
		if (yych == ' ') goto yy149;
		goto yy148;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(150, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy151;
		}
		if (yych <= '\r') goto yy152;
		goto yy153;
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy151;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy152:
		YYDEBUG(152, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy153;
		}
		if (yych <= 0x08) goto yy154;
		if (yych <= '\n') goto yy155;
		if (yych == '\r') goto yy156;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
		goto yy154;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy155;
		goto yy154;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(157, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy159;
		if (yych == '$') goto yy160;
		++YYCURSOR;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy159;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy158;
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(161, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy162;
		}
		if (yych == '}') goto yy164;
		goto yy163;
yy162:
		YYDEBUG(162, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy162;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(165, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy166;
			} else {
				if (yych <= '\t') goto yy168;
				if (yych <= '\n') goto yy169;
				goto yy166;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy171;
				if (yych <= 0x1F) goto yy166;
				goto yy168;
			} else {
				if (yych == ';') goto yy172;
				goto yy166;
			}
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy166:
		YYDEBUG(166, *YYCURSOR);
		++YYCURSOR;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	EAT_LEADING_WHITESPACE();
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				YYCURSOR++;
				break;
			case '"':
				if (yytext[0] == '"') {
					sc = NULL;
				}
				YYCURSOR++;
				break;
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	if (sc) {
		yyleng = sc - SCNG(yy_text);
	} else {
		yyleng = YYCURSOR - SCNG(yy_text);
	}

	EAT_TRAILING_WHITESPACE();

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}

	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy167;
			if (yych <= '\n') goto yy174;
			if (yych <= '\f') goto yy167;
			goto yy174;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy167;
				goto yy174;
			} else {
				if (yych == ';') goto yy174;
				goto yy167;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy169;
		goto yy170;
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy172;
		}
		if (yych <= '\n') goto yy176;
		goto yy178;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy174:
		YYDEBUG(174, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy173;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy175;
			if (yych <= '\n') goto yy169;
		} else {
			if (yych <= '\r') goto yy171;
			if (yych == ';') goto yy172;
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy176;
		goto yy177;
	}
}

}
