# Rename .new files to the standard name if they don't exist
function file_config () {
 if [ ! -f "etc/exim/${1}" ]; then
    mv -f etc/exim/${1}.new etc/exim/${1} >/dev/null 2>&1
 fi
}

file_config etc-aliases
file_config exim.conf
# This is for Spam Assassin reject at SMTP time.
# You don't necessarily need this file if you're not using
# SA-exim.  However, since this Exim package *is* patched with SA-Exim
# you may want to enable it by adding the line:
# local_scan_path = /usr/lib/exim4/local_scan/sa-exim.so
# to the beginning of your /etc/exim/exim.conf
# You will also need to have installed and configured Spam Assassin
# as per /usr/doc/sa-exim/INSTALL
#
file_config sa-exim.conf

# Install sendmail symlink.  Doing this here saves us having an
# empty /usr/lib in our package .tgz.
# I hope you don't also have sendmail installed and had plans to keep it ;-)
( cd usr/lib  ; rm -f sendmail ; ln -s ../bin/exim sendmail )
( cd usr/bin  ; rm -f sendmail ; ln -s exim sendmail        )
( cd usr/sbin ; rm -f sendmail ; ln -s ../bin/exim sendmail ) 

# Restart Exim
etc/rc.d/rc.exim stop
etc/rc.d/rc.exim start
