/* ,file-id archive://[lord]/425/rx/dfa.h/1998-05-18
 */
/* classes: h_files */

#ifndef DFAH
#define DFAH
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */


/* One way to describe regexps that are regular expressions is as 
 * deterministic finite automata.  "dfa.h" defines procedures for
 * constructing a DFA from an NFA (as constructed by "nfa.h") and
 * for pattern matching using that DFA.
 *
 */

struct rx_dfa
{
  struct rx_nfa * rx;
  struct rx_superstate * state;
  int final_tag;
};


/* automatically generated __STDC__ prototypes */
extern struct rx_dfa * rx_dfa ();
extern void rx_free_dfa (struct rx_dfa * dfa);
extern void rx_init_dfa_from_rx (struct rx_dfa * frame, struct rx_nfa * rx);
extern void rx_init_dfa_from_dfa (struct rx_dfa * dest, struct rx_dfa * src);
extern void rx_free_dfa_storage (struct rx_dfa * frame);
extern void rx_dfa_goto_start_superstate (struct rx_dfa * frame);
extern int rx_dfa_fit_p (struct rx_dfa * frame,
			 unsigned const char * burst,
			 int len);
extern int rx_dfa_advance (struct rx_dfa * frame,
			   unsigned const char * burst,
			   int len);
extern int rx_dfa_advance_to_final (struct rx_dfa * frame,
				    unsigned const char * burst,
				    int len);
#endif  /* DFAH */
