#ifndef sw_h_20050210
#define sw_h_20050210

	/* Names of utility */
#define SW_UTN_CONFIG	"swconfig"
#define SW_UTN_INSTALL	"swinstall"
#define SW_UTN_REMOVE	"swremove"
#define SW_UTN_LIST	"swlist"
#define SW_UTN_COPY	"swcopy"
#define SW_UTN_PACKAGE	"swpackage"
#define SW_UTN_VERIFY	"swverify"

	/* POSIX level values for script results */
#define SW_SUCCESS      0
#define SW_ERROR        1
#define SW_WARNING      2
#define SW_DESELECT     3		   /* not POSIX */
#define SW_NOTE         3
#define SW_NONE		255		  /* not POSIX */
#define SW_INTERNAL_ERROR_127	-127	  /* not POSIX */
#define SW_INTERNAL_ERROR_128	-128	  /* not POSIX */

#define SW_NOTICE       0   /* not POSIX */

	/* POSIX level values for swlist */
#define SW_LEVEL_V_FILE		0  /* these are array indexes for blist_levels_i[] in swlist */
#define SW_LEVEL_V_CONTROL_FILE	1
#define SW_LEVEL_V_FILESET	2
#define SW_LEVEL_V_SUBPRODUCT	3
#define SW_LEVEL_V_PRODUCT	4
#define SW_LEVEL_V_BUNDLE	5
#define SW_LEVEL_V_DISTRIBUTION	6
#define SW_LEVEL_V_HOST		7

	/* POSIX result values  -- <result> attribute */
#define SW_RESULT_NONE		"none"
#define SW_RESULT_SUCCESS	"success"
#define SW_RESULT_WARNING	"warning"
#define SW_RESULT_FAILURE	"failure"

	/* POSIX fileset states   -- <state> attribute */
#define SW_STATE_UNSET		"__unset__"  /* Impl extension */
#define SW_STATE_CONFIGURED	"configured"
#define SW_STATE_INSTALLED	"installed"
#define SW_STATE_CORRUPT	"corrupt"
#define SW_STATE_REMOVED	"removed"
#define SW_STATE_AVAILABLE	"available"
#define SW_STATE_TRANSIENT	"transient"


#define SWBIS_STATUS_COMMAND_NOT_FOUND	"126"

	/* POSIX (IEEE 1387.2) type letters for the 'type' attribute */
#define SW_ITYPE_f	'f'	/* Reg */	
#define SW_ITYPE_d	'd'	/* Dir */
#define SW_ITYPE_h	'h'	/* Link */
#define SW_ITYPE_s	's'	/* symlink */
#define SW_ITYPE_b	'b'	/* block device */
#define SW_ITYPE_c	'c'	/* char device */
#define SW_ITYPE_p	'p'	/* fifo */
#define SW_ITYPE_x	'x'	/* Not posix, C701 extension for 'to be deleted file */
#define SW_ITYPE_y	'y'	/* Not posix, Not C701, internal use only, means not dumped */

	/* Various shells */
#define SH_A_ash	"ash"
#define SH_A_dash	"dash"
#define SH_A_ksh	"ksh"
#define SH_A_sh		"sh"
#define SH_A_bash	"bash"
#define SH_A_mksh	"mksh"

#define SW_A_SCRIPT_ID		"script_id"
#define SW_A_CONTROL_SH		"control.sh" /* swbis specific; Generated by swinstall */
#define SW_A_INDEX		"INDEX"	     /* Distribution INDEX file */
#define SW_A_INSTALLED		"INSTALLED"  /* installed_software file [swbis specific] */
#define SW_A__INSTALLED		"_INSTALLED" /* transient name for INSTALLED */
#define SW_A_INFO		"INFO"
#define SW_A_OPTION		"OPTION"
#define SW_A_PSF		"PSF"
#define SW_A_PSFi		"PSFi"
#define SW_A__END		"_END"
#define SW_A_adjunct_md5sum	"adjunct_md5sum"
#define SW_A_all_filesets	"all_filesets"
#define SW_A_all_patches	"all_patches"
#define SW_A_ancestor		"ancestor"
#define SW_A_applied_patches	"applied_patches"
#define SW_A_architecture	"architecture"
#define SW_A_archive_path	"archive_path"
#define SW_A_build_host		"build_host"
#define SW_A_build_root		"build_root"
#define SW_A_bundle		"bundle"
#define SW_A_catalog		"catalog"
#define SW_A_category		"category"
#define SW_A_category_tag	"category_tag"
#define SW_A_change_log		"change_log"
#define SW_A_checkinstall	"checkinstall"
#define SW_A_checkremove	"checkremove"
#define SW_A_chksum		"chksum"
#define SW_A_chksum_md5		"chksum_md5"
#define SW_A_compressed_chksum	"compressed_chksum"
#define SW_A_compressed_size	"compressed_size"
#define SW_A_compression_state	"compression_state"
#define SW_A_compression_type	"compression_type"
#define SW_A_configure		"configure"
#define SW_A_contents		"contents"
#define SW_A_rpm_conflicts	"rpm_conflicts"
#define SW_A_controlsh		"control.sh"  /* installed software catalog control script [swbis specific] */
#define SW_A_control_directory	"control_directory"
#define SW_A_control_file	"control_file"
#define SW_A_copyright		"copyright"
#define SW_A_copyrighters	"copyrighters"
#define SW_A_corequisites	"corequisites"
#define SW_A_create_date	"create_date"
#define SW_A_create_time	"create_time"
#define SW_A_description	"description"
#define SW_A_dfiles		"dfiles"
#define SW_A_directory		"directory"
#define SW_A_distribution	"distribution"
#define SW_A_end		"end"
#define SW_A_exclude		"exclude"
#define SW_A_excluded_from_install	"excluded_from_install" /* Not POSIX */
#define SW_A_exclude_arch	"exclude_arch"
#define SW_A_exclude_os		"exclude_os"
#define SW_A_exclusive_arch	"exclusive_arch"
#define SW_A_exclusive_os	"exclusive_os"
#define SW_A_exrequisites	"exrequisites"
#define SW_A_file		"file"
#define SW_A_fileset		"fileset"
#define SW_A_fix		"fix"
#define SW_A_gid		"gid"
#define SW_A_group		"group"
#define SW_A_host		"host"
#define SW_A_hostname		"hostname"
#define SW_A_install_time	"install_time"
#define SW_A_installed_software	"installed_software"
#define SW_A_instance_id	"instance_id"
#define SW_A_interpreter	"interpreter"
#define SW_A_is_kernel		"is_kernel"
#define SW_A_is_locatable	"is_locatable"
#define SW_A_is_patch		"is_patch"
#define SW_A_is_reboot		"is_reboot"
#define SW_A_is_sparse		"is_sparse"
#define SW_A_is_volatile	"is_volatile"
#define SW_A_layout_version	"layout_version"
#define SW_A_leftmost		"leftmost"
#define SW_A_link_source	"link_source"
#define SW_A_location		"location"
#define SW_A_machine_type	"machine_type"
#define SW_A_major		"major"
#define SW_A_md5sum		"md5sum"
#define SW_A_media		"media"
#define SW_A_media_sequence_number		"media_sequence_number"
#define SW_A_media_type		"media_type"
#define SW_A_minor		"minor"
#define SW_A_mod_time		"mod_time"
#define SW_A_mod_date		"mod_date"
#define SW_A_mode		"mode"
#define SW_A_mtime		"mtime"
#define SW_A_number		"number"
#define SW_A_os_name		"os_name"
#define SW_A_os_release		"os_release"
#define SW_A_os_version		"os_version"
#define SW_A_owner		"owner"
#define SW_A_patch_state	"patch_state"
#define SW_A_path		"path"
#define SW_A_pfiles		"pfiles"
#define SW_A_postinstall	"postinstall"
#define SW_A_postkernel		"postkernel"
#define SW_A_postremove		"postremove"
#define SW_A_preinstall		"preinstall"
#define SW_A_preremove		"preremove"
#define SW_A_prerequisites	"prerequisites"
#define SW_A_product		"product"
#define SW_A_qualifier		"qualifier"
#define SW_A_rdev		"rdev"
#define SW_A_release		"release"
#define SW_A_replaced_by_install	"replaced_by_install" /* Not POSIX */
#define SW_A_request		"request"
#define SW_A_result		"result"
#define SW_A_return_code	"return_code"    /* Not POSIX */
#define SW_A_rpm_requires	"rpm_requires"
#define SW_A_revision		"revision"
#define SW_A_rpm_buildarchs	"rpm_buildarchs"
#define SW_A_rpm_default_prefix	"rpm_default_prefix"
#define SW_A_rpm_fileflags	"rpm_fileflags"
#define SW_A_rpm_flag		"rpm_flag"
#define SW_A_rpm_obsoletes	"rpm_obsoletes"
#define SW_A_rpm_provides	"rpm_provides"
#define SW_A_rpmversion		"rpmversion"
#define SW_A_saved_files_directory		"saved_files_directory"
#define SW_A_session_options	"session_options"
#define SW_A_sequence_number	"sequence_number"
#define SW_A_signature		"signature"
#define SW_A_size		"size"
#define SW_A_sha1sum		"sha1sum"
#define SW_A_sha512sum		"sha512sum"
#define SW_A_software_spec	"software_spec"
#define SW_A_source		"source"
#define SW_A_source_package	"source_package"
#define SW_A_sourcerpm		"sourcerpm"
#define SW_A_space		"space"
#define SW_A_state		"state"
#define SW_A_subproduct		"subproduct"
#define SW_A_supersedes		"supersedes"
#define SW_A_tag		"tag"
#define SW_A_title		"title"
#define SW_A_type		"type"
#define SW_A_uid		"uid"
#define SW_A_unconfigure	"unconfigure"
#define SW_A_unpostinstall	"unpostinstall"
#define SW_A_unpreinstall	"unpreinstall"
#define SW_A_url		"url"
#define SW_A_uuid		"uuid"
#define SW_A_vendor		"vendor"
#define SW_A_vendor_tag		"vendor_tag"
#define SW_A_verify		"verify"
#define SW_OBJ_file		"file"
#define SW_OBJ_control_file	"control_file"
#define SW_OBJ_product		"product"
#define SW_OBJ_bundle		"bundle"

#endif
