# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# gnome emu

import gtk
from uiconsts import *
import uiconsts
from src import gu

class App(gtk.Window):
    def __init__(self, a, b):
        gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
        self._cid = 4
        self.__vbox = gtk.VBox()
        self.add(self.__vbox)
        self.__menubox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__toolbarbox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__contentsbox = gu.bVBox(self.__vbox)
        self.__appbarbox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__dockitems = {}
    def show(self):
        self.__vbox.show()
        self.__menubox.show()
        self.__toolbarbox.show()
        self.__contentsbox.show()
        self.__appbarbox.show()
        gtk.Window.show(self)
    def set_statusbar(self, bar):
        self.__appbarbox.pack_start(bar)
        bar.show()
        self.__appbar = bar
    def set_contents(self, c):
        self.__contentsbox.pack_start(c)
    def set_menus(self, menu):
        hdlbox = gtk.HandleBox()
        hdlbox.show()
        self.__dockitems['Menubar'] = hdlbox

        self.__menubox.pack_start(hdlbox, gtk.TRUE, gtk.TRUE)
        hdlbox.add(menu)
        menu.show()
    def add_toolbar(self, toolbar, name, behavior, placement, band_num,
                    band_position, offset):
        hdlbox = gtk.HandleBox()
        hdlbox.show()
        self.__dockitems[name] = hdlbox
        self.__toolbarbox.pack_start(hdlbox)
        self.__toolbarbox.reorder_child(hdlbox, offset)
        hdlbox.add(toolbar)
        toolbar.show()
    def get_dock_item_by_name(self, name):
        return self.__dockitems[name]

class PropertyBox(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_resizable(gtk.FALSE)
        self.vbox.set_border_width(uiconsts.PAD)
        self.vbox.set_spacing(uiconsts.PAD)
        self.g_notebook = gtk.Notebook()
        self.g_notebook.show()
        self.vbox.pack_start(self.g_notebook, gtk.FALSE)

        self.g_help = gtk.Button(stock='gtk-help')
        self.g_help.connect('clicked', self.on_help)
        self.action_area.pack_start(self.g_help)

        self.g_apply = gtk.Button(stock='gtk-apply')
        self.g_apply.connect('clicked', self._apply)
        self.g_apply.set_sensitive(gtk.FALSE)
        self.action_area.pack_start(self.g_apply)

        self.g_close = gtk.Button(stock='gtk-close')
        self.g_close.connect('clicked', lambda widget: self.destroy())
        self.action_area.pack_start(self.g_close)

        self.g_ok = gtk.Button(stock='gtk-ok')
        self.g_ok.connect('clicked', self._ok)
        self.g_ok.set_sensitive(gtk.FALSE)
        self.action_area.pack_start(self.g_ok)
    def connect(self, event, cb):
        if event in ('apply', 'help'):
                pass
        else:
                gtk.Dialog.connect(self, event, cb)
    def append_page(self, page, label):
        self.g_notebook.append_page(page, label)
    def set_modified(self, m):
        self.g_ok.set_sensitive(gtk.TRUE)
        self.g_apply.set_sensitive(gtk.TRUE)
    def _ok(self, widget):
        self._apply(widget)
        self.destroy()
    def _apply(self, widget):
        for x in range(len(self.g_notebook.get_children())):
            self.on_apply(self.g_notebook.get_children()[x], x)
        self.on_apply(self.g_notebook, -1)
        self.g_apply.set_sensitive(gtk.FALSE)

class GnomeCanvas(gtk.Label):
    def __init__(self):
        gtk.Label.__init__(self, "Not on windows")
        self.show()
    def root(self): pass

class _ContribDialog(gtk.Dialog):
    def __init__(self, name, authors, documenters, translators):
        gtk.Dialog.__init__(self, 'About %s' % name, None, 0, ('gtk-close', 1))
        nb = gtk.Notebook()
        nb.set_border_width(uiconsts.PAD)
        self.vbox.pack_start(nb)
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        for s in authors:
            l = gtk.Label(s)
            l.set_alignment(0, 0)
            vbox.pack_start(l, gtk.FALSE)
        nb.append_page(vbox, gtk.Label('Authors'))
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        for s in documenters:
            l = gtk.Label(s)
            l.set_alignment(0, 0)
            vbox.pack_start(l, gtk.FALSE)
        nb.append_page(vbox, gtk.Label('Documenters'))
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        l = gtk.Label(translators)
        l.set_alignment(0, 0)
        vbox.pack_start(l, gtk.FALSE)
        nb.append_page(vbox, gtk.Label('Translators'))
        self.get_children()[0].get_children()[-1].get_children()[0].grab_focus()

class About(gtk.Dialog):
    def __init__(self, name, version, copyright, text, authors,
             documenters, translators, pixmap):
        gtk.Dialog.__init__(self, 'About %s' % name, None, 0, ('Contributers', 2, 'gtk-close', 1))
        self.m_name = name
        self.m_authors = authors
        self.m_documenters = documenters
        self.m_translators = translators

        self.vbox.set_border_width(uiconsts.PAD_SMALL)
        self.vbox.set_spacing(uiconsts.PAD)
        im = gtk.Image()
        im.set_from_pixbuf(pixmap)
        self.vbox.pack_start(im)

        label = gtk.Label('<span size="xx-large">%s %s</span>' % (name, version))
        label.set_use_markup(1)
        self.vbox.pack_start(label)

        self.vbox.pack_start(gtk.Label(text))

        label = gtk.Label('<span size="smaller">%s</span>' % copyright)
        label.set_use_markup(1)
        self.vbox.pack_start(label)
        self.get_children()[0].get_children()[-1].get_children()[0].grab_focus()
    def run(self):
        self.show_all()
        while 1:
            i = gtk.Dialog.run(self)
            if i == 1:
               break
            if i == 2:
                self.run_contributers_dialog()
        self.hide()
        return i
    def run_contributers_dialog(self):
        d = _ContribDialog(self.m_name, self.m_authors,
                           self.m_documenters, self.m_translators)
        d.show_all()
        d.run()
        d.destroy()
