<?php

	//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

class Templates
{
   const BLOCK_DIR = 'blocks/';
   const TEMPLATE_DIR = 'templates/';
   const TEMPLATE_EXTENSION = '.template.html';
   protected $_variables = array();

   public function addVar($varName, $varValue)
   {
       $this->_variables[$varName] = $varValue;
   }

   public function getVar($varName)
   {
       return isset($this->_variables[$varName]) ? $this->_variables[$varName]
           : null;
   }
   public function getBlock($blockName)
   {
       $fileName = self::BLOCK_DIR . $blockName . self::TEMPLATE_EXTENSION;
       return is_file($fileName) ? $this->_loadTemplate($fileName) : null;
   }

   public function getTemplate($templateName)
   {
       $fileName = self::TEMPLATE_DIR . $blockName . self::TEMPLATE_EXTENSION;
       return is_file($fileName) ? $this->_loadTemplate($fileName) : null;
   }

   protected function _loadTemplate($templateName)
   {
       $template = file_get_contents($templateName);

       if (count($this->_variables)) {
           foreach ($this->_variables as $varName => $varValue) {
               $template = str_replace('{' . $varName . '}', $varValue, $template);
           }
       }

       return $template;
   }
}