/**
 *
 * @licstart  The following is the entire license notice for the 
 *  JavaScript code in this page.
 *
 * Copyright (C) 2012-2013 GNU remotecontrol authors
 *
 *
 * The JavaScript code in this page is free software: you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License (GNU GPL) as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * any later version.  The code is distributed WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.
 *
 * As additional permission under GNU GPL version 3 section 7, you
 * may distribute non-source (e.g., minimized or compacted) forms of
 * that code without the copy of the GNU GPL normally required by
 * section 4, provided you include this license notice and a URL
 * through which recipients can access the Corresponding Source.
 *
 * @licend  The above is the entire license notice
 * for the JavaScript code in this page.
 *
 */

function addUser()
{
	var userName = document.getElementById('UserName_0_Input').value;
	var maxNumTherms = document.getElementById('MaxNumTherms_0_Input').value;
	var postData = 'Action=1&UserName=' + userName + '&MaxNumTherms=' + maxNumTherms;

	ajax.doPost('services/process_user_db.php', postData, 'loadimage', handleAddResponse);

	document.getElementById('UserName_0_Input').value = '';
	document.getElementById('MaxNumTherms_0_Input').value = '';
}

function editUser(id)
{
	document.getElementById('UserName_' + id + '_Span').className = 'edit';
	document.getElementById('MaxNumTherms_' + id + '_Span').className = 'edit';

	document.getElementById('UserName_' + id + '_Input').className = 'edit';
	document.getElementById('MaxNumTherms_' + id + '_Input').className = 'edit number';

	document.getElementById('Edit_' + id).style.display = 'none';
	document.getElementById('Update_' + id).style.display = 'inline';
	document.getElementById('Cancel_' + id).style.display = 'inline';
}

function updateUser(id)
{
	var userName = document.getElementById('UserName_' + id + '_Input').value;
	var maxNumTherms = document.getElementById('MaxNumTherms_' + id + '_Input').value;
	var postData = 'Action=2&UserId=' + id + '&UserName=' + userName + '&MaxNumTherms=' + maxNumTherms;

	ajax.doPost('services/process_user_db.php', postData, 'loadimage', handleUpdateResponse);

	document.getElementById('UserName_' + id + '_Span').className = 'view';
	document.getElementById('UserName_' + id + '_Input').className = 'view';

	document.getElementById('MaxNumTherms_' + id + '_Span').className = 'view';
	document.getElementById('MaxNumTherms_' + id + '_Input').className = 'view';

	document.getElementById('Edit_' + id).style.display = 'inline';
	document.getElementById('Update_' + id).style.display = 'none';
	document.getElementById('Cancel_' + id).style.display = 'none';
}

function deleteUser(id)
{
	var postData = 'Action=3&UserId=' + id;
	
	ajax.doPost('services/process_user_db.php', postData, 'loadimage', handleDeleteResponse);
}

function cancelEditUser(id)
{
	document.getElementById('UserName_' + id + '_Span').className = 'view';
	document.getElementById('MaxNumTherms_' + id + '_Span').className = 'view';

	document.getElementById('UserName_' + id + '_Input').className = 'view';
	document.getElementById('MaxNumTherms_' + id + '_Input').className = 'view';

	document.getElementById('Edit_' + id).style.display = 'inline';
	document.getElementById('Update_' + id).style.display = 'none';
	document.getElementById('Cancel_' + id).style.display = 'none';
}

function handleAddResponse(resp)
{
	if(resp.substr(0,4) == 'ERR:')
	{
		handleError(resp);
	}
	else
	{
		var params = resp.split(';');

		var userId = params[0];
		var userName = params[1];
		var maxNumTherms = params[2];

		var profileAdminTable = document.getElementById('profileadmin');
		var targetRowIndex = profileAdminTable.rows.length - 1;

		profileAdminTable.insertRow(targetRowIndex);

		var row = profileAdminTable.rows[targetRowIndex];
		row.id = '~' + userId + '~';

		if(profileAdminTable.rows[row.rowIndex - 1].className == '')
		{
			row.className = 'alt';
		}

		row.insertCell(0);
		row.insertCell(1);
		row.insertCell(2);
		row.insertCell(3);

		var cell1 = row.cells[0];
		var cell2 = row.cells[1];
		var cell3 = row.cells[2];
		var cell4 = row.cells[3];

		cell1.innerHTML = '<a href="javascript:void(0);" id="Edit_' + userId + '" onclick="editUser(' + userId + ');" class="edit">Edit</a>';
		cell1.innerHTML += '<a href="javascript:void(0);" id="Update_' + userId + '" onclick="updateUser(' + userId + ');" class="update">Update</a>';
		cell1.innerHTML += '&nbsp;<a href="javascript:void(0);" id="Cancel_' + userId + '" onclick="cancelEditUser(' + userId + ');" class="cancel">Cancel</a>';

		cell2.innerHTML = '<span id="UserName_' + userId + '_Span" class="view">' + userName + '</span><input type="text" id="UserName_' + userId + '_Input" value="' + userName + '" class="view" />';

		cell3.innerHTML = '<span id="MaxNumTherms_' + userId + '_Span" class="view">' + maxNumTherms + '</span><input type="text" id="MaxNumTherms_' + userId + '_Input" value="' + maxNumTherms + '" class="view" />';

		cell4.innerHTML = '<a href="javascript:void(0);" id="Delete_' + userId + '" onclick="deleteUser(' + userId + ');" class="delete">Delete</a>';
	}
}

function handleUpdateResponse(resp)
{
	if(resp.substr(0,4) == 'ERR:')
	{
		handleError(resp);
	}
	else
	{
		var params = resp.split(';');

		var userId = params[0];
		var userName = params[1];
		var maxNumTherms = params[2];

		document.getElementById('UserName_' + userId + '_Span').innerHTML = userName;
		document.getElementById('UserName_' + userId + '_Input').innerHTML = userName;

		document.getElementById('MaxNumTherms_' + userId + '_Span').innerHTML = maxNumTherms;
		document.getElementById('MaxNumTherms_' + userId + '_Input').innerHTML = maxNumTherms;
	}
}

function handleDeleteResponse(resp)
{
	if(resp.substr(0,4) == 'ERR:')
	{
		handleError(resp);
	}
	else
	{
		var profileAdminTable = document.getElementById('profileadmin');

		profileAdminTable.deleteRow(document.getElementById('~' + resp + '~').rowIndex);

		for(var i = 1; i < profileAdminTable.rows.length - 1; i++)
		{
			if(i % 2 == 0)
			{
				profileAdminTable.rows[i].className = 'alt';
			}
			else
			{
				profileAdminTable.rows[i].className = '';
			}
		}
	}
}

function handleError(resp)
{
	document.getElementById('message').innerHTML = resp;
}
