/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "MapGenerator.h"
#include "RandomGenerator.h"
#include "Player.h"
#include <string>
#include <map>
#include <set>
#include <sstream>
MapGenerator::MapGenerator(void)
{
	writemessage=NULL;
}


MapGenerator::~MapGenerator(void)
{
}





Case * MapGenerator::generateMapIntern(int nbplayer,int width,int height, int smooth)
{
	Case *ret=new Case[width*height];
	RandomGenerator rand;

	//Create Players
	int j=0;
	Player *listPlay=new Player[nbplayer];

	int y=0;
	char a[2];
	a[0]='a';
	a[1]=0;
	for (y=0;y<nbplayer;y++)
	{
		char aa[2];
		aa[1]=0;
		aa[0]=a[0]+y;
		std::string name=aa;
		listPlay[y].setName(name);
	}
	//Clean Cases
	for (y=0;y<width*height;y++)
	{
		ret[y].setPlayer(NULL);
		ret[y].setCaseType(Case::NOTUSED);
	}


	//take 50% random point
	float i=0.0f;
	for (i=0.0f;i<(width*height)*0.5;i++)
	{
		int player=rand.nextInt()%nbplayer;
		int x=rand.nextInt()%width;
		int y=rand.nextInt()%height;
		ret[x+width*y].setCaseType(Case::FREE);
		ret[x+width*y].setPlayer(&listPlay[0]);

	}

	//Smooth
	int k=0;
	bool alone=false;
	for (k=0;k<smooth;k++)
	{
		alone=false;
		int m=0,n=0;
		for (m=0;m<width;m++)
		for (n=0;n<height;n++)
		{
			int m1=0,n1=0;
			std::map<std::string,int> countByPlayer;
			for (y=0;y<nbplayer;y++)
			{
				countByPlayer[listPlay[y].getName()]=0;
			}
			int miniCount=0;
			for (m1=-1;m1<2;m1++)
			for (n1=-1;n1<2;n1++)
			{
				if (m1==0&&n1==0) continue;
				if (m+m1+(width*(n1+n))>0&&m+m1+(width*(n1+n))<width*height&&ret[m+m1+(width*(n1+n))].getPlayer()!=NULL)
				{
					Player *pp=ret[m+m1+(width*(n1+n))].getPlayer();
					if (pp!=NULL)
					countByPlayer[pp->getName()]++;
					miniCount++;
				}
			}
			
			/*
			Player *choosed=NULL;
			int max=0;
			for (y=0;y<nbplayer;y++)
			{
				if (countByPlayer[listPlay[y].getName()]>max)
				{
					max=countByPlayer[listPlay[y].getName()];
					choosed=&listPlay[y];
				}
			}
			if (ret[m+(width*(n))].getPlayer()==NULL && max>2)
			{
				ret[m+(width*(n))].setPlayer(choosed);
				ret[m+(width*(n))].setCaseType(Case::FREE);
			}
			else
			{
				if (max>10)
				ret[m+(width*(n))].setPlayer(choosed);
			}
			*/
			if (ret[m+(width*(n))].getPlayer()==NULL && miniCount>3)
			{
				ret[m+(width*(n))].setPlayer(&listPlay[0]);
				ret[m+(width*(n))].setCaseType(Case::FREE);
			}
			
			


		}
	
	}
	int m=0,n=0;
	/*
	//Correct free case
	int miniCount=1;
	
	bool oneChange=true;

		oneChange=false;
		for (m=0;m<width;m++)
		for (n=0;n<height;n++)
		{
			int m1=0,n1=0;
		
			miniCount=0;
			for (m1=-1;m1<2;m1++)
			for (n1=-1;n1<2;n1++)
			{
				if (m1==0&&n1==0) continue;
				if (ret[m+m1+(width*(n1+n))].getPlayer()!=NULL&&m+m1+(width*(n1+n))>0&&m+m1+(width*(n1+n))<width*height)
				{
					
					miniCount++;
				}
			}

			if (miniCount==0)
			{
				//search earth
				oneChange=true;
				int x=(rand.nextInt()%3)-1;
				int y=(rand.nextInt()%3)-1;
				if (x!=0&&y!=0&&x+(width*(y))>0&&x+(width*(y))<width*height)
				{
					ret[x+(width*(y))].setPlayer(&listPlay[0]);
					ret[x+(width*(y))].setCaseType(Case::FREE);
				}
			}
		}
		*/
	//Repartition by player
	int nbcasess=0;
	for (int x=0;x<width;x++)
	for (int y=0;y<height;y++)
	{
		if (ret[x+(width*(y))].getPlayer()!=NULL)
		{
			nbcasess++;
		}
	}
	int actualPlayerCounter=0;
	int actualIndexPlayer=0;
	for (m=0;m<width;m++)
		for (n=0;n<height;n++)
		{
			if (ret[m+(width*(n))].getPlayer()!=NULL){
				
				ret[m+(width*(n))].setPlayer(&listPlay[actualIndexPlayer]);
				ret[m+(width*(n))].setPreviousPlayer(&listPlay[actualIndexPlayer]);
				if (actualPlayerCounter==(nbcasess)/(nbplayer)/2)
				{
					ret[m+(width*(n))].setCityCenter(true);
				}
				actualPlayerCounter++;
				if(actualPlayerCounter>(nbcasess)/(nbplayer))
				{
					actualPlayerCounter=0;
					
					actualIndexPlayer++;

				}
			}
		}

	//clean empty string
	for (m=0;m<width;m++)
	for (n=0;n<height;n++)
	{
		if (ret[m+(width*(n))].getPlayer()!=NULL){
			if (ret[m+(width*(n))].getPlayer()->getName().empty())
			{
				ret[m+(width*(n))].setPlayer(NULL);
				ret[m+(width*(n))].setCaseType(Case::NOTUSED);
			}
		}
	}
	return ret;

}


Case * MapGenerator::generateMap(int nbplayer,int width,int height){
	
	bool isOk=false;
	Case *ret;
	int loop=0;
	while (!isOk)
	{
		std::stringstream mm;
		mm<<"Generation Loop "<<loop<<" ...";
		if (writemessage!=NULL)
			(*writemessage)("Game info",mm.str());
		ret=generateMapIntern( nbplayer, width, height);
		if (isCaseAlone(ret,width, height)||!searchConnectecdPlayer(ret,nbplayer,width,height))
		{
			isOk=false;
			delete []ret;
		}
		else
		{
			isOk=true;
		}
	}

	return ret;
}

bool MapGenerator::isCaseAlone(Case * ret,int width,int height){
	bool oneChange=false;
	int m,n;
	for (m=0;m<width;m++)
		for (n=0;n<height;n++)
		{
			if (ret[m+(width*(n))].getPlayer()!=NULL)
			{
				int m1=0,n1=0;
		
				int miniCount=0;
				for (m1=-1;m1<2;m1++)
				for (n1=-1;n1<2;n1++)
				{
					if (m1==0&&n1==0) continue;
					if (m+m1+(width*(n1+n))>0&&m+m1+(width*(n1+n))<width*height&&ret[m+m1+(width*(n1+n))].getPlayer()!=NULL)
					{
						
						miniCount++;
						
					}
				}

				if (miniCount==0)
				{
					//search earth
					oneChange=true;
					
				
				}
			}
		}

	return oneChange;
}

bool MapGenerator::isCaseAloner(Case * ret,int width,int height,int x,int y,int noX,int noY){
	bool oneChange=false;
	
	return oneChange;
}


int MapGenerator::countConnectecdPlayer(Case * ret,Player *a,int width,int height,int x,int y){
	bool oneChange=false;
	int count=0;
	if (!ret[x+(width*(y))].isColored())
	{
		ret[x+(width*(y))].setColored(true);
		if (ret[x+(width*(y))].getPlayer()!=NULL)
		{
			
			if (ret[x+(width*(y))].getPlayer()->getName()==a->getName())
			{
				count++;
				int m1=0,n1=0;
				for (m1=-1;m1<2;m1++)
				for (n1=-1;n1<2;n1++)
				{
					if (m1==0&&n1==0) continue;
					if (x+m1+(width*(n1+y))>0&&x+m1+(width*(n1+y))<width*height)
						{
						
							count+=countConnectecdPlayer(ret,a,width,height,x+m1,y+n1);
						
						}
					}
			}

		}
	}
	return count;
}

bool MapGenerator::searchConnectecdPlayer(Case * ret,int player,int width,int height){
	std::map<std::string ,int> listPlayer;
	int y,x;
	//Clean Cases
	for (y=0;y<width*height;y++)
	{
		ret[y].setColored(false);
	}
	int nbcasess=0;
	for (x=0;x<width;x++)
	for (y=0;y<height;y++)
	{
		if (ret[x+(width*(y))].getPlayer()!=NULL)
		{
			nbcasess++;
			if (listPlayer.find(ret[x+(width*(y))].getPlayer()->getName())==listPlayer.end())
			{
				int z=0;
				for (z=0;z<width*height;z++)
				{
					ret[z].setColored(false);
				}
				if (ret[x+(width*(y))].getPlayer()->getName()!="")
				listPlayer[ret[x+(width*(y))].getPlayer()->getName()]=countConnectecdPlayer(ret,ret[x+(width*(y))].getPlayer(), width, height, x, y);
			}
		}
	}

	std::map<std::string ,int>::iterator itt=listPlayer.begin();
	while (itt!=listPlayer.end())
	{
		int nbcase=nbcasess/(player);
		int nbcasep5=(int)(((double)nbcase)*1.05);
		int nbcasem5=(int)(((double)nbcase)*0.95);

		if ((itt)->second>nbcasep5||(itt)->second<nbcasem5)
		{
			return false;
		}
		itt++;
	}

	return true;
}