/* opcodes.h: -*- C -*-  DESCRIPTIVE TEXT. */

/* Author: Brian J. Fox (bfox@ai.mit.edu) Sat Jul 20 09:31:28 1996.

   This file is part of <Meta-HTML>(tm), a system for the rapid deployment
   of Internet and Intranet applications via the use of the Meta-HTML
   language.

   Copyright (c) 1995, 1996, Brian J. Fox (bfox@ai.mit.edu).
   Copyright (c) 1996, Universal Access Inc. (http://www.ua.com).

   Meta-HTML is free software; you can redistribute it and/or modify
   it under the terms of the UAI Free Software License as published
   by Universal Access Inc.; either version 1, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   UAI Free Software License for more details.

   You should have received a copy of the UAI Free Software License
   along with this program; if you have not, you may obtain one by
   writing to:

   Universal Access Inc.
   129 El Paseo Court
   Santa Barbara, CA
   93101  */

#if !defined (_OPCODES_H_)
#define _OPCODES_H_

/* The virtual Meta-HTML machine works with a instruction stream which
   contains instructions and data.  Unlike the interpreted model, each
   byte read consists of a valid instruction, followed by optional
   data.  The data is either:

      a) A reference to a global variable
      b) A reference to a local variable
      c) Plain text.

*/
/* 
<defun x foo bar>
   <while <lt foo 10>>
     The value of foo is <get-var foo>
     <increment foo>
   </while>
</defun>

DATA <compilee-code-for-x>
            JUMP while-1
    LAB while-1-test
	    SGET 0
	    DATA 10
	    LT
	    RET

    WHILE-1:			;;; <while <lt foo 10>>
	    CALL WHILE-1-TEST
	    JFALSE WHILE-1-EXIT
	    DATA "The value of foo is "
	    PUT
	    DATA FOO		;;; <get-var foo>
	    VGET
	    PUT
	    DATA "\n"
	    PUT
	    DATA FOO		;;; <increment foo>
	    DATA FOO
	    VGET
	    DATA 1
	    ADD
	    VSET
	    JUMP WHILE-1

DATA X
FSET

<x 1 this>
FGET X
DATA 1
DATA "this"
CALL 2

<x <get-var x> <get-var y>>
FGET X
DATA "x"
VGET
DATA "y"
VGET
CALL 2

   <set-var foo=1 bar=this>
   <while <lt foo 10>>
     The value of foo is <get-var foo>
     <increment foo>
   </while>

BEGIN:	CURRENT_PACKAGE		;;; <x <get-var x> <get-var y>>
	DATA X			;;; <get-var x>
	VGET
	DATA Y			;;; <get-var y>
	VGET
	;;; Start of <x...>
	DATA X
	FUNCALL
	RETURN

X:	LOCAL_PACKAGE
        DATA BAR
        VSET
	DATA FOO		;;; <set-var =1>
	VSET
	JMP  WHILE-1


BEGIN:	LOCAL_PACKAGE		;;;
        DATA FOO		;;; <set-var foo=1>
        DATA 1
        VSET
	DATA BAR		;;; <set-var bar=1>
	DATA THIS
	VSET
	JMP  WHILE-1

WHILE-1-TEST:			;;; <lt foo 10>
	DATA FOO
	VGET
	DATA 10
	LT
	RET

WHILE-1:			;;; <while <lt foo 10>>
	CALL WHILE-1-TEST
	JFALSE WHILE-1-EXIT
	DATA "The value of foo is "
	PUT
	DATA FOO		;;; <get-var foo>
	VGET
	PUT
	DATA "\n"
	PUT
	DATA FOO		;;; <increment foo>
	DATA FOO
	VGET
	DATA 1
	ADD
	VSET
	JUMP WHILE-1

WHILE-1-EXIT:
END:

*/


#define op_DATA	'a'
#define op_VGET 'b'
#define op_VSET 'c'
#define op_TCAT 'd'
