/* modo.h

   written by Frederic Bois
   27 November 1997

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

   Header file for outputing routines.
*/

#ifndef _MODO_H_


/* ---------------------------------------------------------------------------
   Constants  */

#define ALL_VARS (0)

#ifndef FILENAME_MAX
#define FILENAME_MAX 40
#endif


/* ---------------------------------------------------------------------------
   Typedefs */

typedef int (*PFI_CALLBACK) (PFILE, PVMMAPSTRCT, PVOID);


/* ---------------------------------------------------------------------------
   Macros */

#define WriteIndexName(pfile, pvm)  (fprintf ((pfile), "ID_%s", (pvm)->szName))


/* ---------------------------------------------------------------------------
   Prototypes */

int   ForAllVar (PFILE pfile, PVMMAPSTRCT pvm, PFI_CALLBACK pfiFunc,
                 HANDLE hType, PVOID pinfo);
int   CountOneDecl (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
int   WriteOneName (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  WriteHeader (PFILE pfile, PSTR szName, PVMMAPSTRCT pvmGlo);
void  WriteIncludes (PFILE pfile);
int   WriteOneDecl (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
int   WriteOneIndexDefine (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  WriteDecls (PFILE pfile, PVMMAPSTRCT pvmGlo);
PSTR  GetName (PVMMAPSTRCT pvm, PSTR szModelVarName, PSTR szDerivName, 
               HANDLE hType);
int   WriteOneVMEntry (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  WriteVarMap (PFILE pfile, PVMMAPSTRCT pvmGlo);
int   WriteOneInit (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  WriteInitModel (PFILE pfile, PVMMAPSTRCT pvmGlo);
void  TranslateID (PINPUTBUF pibDum, PFILE pfile, PSTR szLex, int iEqType);
void  TranslateEquation (PFILE pfile, PSTR szEqn, int iEqType);
int   WriteOneEquation (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  WriteCalcDeriv (PFILE pfile, PVMMAPSTRCT pvmGlo, PVMMAPSTRCT pvmDyn);
void  WriteScale (PFILE pfile, PVMMAPSTRCT pvmGlo, PVMMAPSTRCT pvmScale);
void  WriteCalcJacob (PFILE pfile, PVMMAPSTRCT pvmGlo, PVMMAPSTRCT pvmJacob);
void  WriteCalcOutputs (PFILE pfile, PVMMAPSTRCT pvmGlo, 
                        PVMMAPSTRCT pvmCalcOut);
int   IndexOneVar (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  IndexVariables (PVMMAPSTRCT pvmGlo);
int   AdjustOneVar (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  AdjustVarHandles (PVMMAPSTRCT pvmGlo);
void  ReversePointers (PVMMAPSTRCT *ppvm);
int   AssertExistsEqn (PFILE pfile, PVMMAPSTRCT pvm, PVOID pInfo);
void  VerifyEqns (PVMMAPSTRCT pvmGlo, PVMMAPSTRCT pvmDyn);
void  MakeCodeFilename (PSTR szNewName, PSTR szName);
void  WriteModel (PINPUTINFO pinfo, int nArg, PSTR rgszArgs[]);

#define _MODO_H_
#endif

/* End */


