/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This file is part of GNU LibreJS.
 *
 * GNU LibreJS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNU LibreJS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU LibreJS.  If not, see <http://www.gnu.org/licenses/>.
 */


exports.longString = "\n\n LibreJS Information\n\n Current Version: 2.4.2 -- 12/08/2011\n \n Copyright (C) 2011 Loic J. Duros.\n Permission is granted to copy, distribute and/or modify this document\n under the terms of the GNU Free Documentation License, Version 1.3\n or any later version published by the Free Software Foundation;\n with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.\n A copy of the license is included in the section entitled \"GNU\n Free Documentation License\".\n \n\nPlain text copy\nA plain text copy of this documentation is available here.\n\nOverview\nLibreJS is an add-on for GNU IceCat (Mozilla Firefox, Abrowser, Iceweasel, …) that\nprevents the execution of nonfree nontrivial JavaScript as described\nin \"The Javascript Trap\":\nhttp://www.gnu.org/philosophy/javascript-trap.html\nIt has been tested for Firefox 7. Please see the Known issues section\nin this document before using LibreJS.\n\nDisclaimer\n\nLibreJS is not a security tool and while its goal is to detect nonfree\n nontrivial JavaScript, it does not detect whether free or trivial\n code is malicious or not. You can use NoScript (or YesScript) in\n conjunction with LibreJS to ensure security of the JavaScript being\n loaded.\nBecause LibreJS intercepts http responses to analyze and remove\n JavaScript from a page, it will not analyze and block JavaScript if\n it is loaded locally as a file within the user's filesystem, for\n instance with file:///home/someone/test.html -- a request\n http://localhost, however, would be caught and analyzed by the\n add-on.\nLibreJS is always a work in progress. If you find a bug, please\n report it to lduros@gnu.org\n\n\nChanges from version 2.4.1 to version 2.4.2\nSee changelog.\n\nChanges from version 1.x to version 2\n1) The @licstart @licend stylized comments are now obligatory rather\nthan optional. We want to make sure an entire page is explicitely free\nbefore considering it as free.\n2) In version 1, all scripts that defined a function or method were\nflagged as nontrivial. In version 2, as described in The JavaScript\nTrap, it will only consider the JavaScript program as nontrivial if\nthe scripts define a function or a method and load external scripts\nusing the html <script> tag, or if an external script defines a method\nor a function. \n3) In the version 1, scripts on page and remote were analyzed individually.\n In version 2 (current version):\n \n all scripts that are directly embedded in an html page are\n analyzed as one to see whether they are trivial or free.\n If the on-page JavaScript is nonfree and nontrivial, all\n JavaScript is removed and none of the external files are\n analyzed.\n If the on-page JavaScript is free or trivial, the external\n scripts are then fetched and analyzed to find whether they are\n free or trivial individually.\n If any script, on-page or external, is found to be nontrivial,\n all JavaScript is removed from the page (inline scripts,\n intrinsec events in html attributes, external scripts, ...)\n If any free script is found to perform an AJAX request or embed\n another script dynamically, or any construct that is flagged as\n \"suspicious\", then any trivial code becomes \"nontrivial\", and\n all JavaScript is then removed.\n When all the code is free but loads JavaScript dynamically, all\n http responses of mime type javascript are checked to see\n whether they are free/trivial at request time, and rejected if\n they are nonfree nontrivial.\n\n4) In version 1, a pure JavaScript HTML partial parser was used to\n find <script> tags and other JavaScript elements on page. In\n version 2, we are using a heavily modified third-party script to\n load the http response intercepted into a hidden iframe with a data\n uri (the hidden iframe has JavaScript off, as well as plugins off,\n following the instructions in\n https://developer.mozilla.org/En/Displaying_web_content_in_an_extension_without_security_issues). \n We are then using JavaScript DOM methods to fetch and remove\n scripts. This new method is a lot more secure and less prone to\n forgetting some of the JavaScript or not finding weird\n constructs. It also removes parts of the issue with the freezing\n UI.\n5) We are now using the url module from the Node.js project\n (http://nodejs.org/) to convert relative path into absolute urls\n when the DOM is loaded with a data uri.\n\nScreenshots\n\n\n\nThe panel that shows the blocked JavaScript:\n http://lduros.net/assets/librejs/v1/screenshots/librejs-v1-blockedscript-panel.jpg\n\nThe preferences panel:\n http://lduros.net/assets/librejs/v1/screenshots/librejs-v1-preferences.jpg\n\n\n\nLicense\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program. If not, see http://www.gnu.org/licenses/.\n\nHow to use\n\nAfter installing the add-on, you will see the LibreJS widget in the\nadd-on bar at the bottom of the browser window. After loading a page,\nleft-click on the widget to view the list of JavaScript removed from\nthe page (both on page and external). Up to 1000 characters are\ndisplayed per Javascript piece, since some files are so large it\nbecomes impractical to display them in their entirety. See screenshot\nhere: \nhttp://lduros.net/assets/librejs/v1/screenshots/librejs-v1-blockedscript-panel.jpg\nYou can also take a look at the JS removed by looking at the\npage source: CTRL + U.\n\nLibreJS intercepts http responses and rewrites them after analyzing\nJavaScript within them. While it uses mime types to a certain extent,\nit does not rely only on them and attempts to analyze any file for\njavascript content (a content sniffer of some sort is on the way for a\nfuture release).\n\nThe add-on offers a few options (and more to come). You can access\nthese options by right-clicking the widget. Please ignore the add-on\ncontext menu that will appear (this is a bug with Firefox and the\nadd-on sdk).\n\nA panel should appear in the middle of the page, with two checkboxes\navailable: \nhttp://lduros.net/assets/librejs/v1/screenshots/librejs-v1-preferences.jpg\nCurrently, LibreJS searches for license mentions in two\nways, a short and a lazy way (the latter is optional). One uses\nexcerpts from the short notices usually provided by many licenses for\ninclusion within source files, e.g. for the GPLv2: \n <THISPROGRAM> is free software; you can redistribute it\n and/or modify it under the terms of the GNU General Public\n License as published by the Free Software Foundation; either\n version 2 of the License, or (at your option) any later\n version.\nWhen it finds a match, it flags the piece of JS as free. This is\ncalled short definition. Another type of notice we call \"lazy\", here\nis a popular example: \n Dual licensed under the MIT or GPL Version 3 licenses \nWhen the \"Do not tolerate lazy license mentions\" checkbox is checked,\nthe latter type of license mention is not used.\n\nTests\nIn order to better understand how LibreJS works, you can try to visit\nthese pages with LibreJS installed and enabled and see how they are\nbeing processed:\n\n1) http://lduros.net/assets/librejs/tests/trivial-inline-trivial-external/\n This page contains trivial on-page JavaScript code, and an external\n script that contains trivial JavaScript code.\n Therefore, all JavaScript is being executed.\n\n2) http://lduros.net/assets/librejs/tests/trivial-inline-nontrivial-external/\n This page contains trivial on-page JavaScript code, but loads an\n external script that defines a function (nontrivial) and is not\n free.\n Therefore, all JavaScript is REMOVED from the page.\n\n3) http://lduros.net/assets/librejs/tests/nontrivial-inline-trivial-external/\n This page contains nontrivial code on page, and trivial code in its\n external page.\n All JavaScript is REMOVED from the page.\n\n4) http://lduros.net/assets/librejs/tests/free-inline-free-external/\n This page contains free on-page (GPL 3) JavaScript, and free\n external Javascript. Therefore all JavaScript is being executed.\n\n5) http://lduros.net/assets/librejs/tests/free-inline-nonfree-nontrivial-external/\n This page contains free on-page JavaScript, but contains nonfree\n nontrivial JavaScript in its external file (ajax request).\n All JavaScript is REMOVED from the page.\n\n6) http://lduros.net/assets/librejs/tests/intrinsec-event/\n This page contains trivial on-page code, with an intrinsec event in\n an html attribute (onload).\n All JavaScript is being executed.\n\n7) http://lduros.net/assets/librejs/tests/trivial-inline-free-external-defines-function/\n This page contains on-page trivial JavaScript (only makes a window\n alert and loads an external script using the html <script> tag with the\n src attribute. The external script is free (GPL v3), and since it\n is only nontrivial because it defines a function, the on-page\n trivial code is allowed to use it.\n All JavaScript is being executed.\n\n8) http://lduros.net/assets/librejs/tests/trivial-inline-free-external-writes-script/\n This page contains trivial on-page JavaScript code, and loads an\n external script that is free.\n HOWEVER, this free external script loads a script\n dynamically. Therefore, since trivial code might be using it, no\n trivial code is allowed.\n Since the on-page trivial code is now nontrivial,\n all Javascript is REMOVED from the page.\n\n9) http://lduros.net/assets/librejs/tests/shelltypist/demo/real-life-example-with-jquery-free.html\n This is a real-life example of a small jQuery plugin. The on-page\n JavaScript code has a free license. The jQuery external file has a\n free (but lazily defined) licensed. The shelltypist.js file has a\n free license as well. All licenses are defined between @licstart\n and @licend. If the \"Do not consider lazy license mentions as free\"\n option is not checked (default), the JavaScript is executed,\n despite the fact that the jQuery license mentions is: \n Dual licensed under the MIT or GPL Version 2 licenses.\n If you check the \"Do not consider lazy license mentions as free\"\n option, then ALL JavaScript will be removed from the page after\n reload.\n\n10) http://lduros.net/assets/librejs/tests/shelltypist/demo/same-page-without-free-license.html\n This is the same page than 9) but does not have a free license for\n the main HTML page on-page script. While the actual code there is\n trivial, since jQuery defines methods that make use of AJAX,\n trivial code is not allowed, and no JavaScript is executed.\n\nOptions\n\n\nDo not tolerate lazy license mentions (e.g.: dual-licensed under\n ...)\n When checked, this option disallows the use of very brief\n mentions of a license. (\"Released under the MIT license\", ...)\n\n\nHow LibreJS detects nontrivial JavaScript\n\nLibreJS uses Narcissus lexer/parser\n(https://github.com/mozilla/narcissus) to perform a static check for a\nfew criteria: \n\nIf the program defines a method or a function and loads external\nscripts (using the <script> element and src attribute).\nIf the program has an external script and defines a function or a\nmethod.\nIf it makes an AJAX request using XMLHttpRequest or ActiveXObject.\nIf it loads an external script (creates a script tag somewhere in the\ndom).\n\nBecause the code isn't interpreted (static analysis only) and we don't\nkeep track of scope and what variables contain, we have to discard a\nfew constructs:\n- if eval() is used.\n- if methods are invoked using the bracket suffix, such as:\nt['meth'+'od'](arg);\n- if it using document.write() with a concatenation or a function\ncall.\nFree Licenses\nCurrently LibreJS checks for the following licenses:\n\n GNU General Public License version 2\n GNU General Public License version 3\n GNU All-Permissive License\nLesser GNU Public License version 2.1\nLesser GNU Public License version 3\n Apache License, Version 2.0\n GNU Affero General Public License version 3\n Boost Software License\n BSD 2-Clause License\n BSD 3-Clause License\n Mozilla Public License Version 1.1\n Expat License\n\n\nMore licenses are on the way for the upcoming versions.\nKnown issues of LibreJS version 2\n\nLibreJS currently analyzes the JavaScript on page and in the\n Javascript file using the same thread as the Mozilla Firefox\n browser. Depending on hardware, this causes the UI to freeze for a\n second or two when a large javascript file is being analyzed. I am\n planning on using a chrome worker for Narcissus in the near future\n (version 2), so that it can run in its own thread. This way large\n complex files won't freeze the UI. 11/14/2011 UPDATE: This has been\n partly addressed with the replacement of the recursive walkTree\n function with the iterative one.\nIt does not make good use of the caching system. Instead it dooms\n the cache entry when the response is of type text/html or\n javascript.\n\n\nFixed in version 2.2:\n- FIXED: Currently there is no option to interpret javascript in the current\n page or javascript file. In order to enable all Javascript back, you\n must disable the add-on, but it does not require a Firefox\n restart. A button is planned for the future release.\n\nFIXED: Clicking on an anchor link in the page currently loaded in the tab,\n or appending a #[anything] to the location bar will prevent the\n widget panel from displaying the removed Javascript. This is due to\n the fact that it tracks JS according to the url, and so the # is\n considered a new entry. However, the JavaScript is still being\n blocked properly. (Check source for that.)\n\nGNU Free Documentation Licence\nA verbatim copy of the GNU Free Documentation license is available here\n ";
