/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.NFKC;
import gnu.inet.encoding.RFC3454;
import gnu.inet.encoding.RangeSet;
import gnu.inet.encoding.StringprepException;
import java.util.Arrays;

public class Stringprep {
    private static final RangeSet.Range[] NODEPREP_PASSTHROUGH_RANGES = new RangeSet.Range[]{new RangeSet.Range(91, 126), new RangeSet.Range(48, 57), new RangeSet.Range(40, 46)};
    private static final RangeSet.Range[] NAMEPREP_PASSTHROUGH_RANGES = new RangeSet.Range[]{new RangeSet.Range(91, 127), new RangeSet.Range(0, 64)};
    private static final RangeSet.Range[] RESOURCEPREP_PASSTHROUGH_RANGES = new RangeSet.Range[]{new RangeSet.Range(32, 126)};
    private static final RangeSet RANGE_A1 = RangeSet.builder().addRanges(RFC3454.A1).build();
    private static final RangeSet RANGE_B1 = RangeSet.builder().addRanges(RFC3454.B1).build();
    private static final RangeSet RANGE_D1 = RangeSet.builder().addRanges(RFC3454.D1).build();
    private static final RangeSet RANGE_D2 = RangeSet.builder().addRanges(RFC3454.D2).build();
    private static final RangeSet RANGE_C3_to_C8_C12_C22 = RangeSet.builder().addRanges(RFC3454.C12).addRanges(RFC3454.C22).addRanges(RFC3454.C3).addRanges(RFC3454.C4).addRanges(RFC3454.C5).addRanges(RFC3454.C6).addRanges(RFC3454.C7).addRanges(RFC3454.C8).addRange(new RangeSet.Range(65535, 0x10FFFF)).build();
    private static final char[] RFC3920_NODEPREP_PROHIBIT = new char[]{'\"', '&', '\'', '/', ':', '<', '>', '@'};
    private static final RangeSet RANGE_C3_TO_C8_C11_12_21_22_NP_PROHIB = RangeSet.builder().addRanges(RFC3454.C3).addRanges(RFC3454.C4).addRanges(RFC3454.C5).addRanges(RFC3454.C6).addRanges(RFC3454.C7).addRanges(RFC3454.C8).addRanges(RFC3454.C11).addRanges(RFC3454.C12).addRanges(RFC3454.C21).addRanges(RFC3454.C22).addRanges(RFC3920_NODEPREP_PROHIBIT).addRange(new RangeSet.Range(65535, 0x10FFFF)).build();
    private static final RangeSet RANGE_C3_to_C8_C12_C21_C22 = RangeSet.builder().addRanges(RFC3454.C12).addRanges(RFC3454.C21).addRanges(RFC3454.C22).addRanges(RFC3454.C3).addRanges(RFC3454.C4).addRanges(RFC3454.C5).addRanges(RFC3454.C6).addRanges(RFC3454.C7).addRanges(RFC3454.C8).addRange(new RangeSet.Range(65535, 0x10FFFF)).build();

    public static String nameprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.nameprep(string, false);
    }

    public static String nameprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        RangeSet.Range range = RangeSet.createTextRange((CharSequence)string);
        if (Stringprep.onlyPassThrough(NAMEPREP_PASSTHROUGH_RANGES, range)) {
            return string;
        }
        if (!bl && RANGE_A1.containsAnyCodePoint((CharSequence)string, range)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        Stringprep.filter(stringBuilder, RANGE_B1);
        Stringprep.map(stringBuilder, RFC3454.B2search, RFC3454.B2replace);
        stringBuilder = new StringBuilder(NFKC.normalizeNFKC(stringBuilder.toString()));
        RangeSet.Range range2 = RangeSet.createTextRange((CharSequence)stringBuilder);
        if (RANGE_C3_to_C8_C12_C22.containsAnyCodePoint((CharSequence)stringBuilder, range2)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = RANGE_D1.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        boolean bl3 = RANGE_D2.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || RANGE_D1.contains((int)stringBuilder.charAt(0)) && RANGE_D1.contains((int)stringBuilder.charAt(stringBuilder.length() - 1)))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuilder.toString();
    }

    public static String nodeprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.nodeprep(string, false);
    }

    public static String nodeprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        RangeSet.Range range = RangeSet.createTextRange((CharSequence)string);
        if (Stringprep.onlyPassThrough(NODEPREP_PASSTHROUGH_RANGES, range)) {
            return string;
        }
        if (!bl && RANGE_A1.containsAnyCodePoint((CharSequence)string, range)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        Stringprep.filter(stringBuilder, RANGE_B1);
        Stringprep.map(stringBuilder, RFC3454.B2search, RFC3454.B2replace);
        stringBuilder = new StringBuilder(NFKC.normalizeNFKC(stringBuilder.toString()));
        RangeSet.Range range2 = RangeSet.createTextRange((CharSequence)stringBuilder);
        if (RANGE_C3_TO_C8_C11_12_21_22_NP_PROHIB.containsAnyCodePoint((CharSequence)stringBuilder, range2)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = RANGE_D1.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        boolean bl3 = RANGE_D2.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || RANGE_D1.contains((int)stringBuilder.charAt(0)) && RANGE_D1.contains((int)stringBuilder.charAt(stringBuilder.length() - 1)))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuilder.toString();
    }

    public static String resourceprep(String string) throws StringprepException, NullPointerException {
        return Stringprep.resourceprep(string, false);
    }

    public static String resourceprep(String string, boolean bl) throws StringprepException, NullPointerException {
        if (string == null) {
            throw new NullPointerException();
        }
        RangeSet.Range range = RangeSet.createTextRange((CharSequence)string);
        if (Stringprep.onlyPassThrough(RESOURCEPREP_PASSTHROUGH_RANGES, range)) {
            return string;
        }
        if (!bl && RANGE_A1.containsAnyCodePoint((CharSequence)string)) {
            throw new StringprepException(StringprepException.CONTAINS_UNASSIGNED);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        Stringprep.filter(stringBuilder, RANGE_B1);
        stringBuilder = new StringBuilder(NFKC.normalizeNFKC(stringBuilder.toString()));
        RangeSet.Range range2 = RangeSet.createTextRange((CharSequence)stringBuilder);
        if (RANGE_C3_to_C8_C12_C21_C22.containsAnyCodePoint((CharSequence)stringBuilder, range2)) {
            throw new StringprepException(StringprepException.CONTAINS_PROHIBITED);
        }
        boolean bl2 = RANGE_D1.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        boolean bl3 = RANGE_D2.containsAnyCodePoint((CharSequence)stringBuilder, range2);
        if (bl2 && bl3) {
            throw new StringprepException(StringprepException.BIDI_BOTHRAL);
        }
        if (!(!bl2 || RANGE_D1.contains((int)stringBuilder.charAt(0)) && RANGE_D1.contains((int)stringBuilder.charAt(stringBuilder.length() - 1)))) {
            throw new StringprepException(StringprepException.BIDI_LTRAL);
        }
        return stringBuilder.toString();
    }

    private static boolean onlyPassThrough(RangeSet.Range[] rangeArray, RangeSet.Range range) {
        for (RangeSet.Range range2 : rangeArray) {
            if (!range2.contains(range)) continue;
            return true;
        }
        return false;
    }

    static void filter(StringBuilder stringBuilder, RangeSet rangeSet) {
        int n = 0;
        while (n < stringBuilder.length()) {
            if (rangeSet.contains((int)stringBuilder.charAt(n))) {
                stringBuilder.deleteCharAt(n);
                continue;
            }
            ++n;
        }
    }

    static void map(StringBuilder stringBuilder, char[] cArray, String[] stringArray) {
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            int n = Arrays.binarySearch(cArray, c);
            if (n < 0) continue;
            String string = stringArray[n];
            stringBuilder.replace(i, i + 1, string);
            i += string.length() - 1;
        }
    }
}

