/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.StableVector;
import gnu.lists.SubCharSeq;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class CharBuffer
extends StableVector
implements CharSeq,
Serializable {
    private FString string;

    public CharBuffer(FString fString) {
        super(fString);
        this.string = fString;
    }

    public CharBuffer(int n) {
        this(new FString(n));
    }

    protected CharBuffer() {
    }

    public int length() {
        return this.size();
    }

    public char charAt(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.string.charAt(n);
    }

    public int indexOf(int n, int n2) {
        char c;
        char c2;
        if (n >= 65536) {
            c2 = (char)((n - 65536 >> 10) + 55296);
            c = (char)((n & 0x3FF) + 56320);
        } else {
            c2 = (char)n;
            c = '\u0000';
        }
        char[] cArray = this.getArray();
        int n3 = n2;
        int n4 = this.gapStart;
        if (n3 >= n4) {
            n3 += this.gapEnd - this.gapStart;
            n4 = cArray.length;
        }
        while (true) {
            if (n3 == n4) {
                n4 = cArray.length;
                if (n3 >= n4) break;
                n3 = this.gapEnd;
            }
            if (cArray[n3] == c2 && (c == '\u0000' || (n3 + 1 < n4 ? cArray[n3 + 1] == c : this.gapEnd < cArray.length && cArray[this.gapEnd] == c))) {
                return n3 > this.gapStart ? n3 - (this.gapEnd - this.gapStart) : n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOf(int n, int n2) {
        char c;
        char c2;
        if (n >= 65536) {
            c2 = (char)((n - 65536 >> 10) + 55296);
            c = (char)((n & 0x3FF) + 56320);
        } else {
            c2 = '\u0000';
            c = (char)n;
        }
        int n3 = n2;
        while (--n3 >= 0) {
            if (this.charAt(n3) != c) continue;
            if (c2 == '\u0000') {
                return n3;
            }
            if (n3 <= 0 || this.charAt(n3 - 1) != c2) continue;
            return n3 - 1;
        }
        return -1;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4;
        int n5;
        char[] cArray2 = this.string.data;
        if (n < this.gapStart && (n5 = (n2 < this.gapStart ? n2 : this.gapStart) - n) > 0) {
            System.arraycopy(cArray2, n, cArray, n3, n5);
            n += n5;
            n3 += n5;
        }
        if ((n5 = (n2 += (n4 = this.gapEnd - this.gapStart)) - (n += n4)) > 0) {
            System.arraycopy(cArray2, n, cArray, n3, n5);
        }
    }

    public void setCharAt(int n, char c) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        this.string.setCharAt(n, c);
    }

    public String substring(int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        n = this.getSegment(n, n4);
        return new String(this.getArray(), n, n4);
    }

    public CharSequence subSequence(int n, int n2) {
        int n3 = this.size();
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new SubCharSeq(this, this.base.createPos(n, false), this.base.createPos(n2, true));
    }

    public void fill(int n, int n2, char c) {
        int n3;
        int n4;
        char[] cArray = this.string.data;
        int n5 = n4 = this.gapStart < n2 ? this.gapStart : n2;
        for (n3 = n; n3 < n4; ++n3) {
            cArray[n3] = c;
        }
        int n6 = this.gapEnd - this.gapStart;
        n3 = n4 + n6;
        n4 += n2;
        while (n3 < n4) {
            cArray[n3] = c;
            ++n3;
        }
    }

    public final void fill(char c) {
        char[] cArray = this.string.data;
        int n = cArray.length;
        while (--n >= this.gapEnd) {
            cArray[n] = c;
        }
        n = this.gapStart;
        while (--n >= 0) {
            cArray[n] = c;
        }
    }

    public char[] getArray() {
        return (char[])this.base.getBuffer();
    }

    public void delete(int n, int n2) {
        int n3 = this.createPos(n, false);
        this.removePos(n3, n2);
        this.releasePos(n3);
    }

    public void insert(int n, String string, boolean bl) {
        int n2 = string.length();
        this.gapReserve(n, n2);
        string.getChars(0, n2, this.string.data, n);
        this.gapStart += n2;
    }

    public void consume(int n, int n2, Consumer consumer) {
        char[] cArray = this.string.data;
        if (n < this.gapStart) {
            int n3 = this.gapStart - n;
            if (n3 > n2) {
                n3 = n2;
            }
            consumer.write(cArray, n, n3);
            n += (n2 -= n3);
        }
        if (n2 > 0) {
            consumer.write(cArray, n += this.gapEnd - this.gapStart, n2);
        }
    }

    public String toString() {
        int n = this.size();
        int n2 = this.getSegment(0, n);
        return new String(this.getArray(), n2, n);
    }

    public void writeTo(int n, int n2, Appendable appendable) throws IOException {
        if (appendable instanceof Writer) {
            this.writeTo(n, n2, (Writer)appendable);
        } else {
            appendable.append(this, n, n + n2);
        }
    }

    public void writeTo(Appendable appendable) throws IOException {
        this.writeTo(0, this.size(), appendable);
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        char[] cArray = this.string.data;
        if (n < this.gapStart) {
            int n3 = this.gapStart - n;
            if (n3 > n2) {
                n3 = n2;
            }
            writer.write(cArray, n, n3);
            n += (n2 -= n3);
        }
        if (n2 > 0) {
            writer.write(cArray, n += this.gapEnd - this.gapStart, n2);
        }
    }

    public void writeTo(Writer writer) throws IOException {
        char[] cArray = this.string.data;
        writer.write(cArray, 0, this.gapStart);
        writer.write(cArray, this.gapEnd, cArray.length - this.gapEnd);
    }

    public void dump() {
        int n;
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), this.gapEnd, this.getArray().length - this.gapEnd));
        System.err.println("\"");
        int n2 = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + n2 + " free:" + this.free + "):");
        boolean[] blArray = null;
        if (this.free != -2) {
            blArray = new boolean[this.positions.length];
            n = this.free;
            while (n >= 0) {
                blArray[n] = true;
                n = this.positions[n];
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.positions[n];
            if (!(this.free == -2 ? n3 != -2 : !blArray[n])) continue;
            System.err.println("position#" + n + ": " + (n3 >> 1) + " isAfter:" + (n3 & 1));
        }
    }
}

