/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.StableVector;
import gnu.lists.SubCharSeq;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class CharBuffer
extends StableVector
implements CharSeq,
Serializable {
    private FString string;

    public CharBuffer(FString str) {
        super(str);
        this.string = str;
    }

    public CharBuffer(int initialSize) {
        this(new FString(initialSize));
    }

    protected CharBuffer() {
    }

    public int length() {
        return this.size();
    }

    public char charAt(int index) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        return this.string.charAt(index);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int gapSize;
        int count;
        char[] array = this.string.data;
        if (srcBegin < this.gapStart && (count = (srcEnd < this.gapStart ? srcEnd : this.gapStart) - srcBegin) > 0) {
            System.arraycopy(array, srcBegin, dst, dstBegin, count);
            srcBegin += count;
            dstBegin += count;
        }
        if ((count = (srcEnd += (gapSize = this.gapEnd - this.gapStart)) - (srcBegin += gapSize)) > 0) {
            System.arraycopy(array, srcBegin, dst, dstBegin, count);
        }
    }

    public void setCharAt(int index, char value) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        this.string.setCharAt(index, value);
    }

    public CharSequence subSequence(int start, int end) {
        int sz = this.size();
        if (start < 0 || end < start || end > sz) {
            throw new IndexOutOfBoundsException();
        }
        return new SubCharSeq(this, this.base.createPos(start, false), this.base.createPos(end, true));
    }

    public void fill(int fromIndex, int toIndex, char value) {
        int i;
        int limit;
        char[] array = this.string.data;
        int n = limit = this.gapStart < toIndex ? this.gapStart : toIndex;
        for (i = fromIndex; i < limit; ++i) {
            array[i] = value;
        }
        int gapSize = this.gapEnd - this.gapStart;
        i = limit + gapSize;
        limit += toIndex;
        while (i < limit) {
            array[i] = value;
            ++i;
        }
    }

    public final void fill(char value) {
        char[] array = this.string.data;
        int i = array.length;
        while (--i >= this.gapEnd) {
            array[i] = value;
        }
        i = this.gapStart;
        while (--i >= 0) {
            array[i] = value;
        }
    }

    public char[] getArray() {
        return (char[])this.base.getBuffer();
    }

    public void delete(int where, int count) {
        int ipos = this.createPos(where, false);
        this.removePos(ipos, count);
        this.releasePos(ipos);
    }

    public void insert(int where, String str, boolean beforeMarkers) {
        int len = str.length();
        this.gapReserve(where, len);
        str.getChars(0, len, this.string.data, where);
        this.gapStart += len;
    }

    public void consume(int start, int count, Consumer dest) {
        char[] array = this.string.data;
        if (start < this.gapStart) {
            int count0 = this.gapStart - start;
            if (count0 > count) {
                count0 = count;
            }
            dest.write(array, start, count0);
            start += (count -= count0);
        }
        if (count > 0) {
            dest.write(array, start += this.gapEnd - this.gapStart, count);
        }
    }

    public String toString() {
        int len = this.size();
        int start = this.getSegment(0, len);
        return new String(this.getArray(), start, len);
    }

    public void writeTo(int start, int count, Writer dest) throws IOException {
        char[] array = this.string.data;
        if (start < this.gapStart) {
            int count0 = this.gapStart - start;
            if (count0 > count) {
                count0 = count;
            }
            dest.write(array, start, count0);
            start += (count -= count0);
        }
        if (count > 0) {
            dest.write(array, start += this.gapEnd - this.gapStart, count);
        }
    }

    public void writeTo(Writer dest) throws IOException {
        char[] array = this.string.data;
        dest.write(array, 0, this.gapStart);
        dest.write(array, this.gapEnd, array.length - this.gapEnd);
    }

    public void dump() {
        int i;
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), this.gapEnd, this.getArray().length - this.gapEnd));
        System.err.println("\"");
        int poslen = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + poslen + " free:" + this.free + "):");
        boolean[] isFree = null;
        if (this.free != -2) {
            isFree = new boolean[this.positions.length];
            i = this.free;
            while (i >= 0) {
                isFree[i] = true;
                i = this.positions[i];
            }
        }
        for (i = 0; i < poslen; ++i) {
            int pos = this.positions[i];
            if (!(this.free == -2 ? pos != -2 : !isFree[i])) continue;
            System.err.println("position#" + i + ": " + (pos >> 1) + " isAfter:" + (pos & 1));
        }
    }
}

