/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import gnu.math.RealNum;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ExponentialFormat
extends Format {
    public int fracDigits;
    public int intDigits;
    public int expDigits;
    public char overflowChar;
    public char padChar;
    public char exponentChar;
    public boolean showPlus;
    public int width;
    public boolean general;
    static final double LOG10 = Math.log(10.0);

    static boolean addOne(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n2;
        while (true) {
            char c;
            if (n3 == n) {
                stringBuffer.insert(n3, '1');
                return true;
            }
            if ((c = stringBuffer.charAt(--n3)) != '9') {
                stringBuffer.setCharAt(n3, (char)(c + '\u0001'));
                return false;
            }
            stringBuffer.setCharAt(n3, '0');
        }
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        block38: {
            int n;
            int n2;
            block37: {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl;
                int n8;
                int n9;
                boolean bl2;
                int n10 = this.intDigits;
                int n11 = this.fracDigits;
                boolean bl3 = bl2 = d < 0.0;
                if (bl2) {
                    d = -d;
                }
                n2 = stringBuffer.length();
                int n12 = 1;
                if (bl2) {
                    stringBuffer.append('-');
                } else if (this.showPlus) {
                    stringBuffer.append('+');
                } else {
                    n12 = 0;
                }
                int n13 = (int)(Math.log(d) / LOG10);
                int n14 = n11 < 0 ? 17 : n11 + (n10 > 0 ? 1 : n10);
                boolean bl4 = true;
                int n15 = stringBuffer.length();
                if (n13 == Integer.MIN_VALUE) {
                    n13 = n14 + 1;
                }
                int n16 = n14 - n13 + 1;
                IntNum intNum = RealNum.toScaledInt(d, n16);
                intNum.format(10, stringBuffer);
                int n17 = stringBuffer.length() - n15 - n10 - n16;
                int n18 = n9 = n17 < 0 ? -n17 : n17;
                int n19 = n9 >= 1000 ? 4 : (n9 >= 100 ? 3 : (n8 = n9 >= 10 ? 2 : 1));
                if (this.expDigits > n8) {
                    n8 = this.expDigits;
                }
                int n20 = !this.general ? 0 : (this.expDigits > 0 ? this.expDigits + 2 : 4);
                boolean bl5 = bl = n11 < 0;
                if (this.general || bl) {
                    n7 = stringBuffer.length() - n2 - n16;
                    if (bl) {
                        n11 = n7 < 7 ? n7 : 7;
                        n6 = stringBuffer.length();
                        n5 = 48;
                        int n21 = n4 = this.width <= 0 ? 16 : this.width - n12 - n8 - 3;
                        if (n4 > 0 && n4 < n6 - n15) {
                            if (stringBuffer.charAt(n15 + n4) >= '5') {
                                n5 = 57;
                            }
                            n6 = n15 + n4;
                        }
                        while (n6 > n15 && stringBuffer.charAt(--n6) == n5) {
                        }
                        if ((n6 = n6 + 1 - n15) > n11) {
                            n11 = n6;
                        }
                    }
                    n6 = n11 - n7;
                    if (this.general && n7 >= 0 && n6 >= 0) {
                        if (n6 == 0 && bl && (this.width <= 0 || n7 + n12 + 1 + n20 < this.width)) {
                            ++n11;
                        }
                        n14 = n11;
                        n10 = n7;
                        bl4 = false;
                    } else if (bl) {
                        n5 = this.width - n12 - n8 - 3;
                        if (this.width <= 0) {
                            n14 = n11;
                        } else {
                            n14 = n5;
                            if (n10 < 0) {
                                n14 -= n10;
                            }
                            if (n14 > n11) {
                                n14 = n11;
                            }
                        }
                        if (n14 <= 0) {
                            n14 = 1;
                        }
                        if (n14 == n10 && (this.width <= 0 || n14 < n5)) {
                            ++n14;
                        }
                    }
                }
                n7 = n15 + n14;
                while (stringBuffer.length() < n7) {
                    stringBuffer.insert(n15, '0');
                }
                n6 = n7 == stringBuffer.length() ? 48 : (int)stringBuffer.charAt(n7);
                int n22 = n5 = n6 >= 53 ? 1 : 0;
                if (n5 != 0 && ExponentialFormat.addOne(stringBuffer, n15, n7)) {
                    ++n16;
                }
                n16 -= stringBuffer.length() - n7;
                stringBuffer.setLength(n7);
                if (n10 < 0) {
                    n4 = n10;
                    while (++n4 <= 0) {
                        stringBuffer.insert(n15, '0');
                    }
                } else {
                    while (n15 + n10 > n7) {
                        stringBuffer.append('0');
                        ++n7;
                    }
                }
                stringBuffer.insert(n10 >= 0 ? n15 + n10 : n15, '.');
                if (bl4) {
                    stringBuffer.append(this.exponentChar);
                    stringBuffer.append(n17 >= 0 ? (char)'+' : '-');
                    n = stringBuffer.length();
                    stringBuffer.append(n9);
                    n4 = stringBuffer.length();
                    n3 = this.expDigits - (n4 - n);
                    if (n3 > 0) {
                        n4 += n3;
                        while (--n3 >= 0) {
                            stringBuffer.insert(n, '0');
                        }
                    }
                } else {
                    while (--n20 >= 0 && (this.width <= 0 || stringBuffer.length() < n2 + this.width)) {
                        stringBuffer.append(' ');
                    }
                    n4 = stringBuffer.length();
                }
                if ((n = this.width - (n3 = n4 - n2)) < 0 && this.width > 0 || bl4 && n8 > this.expDigits && this.expDigits > 0 && this.overflowChar != '\u0000') break block37;
                if (n10 <= 0 && (n > 0 || this.width <= 0)) {
                    stringBuffer.insert(n15, '0');
                    --n;
                }
                while (--n >= 0) {
                    stringBuffer.insert(n2, this.padChar);
                }
                break block38;
            }
            if (this.overflowChar == '\u0000') break block38;
            stringBuffer.setLength(n2);
            n = this.width;
            while (--n >= 0) {
                stringBuffer.append(this.overflowChar);
            }
        }
        return stringBuffer;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(Object object2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(((RealNum)object2).doubleValue(), stringBuffer, fieldPosition);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("ExponentialFormat.parse - not implemented");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("ExponentialFormat.parseObject - not implemented");
    }
}

