/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.ThreadLocation;
import gnu.mapping.TtyInPort;
import gnu.text.LineBufferedReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InPort
extends LineBufferedReader
implements Printable {
    private static InPort systemInPort = new TtyInPort(System.in, "<stdin>", OutPort.outInitial);
    public static final ThreadLocation inLocation = new ThreadLocation("in-default");

    public InPort(Reader reader) {
        super(reader);
    }

    public InPort(Reader reader, String string) {
        this(reader);
        this.setName(string);
    }

    public InPort(InputStream inputStream) {
        super(inputStream);
    }

    public InPort(InputStream inputStream, String string) {
        this(inputStream);
        this.setName(string);
    }

    public static Reader convertToReader(InputStream inputStream, Object object2) {
        if (object2 != null && object2 != Boolean.TRUE) {
            String string = object2 == Boolean.FALSE ? "8859_1" : object2.toString();
            try {
                return new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("unknown character encoding: " + string);
            }
        }
        return new InputStreamReader(inputStream);
    }

    public InPort(InputStream inputStream, String string, Object object2) throws UnsupportedEncodingException {
        this(InPort.convertToReader(inputStream, object2), string);
        if (object2 == Boolean.FALSE) {
            try {
                this.setBuffer(new char[2048]);
            }
            catch (IOException iOException) {}
        } else {
            this.setConvertCR(true);
        }
    }

    public static InPort inDefault() {
        return (InPort)inLocation.get();
    }

    public static void setInDefault(InPort inPort) {
        inLocation.set(inPort);
    }

    public static InPort openFile(String string) throws UnsupportedEncodingException, FileNotFoundException {
        InputStream inputStream = new FileInputStream(string);
        inputStream = new BufferedInputStream(inputStream);
        return InPort.openFile(inputStream, string);
    }

    public static InPort openFile(InputStream inputStream, String string) throws UnsupportedEncodingException {
        return new InPort(inputStream, string, Environment.user().get("port-char-encoding"));
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<input-port");
        String string = this.getName();
        if (string != null) {
            printWriter.print(' ');
            printWriter.print(string);
        }
        printWriter.print('>');
    }

    static {
        inLocation.setGlobal(systemInPort);
    }
}

