/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.xml.ParsedXMLToConsumer;
import gnu.xml.XMLParserChar;
import java.io.IOException;
import java.net.URL;

public class XMLParser
extends XMLParserChar {
    SourceMessages messages;

    public XMLParser(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages, Consumer consumer) {
        this(lineBufferedReader, new ParsedXMLToConsumer(consumer), sourceMessages, consumer);
    }

    private XMLParser(LineBufferedReader lineBufferedReader, ParsedXMLToConsumer parsedXMLToConsumer, SourceMessages sourceMessages, Consumer consumer) {
        super(null, 0, 0, parsedXMLToConsumer);
        this.in = lineBufferedReader;
        this.messages = sourceMessages;
        parsedXMLToConsumer.setParser(this);
    }

    public XMLParser(LineBufferedReader lineBufferedReader, Consumer consumer, SourceMessages sourceMessages) {
        super(null, 0, 0, new ParsedXMLToConsumer(consumer));
        this.in = lineBufferedReader;
        this.messages = sourceMessages;
    }

    private XMLParser(URL uRL, Consumer consumer, SourceMessages sourceMessages, ParsedXMLToConsumer parsedXMLToConsumer, LineBufferedReader lineBufferedReader) throws IOException {
        super(null, 0, 0, parsedXMLToConsumer);
        this.in = lineBufferedReader;
        parsedXMLToConsumer.setParser(this);
        lineBufferedReader.setName(uRL.toString());
        this.messages = sourceMessages;
    }

    public XMLParser(URL uRL, SourceMessages sourceMessages, Consumer consumer) throws IOException {
        this(uRL, consumer, sourceMessages, new ParsedXMLToConsumer(consumer), new LineBufferedReader(uRL.openConnection().getInputStream()));
    }

    public int fill(char[] cArray, int n, int n2) {
        LineBufferedReader lineBufferedReader = (LineBufferedReader)this.in;
        int n3 = n2 - n;
        try {
            int n4;
            if (n3 > 0) {
                n4 = lineBufferedReader.skip(n - lineBufferedReader.pos);
                lineBufferedReader.mark(n3 + 1);
                n4 = lineBufferedReader.skip(n3);
            } else {
                lineBufferedReader.skip(n2 - lineBufferedReader.pos);
            }
            n4 = lineBufferedReader.read();
            if (n4 <= 0) {
                return -1;
            }
            if (n3 > 0) {
                lineBufferedReader.reset();
                lineBufferedReader.skip(n3);
            } else {
                lineBufferedReader.unread_quick();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        this.pos = lineBufferedReader.pos;
        this.buffer = lineBufferedReader.buffer;
        return lineBufferedReader.limit - lineBufferedReader.pos;
    }

    public void error(char c, String string) {
        LineBufferedReader lineBufferedReader = (LineBufferedReader)this.in;
        try {
            lineBufferedReader.skip(this.pos - lineBufferedReader.pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = lineBufferedReader.getName();
        if (string2 != null && string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        int n = lineBufferedReader.getLineNumber();
        int n2 = lineBufferedReader.getColumnNumber();
        this.messages.error(c, string2, n + 1, n2 >= 0 ? n2 + 1 : 0, string);
    }

    public String getName() {
        return ((LineBufferedReader)this.in).getName();
    }

    public int getLineNumber() {
        return ((LineBufferedReader)this.in).getLineNumber();
    }

    public int getColumnNumber() {
        return ((LineBufferedReader)this.in).getColumnNumber();
    }
}

