/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.EWindow;
import gnu.lists.LList;

public abstract class EFrame {
    public static EFrame selectedFrame;
    public EWindow selectedWindow;
    static int counter;
    protected int id = ++counter;
    public EWindow firstWindow;

    public static String defaultName() {
        return "Emacs";
    }

    public EFrame() {
        if (selectedFrame == null) {
            selectedFrame = this;
        }
    }

    public EFrame(EWindow eWindow) {
        eWindow.frame = this;
        this.firstWindow = eWindow;
        eWindow.nextWindow = eWindow;
        eWindow.prevWindow = eWindow;
        EWindow.setSelected(eWindow);
    }

    public void validate() {
    }

    public void delete() {
        EWindow eWindow;
        while ((eWindow = this.firstWindow) != null) {
            eWindow.deleteNoValidate();
        }
        if (this == selectedFrame) {
            selectedFrame = null;
        }
    }

    public abstract boolean isLive();

    public EWindow getFirstWindow() {
        return this.firstWindow;
    }

    public EWindow getLastWindow() {
        return this.firstWindow.prevWindow;
    }

    public static EFrame getSelectedFrame() {
        return selectedFrame;
    }

    public EWindow getSelectedWindow() {
        return this.selectedWindow;
    }

    public EWindow otherWindow(int n) {
        return this.selectedWindow.getNextWindowInFrame(n);
    }

    public abstract void setMenu(LList var1);

    public abstract String ask(String var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<frame #");
        stringBuffer.append(this.id);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

