/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.Display;
import gnu.kawa.models.Model;
import gnu.kawa.models.Paintable;
import gnu.kawa.models.WithTransform;
import gnu.mapping.WrappedException;
import gnu.text.URI_utils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;

public class DrawImage
extends Model
implements Paintable,
Serializable {
    BufferedImage image;
    URI src;
    String description;

    public DrawImage() {
    }

    public void makeView(Display display, Object where) {
        display.addImage(this, where);
    }

    void loadImage() {
        if (this.image == null) {
            try {
                this.image = ImageIO.read(URI_utils.getInputStream(this.src));
            }
            catch (Throwable ex) {
                throw WrappedException.wrapIfNeeded(ex);
            }
        }
    }

    public DrawImage(BufferedImage image) {
        this.image = image;
    }

    public void paint(Graphics2D graphics) {
        this.loadImage();
        graphics.drawImage(this.image, null, null);
    }

    public Rectangle2D getBounds2D() {
        this.loadImage();
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        return new Rectangle2D.Float(0.0f, 0.0f, w, h);
    }

    public Paintable transform(AffineTransform tr) {
        return new WithTransform(this, tr);
    }

    public Image getImage() {
        this.loadImage();
        return this.image;
    }

    public URI getSrc() {
        return this.src;
    }

    public void setSrc(Object src) throws URISyntaxException {
        this.src = URI_utils.toURI(src);
    }
}

