/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.Target;

public class ClassInitializer
extends Initializer {
    ClassExp cexp;

    public ClassInitializer(ClassExp cexp, Field field, Compilation comp) {
        this.field = field;
        this.cexp = cexp;
        if (field.getStaticFlag()) {
            this.next = comp.clinitChain;
            comp.clinitChain = this;
        } else {
            LambdaExp heapLambda = cexp.getOwningLambda();
            this.next = heapLambda.initChain;
            heapLambda.initChain = this;
        }
    }

    public void emit(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (!this.field.getStaticFlag()) {
            code.emitPushThis();
        }
        this.cexp.compilePushClass(comp, Target.pushValue(Compilation.typeClassType));
        if (this.field.getStaticFlag()) {
            code.emitPutStatic(this.field);
        } else {
            code.emitPutField(this.field);
        }
        if (this.cexp.compiledType == comp.mainClass && this.cexp.clinitMethod != null) {
            this.cexp.clinitMethod.body.compileWithPosition(comp, Target.Ignore);
        }
    }
}

