/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

public class ThreadLocation
extends NamedLocation
implements Named {
    static int counter;
    public static final String ANONYMOUS;
    SharedLocation global;
    private ThreadLocal<NamedLocation> thLocal;
    private int hash;
    static SimpleEnvironment env;

    private static synchronized int nextCounter() {
        return ++counter;
    }

    public ThreadLocation() {
        this("param#" + ThreadLocation.nextCounter());
    }

    public ThreadLocation(String name) {
        super(Symbol.makeUninterned(name), ANONYMOUS);
        this.thLocal = new InheritingLocation();
        this.global = new SharedLocation(this.name, null, 0);
    }

    private ThreadLocation(Symbol name) {
        super(name, ANONYMOUS);
        this.thLocal = new InheritingLocation();
        String str = name == null ? null : name.toString();
        this.global = new SharedLocation(Symbol.makeUninterned(str), null, 0);
    }

    public ThreadLocation(Symbol name, Object property, SharedLocation global) {
        super(name, property);
        this.hash = name.hashCode() ^ System.identityHashCode(property);
        this.global = global;
    }

    public static ThreadLocation makeAnonymous(String name) {
        return new ThreadLocation(name);
    }

    public static ThreadLocation makeAnonymous(Symbol name) {
        return new ThreadLocation(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(Object value) {
        ThreadLocation threadLocation = this;
        synchronized (threadLocation) {
            if (this.global == null) {
                this.global = new SharedLocation(this.name, null, 0);
            }
            this.global.set(value);
        }
    }

    public NamedLocation getLocation() {
        if (this.property != ANONYMOUS) {
            return Environment.getCurrent().getLocation(this.name, this.property, this.hash, true);
        }
        NamedLocation entry = this.thLocal.get();
        if (entry == null) {
            entry = new SharedLocation(this.name, this.property, 0);
            if (this.global != null) {
                entry.setBase(this.global);
            }
            this.thLocal.set(entry);
        }
        return entry;
    }

    @Override
    public Object get(Object defaultValue) {
        return this.getLocation().get(defaultValue);
    }

    @Override
    public void set(Object value) {
        this.getLocation().set(value);
    }

    @Override
    public Object setWithSave(Object newValue) {
        return this.getLocation().setWithSave(newValue);
    }

    @Override
    public void setRestore(Object oldValue) {
        this.getLocation().setRestore(oldValue);
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.toString();
    }

    @Override
    public Object getSymbol() {
        if (this.name != null && this.property == ANONYMOUS && this.global.getKeySymbol() == this.name) {
            return this.name.toString();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new RuntimeException("setName not allowed");
    }

    public static synchronized ThreadLocation getInstance(Symbol name, Object property) {
        if (env == null) {
            env = new SimpleEnvironment("[thread-locations]");
        }
        IndirectableLocation loc = (IndirectableLocation)env.getLocation(name, property);
        if (loc.base != null) {
            return (ThreadLocation)loc.base;
        }
        ThreadLocation tloc = new ThreadLocation(name, property, null);
        loc.base = tloc;
        return tloc;
    }

    static {
        ANONYMOUS = new String("(dynamic)");
    }

    public class InheritingLocation
    extends InheritableThreadLocal<NamedLocation> {
        @Override
        protected SharedLocation childValue(NamedLocation parentValue) {
            SharedLocation sloc;
            if (ThreadLocation.this.property != ANONYMOUS) {
                throw new Error();
            }
            if (parentValue == null) {
                parentValue = (SharedLocation)ThreadLocation.this.getLocation();
            }
            NamedLocation nloc = parentValue;
            if (nloc.base == null) {
                sloc = new SharedLocation(ThreadLocation.this.name, ThreadLocation.this.property, 0);
                sloc.value = nloc.value;
                nloc.base = sloc;
                nloc.value = null;
                nloc = sloc;
            }
            sloc = new SharedLocation(ThreadLocation.this.name, ThreadLocation.this.property, 0);
            sloc.value = null;
            sloc.base = nloc;
            return sloc;
        }
    }
}

