/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.S32Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class U32Vector
extends SimpleVector
implements Externalizable,
Comparable {
    int[] data;

    public U32Vector() {
        this.data = S32Vector.empty;
    }

    public U32Vector(int size, int value) {
        int[] array = new int[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public U32Vector(int size) {
        this.data = new int[size];
        this.size = size;
    }

    public U32Vector(int[] data) {
        this.data = data;
        this.size = data.length;
    }

    public U32Vector(Sequence seq) {
        this.data = new int[seq.size()];
        this.addAll((Collection)seq);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            int[] tmp = new int[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    @Override
    protected Object getBuffer() {
        return this.data;
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final long longAtBuffer(int index) {
        return (long)this.data[index] & 0xFFFFFFFFL;
    }

    @Override
    public final long longAt(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(index);
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public final Object getBuffer(int index) {
        return Convert.toObjectUnsigned(this.data[index]);
    }

    @Override
    public Object setBuffer(int index, Object value) {
        int old = this.data[index];
        this.data[index] = Convert.toIntUnsigned(value);
        return Convert.toObjectUnsigned(old);
    }

    public final void setIntAt(int index, int value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setIntAtBuffer(int index, int value) {
        this.data[index] = value;
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = 0;
        }
    }

    @Override
    public int getElementKind() {
        return 19;
    }

    @Override
    public String getTag() {
        return "u32";
    }

    @Override
    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeInt(this.data[index]);
        return true;
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeInt(this.data[i]);
            ++i;
        }
    }

    public int compareTo(Object obj) {
        return U32Vector.compareToLong(this, (U32Vector)obj);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readInt();
        }
        this.data = data;
        this.size = size;
    }
}

