/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.brl;

import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.kawa.brl.BRLRead;
import gnu.kawa.brl.BRLReaderString;
import gnu.kawa.brl.Prompter;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.lispexpr.ReadTable;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleEnvironment;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.xml.XMLPrinter;
import java.io.Writer;
import kawa.standard.Scheme;

public class BRL
extends Scheme {
    public static final BRL krl_instance;
    public static final BRL brl_instance;
    static final Object emptyForm;
    protected static final SimpleEnvironment brlEnvironment;
    static BRLReaderString brlReader;
    boolean brlCompatible = false;

    protected BRL(Environment env) {
        super(env);
    }

    void initBRL() {
        ModuleBody.setMainPrintValues(true);
        try {
            this.loadClass("gnu.brl.stringfun");
            this.loadClass("gnu.kawa.brl.progfun");
            this.loadClass("gnu.kawa.servlet.HTTP");
        }
        catch (Throwable ex) {
            System.err.println("caught " + ex);
        }
    }

    public static Language getInstance(boolean brlCompatible) {
        return brlCompatible ? BRL.getBrlInstance() : BRL.getBrlInstance();
    }

    public static BRL getKrlInstance() {
        return krl_instance;
    }

    public static BRL getBrlInstance() {
        return brl_instance;
    }

    public boolean isBrlCompatible() {
        return this.brlCompatible;
    }

    public void setBrlCompatible(boolean compat) {
        this.brlCompatible = compat;
    }

    @Override
    public Lexer getLexer(InPort inp, SourceMessages messages) {
        Compilation.defaultCallConvention = 2;
        BRLRead lexer = new BRLRead(inp, messages);
        lexer.setBrlCompatible(this.isBrlCompatible());
        return lexer;
    }

    @Override
    public Consumer getOutputConsumer(Writer out) {
        if (this.isBrlCompatible()) {
            return super.getOutputConsumer(out);
        }
        return new XMLPrinter(out, false);
    }

    public static void registerEnvironment() {
        Language.setDefaults(BRL.getKrlInstance());
    }

    @Override
    public Expression makeBody(Expression[] exps) {
        if (this.isBrlCompatible()) {
            return super.makeBody(exps);
        }
        return new ApplyExp(AppendValues.appendValues, exps);
    }

    @Override
    public ReadTable createReadTable() {
        ReadTable rt = super.createReadTable();
        rt.setBracketMode(1);
        rt.set(93, brlReader);
        return rt;
    }

    @Override
    public Procedure getPrompter() {
        return new Prompter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        emptyForm = new FString();
        brlEnvironment = Environment.make("brl-environment", Scheme.kawaEnvironment);
        brlReader = new BRLReaderString();
        krl_instance = new BRL(brlEnvironment);
        brl_instance = new BRL(brlEnvironment);
        brl_instance.setBrlCompatible(true);
        BRL.brl_instance.defaultReadTable.setInitialColonIsKeyword(true);
        Environment saveEnv = Environment.setSaveCurrent(brlEnvironment);
        try {
            krl_instance.initBRL();
        }
        finally {
            Environment.restoreCurrent(saveEnv);
        }
    }
}

