
;;; d-copy.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-copy.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: File copier
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:
;;;
;;; (d-copy--inner (expand-file-name "~/1-connect-four"))
;;; (d-copy--inner (expand-file-name "~/3-autogc-nosplit/"))
;;;
;;; (setq source-dir "~/3-autogc-nosplit")
;;;
(defun d-copy--inner (source-dir)

  (assert (file-exists-p source-dir))

  ;;
  ;; NOTE: culls trailing slash and removes ~/
  ;;
  (setq source-dir (safe-expand-file-name source-dir))

  ;;(debug)

  (save-window-excursion
    (let ((default-directory source-dir))
      (shell-command "make clean")))

  (let* ((target-dir (concat webdata "/src/davin/research"))
         (list-outer (directory-files-subdirs source-dir))
         (ptr-outer  list-outer))

    (setq ptr-outer

    (while ptr-outer

      ;;(debug)

      (let* ((list-inner (directory-files-subdirs (concat source-dir "/" (car ptr-outer)) nil "^no[^/\\]*$"))
             (ptr-inner  list-inner))

        (while ptr-inner

          (assert (string-match "^no\\([^/\\]*$\\)" (car ptr-inner)))

          (let* ((target-ro  (concat "ro"           (substring (car ptr-inner) (match-beginning 1) (match-end 1))))
                 (dir-source (concat source-dir "/" (car ptr-outer) "/" (car ptr-inner)))
                 (dir-target (concat target-dir "/" (car ptr-outer) "/" target-ro))
                 (dir-t      (concat target-dir "/" (car ptr-outer))))

            ;;(debug)

            (assert (file-exists-p dir-t))

            ;;(when (not (file-exists-p dir-t))
            ;; (message ">>> mkdir " dir-t)
            ;;  (make-directory dir-t 'PARENTS))

            (when (file-exists-p dir-target)
              (let ((remove-command (concat "rm -r " dir-target)))
                (message ">>> %s" remove-command)
                (shell-command remove-command)
                )
              )

            (let ((copy-command (concat "cp -rp " dir-source " " dir-target)))
              (message ">>> %s" copy-command)
              (shell-command copy-command)
              )
            )

          (setq ptr-inner (cdr ptr-inner))))
      (setq ptr-outer (cdr ptr-outer))))))

(defun d-copy-copy-files ()
  (interactive)

  ;;
  ;; NOTE: ~/2-old-system/ folder is not used
  ;;
  (d-copy--inner "~/1-connect-four")
  (d-copy--inner "~/c++-projects/")

  (message "d-copy-copy-files done")
  ;; END DEFUN:
  )

(provide 'd-copy)
;;; d-copy.el ends here
