/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.ExpressionImage;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OP_binary;
import gnu.jel.OP_call;
import gnu.jel.OP_conditional;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_logical_not;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OP_unary;
import gnu.jel.OPlist;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class Optimizer {
    static Class string_class = null;
    private Library lib;
    private Stack types = new Stack();
    protected OPlist code = new OPlist();
    private Stack functions = new Stack();
    private Stack functionsDescriptors = new Stack();
    private boolean finished = false;

    public Optimizer(Library lib) {
        this.lib = lib;
    }

    public void load(boolean c) {
        this.load(Boolean.TYPE, new Boolean(c));
    }

    public void load(byte c) {
        this.load(Byte.TYPE, new Byte(c));
    }

    public void load(char c) {
        this.load(Character.TYPE, new Character(c));
    }

    public void load(short c) {
        this.load(Short.TYPE, new Short(c));
    }

    public void load(int c) {
        this.load(Integer.TYPE, new Integer(c));
    }

    public void load(long c) {
        this.load(Long.TYPE, new Long(c));
    }

    public void load(float c) {
        this.load(Float.TYPE, new Float(c));
    }

    public void load(double c) {
        this.load(Double.TYPE, new Double(c));
    }

    public void load(String s) {
        this.load(string_class, s);
    }

    private void load(Class t, Object o) {
        this.seeNonFinished();
        OP_load nop = new OP_load(t, o);
        this.types.push(t);
        this.code.addLast(nop);
    }

    public void convert(Class to, boolean widening) throws IllegalStateException {
        this.seeNonFinished();
        Class ct = (Class)this.types.peek();
        if (!ExpressionImage.canConvert(ct, to)) {
            throw new IllegalStateException("Can not convert " + ct.toString() + " to " + to.toString() + ".");
        }
        if (widening && !ExpressionImage.canConvertByWidening(ct, to)) {
            throw new IllegalStateException("You must specify narrowing conversion from " + ct.toString() + " to " + to.toString() + " explicitly");
        }
        if (ct != to) {
            OP lastOP = this.code.getLast();
            if (lastOP instanceof OP_convert) {
                ((OP_convert)lastOP).setType(to);
            } else {
                this.code.addLast(new OP_convert(to));
            }
        }
        this.types.pop();
        this.types.push(to);
    }

    public void convert(Class to) throws IllegalStateException {
        this.convert(to, false);
    }

    public void unary(int o) {
        this.seeNonFinished();
        Class ct = (Class)this.types.peek();
        if (!ExpressionImage.canGenerateUnary(o, ct)) {
            throw new IllegalStateException("Unary " + ExpressionImage.unaryNames[o] + " is not supported on " + ct.getName() + "'s");
        }
        this.code.addLast(new OP_unary(o));
    }

    public void logical_not_start() {
        this.seeNonFinished();
        OP_logical_not opc = new OP_logical_not();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_start(opc));
    }

    public void logical_not() throws IllegalStateException {
        if (this.types.peek() != Boolean.TYPE) {
            throw new IllegalStateException("You tried to use logical complement on " + ((Class)this.types.peek()).getName() + ". This operation is supported only" + " on booleans.");
        }
        OP_logical_not opf = (OP_logical_not)this.functions.pop();
        int[] descrs = (int[])this.functionsDescriptors.pop();
        this.code.addLast(opf);
    }

    public void function_start() {
        this.seeNonFinished();
        OP_call opc = new OP_call();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_start(opc));
    }

    public void binaryOP_param() {
        this.seeNonFinished();
        OP_binary opc = new OP_binary();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_param(opc, (Class)this.types.peek()));
    }

    public boolean function_param() {
        this.seeNonFinished();
        OP_function opf = (OP_function)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        descrs[0] = descrs[0] + 1;
        this.code.addLast(new OP_param(opf, (Class)this.types.peek()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void function_call(String name) throws IllegalStateException {
        block4: {
            this.seeNonFinished();
            opf = (OP_call)this.functions.peek();
            descrs = (int[])this.functionsDescriptors.peek();
            nparams = descrs[0];
            paramTypes = new Class[nparams];
            i = nparams - 1;
            while (i >= 0) {
                paramTypes[i] = (Class)this.types.pop();
                --i;
            }
            try {
                m = this.lib.getMethod(name, paramTypes);
                break block4;
            }
            catch (NoSuchMethodException e) {
                i = 0;
                ** while (i < nparams)
            }
lbl-1000:
            // 1 sources

            {
                this.types.push(paramTypes[i]);
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw new IllegalStateException(e.getMessage());
        }
        opc = opf;
        this.code.addLast(opc);
        opc.setMethod(this.code, m, this.lib.getDynamicMethodClassID(m), this.lib.isStateless(m));
        this.types.push(m.getReturnType());
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void binaryOP(int o, boolean logical) throws IllegalStateException {
        this.seeNonFinished();
        OP_binary opf = (OP_binary)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        OP_param terminating_param = new OP_param(opf, (Class)this.types.peek());
        terminating_param.setbinaryparam = false;
        this.code.addLast(terminating_param);
        Class op2 = (Class)this.types.pop();
        Class op1 = (Class)this.types.pop();
        String message = null;
        boolean error = false;
        if (!logical) {
            if (!ExpressionImage.canGenerateBinary(o, op1, op2)) {
                error = true;
                message = "Types " + op1.toString() + " and " + op2.toString() + " are not suitable " + "for the operation \"" + ExpressionImage.binaryNames[o] + "\"";
            }
        } else if (op1 != Boolean.TYPE || op2 != Boolean.TYPE) {
            error = true;
            message = "Types " + op1.toString() + " and " + op2.toString() + " are not suitable for \"" + ExpressionImage.logicalNames[o] + "\" operation. Both operands must be boolean.";
        }
        if (error) {
            this.types.push(op1);
            this.types.push(op2);
            throw new IllegalStateException(message);
        }
        Class opType = Boolean.TYPE;
        Class resType = Boolean.TYPE;
        if (!logical) {
            opType = ExpressionImage.isPromotionBinary(o) ? (o == 0 && op1 == string_class ? string_class : ExpressionImage.getBinaryPromoted(op1, op2)) : (resType = ExpressionImage.getUnaryPromoted(op1));
            resType = opType;
            if (o >= 8 && o <= 13) {
                resType = Boolean.TYPE;
            }
        }
        OP_binary opc = opf;
        this.code.addLast(opc);
        opc.setOperation(this.code, o, logical, opType);
        this.types.push(resType);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void conditional_true() throws IllegalStateException {
        if (this.types.pop() != Boolean.TYPE) {
            throw new IllegalStateException("The first operand of conditional must be of boolean type.");
        }
        OP_conditional opc = new OP_conditional();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_start(opc));
    }

    public void conditional_false() {
        this.seeNonFinished();
        OP_conditional opf = (OP_conditional)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        descrs[0] = descrs[0] + 1;
        OP start = this.code.getLast();
        while (!(start instanceof OP_start) || ((OP_start)start).getFunction() != opf) {
            start = start.prev;
        }
        opf.setTrueList(this.code.cut_end(start.next));
    }

    public void conditional_end() throws IllegalStateException {
        this.seeNonFinished();
        OP_conditional opf = (OP_conditional)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        descrs[0] = descrs[0] + 1;
        OP start = this.code.getLast();
        while (!(start instanceof OP_start) || ((OP_start)start).getFunction() != opf) {
            start = start.prev;
        }
        opf.setFalseList(this.code.cut_end(start.next));
        this.code.remove(start);
        Class op2 = (Class)this.types.pop();
        Class op1 = (Class)this.types.pop();
        Class resType = null;
        if (op1.isPrimitive() && op2.isPrimitive()) {
            resType = ExpressionImage.getBinaryPromoted(op1, op2);
        } else if (op1 == op2) {
            resType = op1;
        } else if (ExpressionImage.canConvertByWidening(op1, op2)) {
            resType = op2;
        } else if (ExpressionImage.canConvertByWidening(op2, op1)) {
            resType = op1;
        }
        if (resType == null) {
            throw new IllegalStateException("Operands of conditional have types " + op1.getName() + " and " + op2.getName() + " . These types are not compatible.");
        }
        opf.setType(resType);
        this.types.push(resType);
        this.code.addLast(opf);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void finish() {
        this.seeNonFinished();
        Debug.assert(this.code.size == 0 || this.types.size() == 1, "Stack should contain single item on exit.");
        Debug.assert(this.functions.size() == 0 && this.functionsDescriptors.size() == 0, "There are function calls in progress.");
        this.finished = true;
    }

    public void optimize(int of) {
        this.seeFinished();
        while (of > 0 && Optimizer.optimizeIteration(this.code)) {
            --of;
        }
    }

    protected static boolean optimizeIteration(OPlist code) {
        return code.optimize();
    }

    public CompiledExpression compile() {
        return this.compileBits().getExpression();
    }

    public ExpressionBits compileBits() {
        this.seeFinished();
        ExpressionImage image = new ExpressionImage();
        this.code.compile(image);
        image.asm_return();
        return image.getBits();
    }

    public String toString() {
        return this.code.toString();
    }

    private void seeFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
    }

    private void seeNonFinished() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Optimizer.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        Number res;
        CompiledExpression ce;
        Optimizer op;
        Library clib = null;
        try {
            Class[] statlb = new Class[]{Class.forName("java.lang.Math")};
            clib = new Library(statlb, null);
            clib.markStateDependent("random", null);
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
        }
        t.startTest("Enter \"(2.0, 2,*)\" ");
        try {
            op = new Optimizer(clib);
            op.load(2.0);
            op.binaryOP_param();
            op.load(2L);
            op.binaryOP(2, false);
            op.finish();
            Debug.println("");
            Debug.println(op.toString());
            ce = op.compile();
            res = (Number)ce.evaluate(null);
            Debug.println("And the result is " + res.toString());
            if (res.intValue() == 4) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Enter \"5+(2.0*2)*exp(0)\" ");
        Debug.println("");
        try {
            op = new Optimizer(clib);
            op.load(5L);
            op.binaryOP_param();
            op.load(2.0);
            op.binaryOP_param();
            op.load(2L);
            op.binaryOP(2, false);
            op.binaryOP_param();
            op.function_start();
            op.load(0);
            op.function_param();
            op.function_call("exp");
            op.binaryOP(2, false);
            op.binaryOP(0, false);
            op.finish();
            Debug.println(op.toString());
            ce = op.compile();
            res = (Number)ce.evaluate(null);
            Debug.println("And the result is " + res.toString());
            if (res.intValue() == 9) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }

    static {
        try {
            string_class = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("Get Yourself a real JAVA.");
        }
    }
}

