/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript.qa.drivers;

import com.netscape.javascript.qa.drivers.TestCase;
import com.netscape.javascript.qa.drivers.TestFile;
import com.netscape.javascript.qa.drivers.TestLog;
import com.netscape.javascript.qa.drivers.TestSuite;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Vector;

public class TestDriver
extends Applet
implements Runnable {
    Thread THREAD = null;
    String[] SYSTEM;
    File TEST_DIRECTORY;
    File HELPER_FUNCTIONS;
    File OUTPUT_DIRECTORY;
    String HTTP_PATH;
    String SUFFIX;
    int OPT_LEVEL;
    int DEBUG_LEVEL;
    String[] ARGS;
    String EXECUTABLE = null;
    Vector SUITES;
    String[] FILES;
    public static boolean TINDERBOX = false;
    public static final boolean DEBUG = true;
    public static final boolean TCMS = false;
    Runtime RUNTIME;
    long FREE_MEMORY;
    long TOTAL_MEMORY;
    public static final String SUMMARY_LOG_NAME = "summ.html";
    public static final String CASE_LOG_NAME = "case.html";
    public static final String FILE_LOG_NAME = "file.html";
    public static final String SUITE_LOG_NAME = "suite.html";
    public static final String DEBUG_LOG_NAME = "debug.html";
    public static final String TERMINATOR = "<BR>\n";

    public TestDriver(String[] stringArray) {
        this.ARGS = stringArray;
        if (this.THREAD == null) {
            this.THREAD = new Thread(this);
            this.THREAD.start();
        }
    }

    public void closeLogs() {
        TestDriver.writeDateToLogs("", this.OUTPUT_DIRECTORY);
        TestDriver.getLog(this.OUTPUT_DIRECTORY, SUMMARY_LOG_NAME).closeLog();
        TestDriver.getLog(this.OUTPUT_DIRECTORY, SUITE_LOG_NAME).closeLog();
        TestDriver.getLog(this.OUTPUT_DIRECTORY, FILE_LOG_NAME).closeLog();
        TestDriver.getLog(this.OUTPUT_DIRECTORY, CASE_LOG_NAME).closeLog();
        TestDriver.getLog(this.OUTPUT_DIRECTORY, DEBUG_LOG_NAME).closeLog();
    }

    public static void debug(String string) {
        if (!TINDERBOX) {
            System.err.println(string);
        }
    }

    public static void enablePrivileges() {
    }

    public synchronized void executeSuite(TestSuite testSuite) {
    }

    public void getCases(TestSuite testSuite) {
        TestDriver.enablePrivileges();
        File file = new File(testSuite.filePath);
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            TestFile testFile = new TestFile(stringArray[n], String.valueOf(testSuite.filePath) + File.separator + stringArray[n]);
            if (testFile.isFile() && testFile.getName().toLowerCase().endsWith(this.getSuffix()) && !testFile.isDirectory()) {
                testSuite.addElement(testFile);
                TestDriver.p(String.valueOf(String.valueOf(testFile)));
            }
            ++n;
        }
    }

    public static String getCurrentDate(String string) {
        Date date = new Date();
        String string2 = date.getDate() < 10 ? "0" + String.valueOf(date.getDate()) : String.valueOf(date.getDate());
        String string3 = date.getMonth() + 1 < 10 ? "0" + String.valueOf(date.getMonth() + 1) : String.valueOf(date.getMonth() + 1);
        String string4 = String.valueOf(date.getYear());
        return String.valueOf(string3) + string + string2 + string + string4;
    }

    public static String getCurrentTime() {
        Date date = new Date();
        String string = date.getHours() < 10 ? "0" + String.valueOf(date.getHours()) : String.valueOf(date.getHours());
        String string2 = date.getMinutes() < 10 ? "0" + String.valueOf(date.getMinutes()) : String.valueOf(date.getMinutes());
        String string3 = date.getSeconds() < 10 ? "0" + String.valueOf(date.getSeconds()) : String.valueOf(date.getSeconds());
        String string4 = String.valueOf(string) + ":" + string2 + ":" + string3;
        return string4;
    }

    public static TestLog getLog(File file, String string) {
        TestDriver.enablePrivileges();
        TestLog testLog = null;
        String[] stringArray = TestDriver.getSystemInformation();
        String string2 = stringArray[0];
        try {
            File file2 = new File(String.valueOf(file.getAbsolutePath()) + (file.getAbsolutePath().endsWith(File.separator) ? "" : File.separator) + string2 + stringArray[1] + "-" + stringArray[2], TestDriver.getCurrentDate("_"));
            file2.mkdirs();
            testLog = new TestLog(String.valueOf(file2.getAbsolutePath()) + File.separator + string, TERMINATOR);
        }
        catch (Exception exception) {
            TestDriver.p("TestDriver.getLog threw " + exception.toString());
            TestDriver.p("platform " + string2);
            TestDriver.p("output" + file.toString());
            TestDriver.p("filename " + string.toString());
            TestDriver.p("File.separator " + File.separator.toString());
            TestDriver.p("SYSTEM[0] " + stringArray[0]);
            TestDriver.p("SYSTEM[1] " + stringArray[1]);
            TestDriver.p("SYSTEM[2] " + stringArray[2]);
            TestDriver.p("date " + TestDriver.getCurrentDate("_"));
            exception.printStackTrace();
        }
        return testLog;
    }

    public String getSuffix() {
        return this.SUFFIX;
    }

    public Vector getSuites(String[] stringArray) {
        Vector<TestSuite> vector = new Vector<TestSuite>();
        int n = 0;
        while (n < stringArray.length) {
            String string = TestDriver.stripDoubleSlashes(String.valueOf(String.valueOf(this.TEST_DIRECTORY)) + File.separator + stringArray[n]);
            File file = new File(string);
            if (file.isDirectory()) {
                TestSuite testSuite = new TestSuite(file.getName(), string);
                vector.addElement(testSuite);
            }
            ++n;
        }
        return vector;
    }

    public static String[] getSystemInformation() {
        String[] stringArray = new String[]{System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        TestDriver testDriver = new TestDriver(stringArray);
        testDriver.start();
    }

    public static void openLogFiles(File file) {
        TestDriver.enablePrivileges();
        TestLog testLog = TestDriver.getLog(file, SUMMARY_LOG_NAME);
        TestLog testLog2 = TestDriver.getLog(file, FILE_LOG_NAME);
        TestLog testLog3 = TestDriver.getLog(file, SUITE_LOG_NAME);
        TestLog testLog4 = TestDriver.getLog(file, CASE_LOG_NAME);
        TestLog testLog5 = TestDriver.getLog(file, DEBUG_LOG_NAME);
    }

    public static void p(String string) {
        if (!TINDERBOX) {
            System.out.println(string);
        }
    }

    public boolean processOptions() {
        return false;
    }

    public static String readFile(String string) {
        File file = new File(string);
        int n = new Long(file.length()).intValue();
        byte[] byArray = new byte[n];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = fileInputStream.read(byArray);
            stringBuffer.append(new String(byArray));
        }
        catch (Exception exception) {
            TestDriver.p(exception.toString());
        }
        return stringBuffer.toString();
    }

    public void run() {
    }

    public void setSuffix(String string) {
        this.SUFFIX = string;
    }

    public boolean sleep(int n) {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            TestDriver.p("sleep failed:  " + exception);
            return false;
        }
        return true;
    }

    public void start() {
        this.FILES = null;
        this.OUTPUT_DIRECTORY = null;
        this.OPT_LEVEL = 0;
        this.DEBUG_LEVEL = 0;
        this.RUNTIME = Runtime.getRuntime();
        this.FREE_MEMORY = this.RUNTIME.freeMemory();
        this.TOTAL_MEMORY = this.RUNTIME.totalMemory();
        if (this.processOptions()) {
            TestDriver.openLogFiles(this.OUTPUT_DIRECTORY == null ? this.TEST_DIRECTORY : this.OUTPUT_DIRECTORY);
            TestDriver.writeDateToLogs("<hr>", this.OUTPUT_DIRECTORY);
            this.writeLogHeaders(this.OUTPUT_DIRECTORY);
            if (this.FILES == null) {
                this.FILES = this.TEST_DIRECTORY.list();
            }
            if (TINDERBOX) {
                this.writeTinderboxHeader(this.EXECUTABLE);
            }
            this.SUITES = this.getSuites(this.FILES);
            int n = 0;
            while (n < this.SUITES.size()) {
                this.getCases((TestSuite)this.SUITES.elementAt(n));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.SUITES.size()) {
                if (TINDERBOX) {
                    this.writeTinderboxSuiteName((TestSuite)this.SUITES.elementAt(n2));
                }
                this.executeSuite((TestSuite)this.SUITES.elementAt(n2));
                if (TINDERBOX) {
                    this.writeTinderboxSuiteResult((TestSuite)this.SUITES.elementAt(n2));
                }
                this.RUNTIME.gc();
                ++n2;
            }
        }
        this.stop();
    }

    public void stop() {
        this.closeLogs();
        this.RUNTIME.gc();
        long l = this.RUNTIME.freeMemory();
        long l2 = this.RUNTIME.totalMemory();
        String string = "<tt>Free Memory " + l + "\n<br>" + "Total Memory " + l2 + "\n<br>" + "Free Leaked  " + (this.FREE_MEMORY - l) + "\n<br>" + "Total Leaked " + (this.TOTAL_MEMORY - l2) + "\n<br>" + "</tt>";
        TestDriver.p(string);
        TestDriver.p("done!");
        if (this.THREAD != null) {
            this.THREAD.stop();
            this.THREAD = null;
        }
    }

    public static String stripDoubleSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != File.separatorChar) {
                stringBuffer.append(c);
            } else {
                while (string.charAt(++n) == File.separatorChar) {
                }
                stringBuffer.append(File.separatorChar);
                --n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void writeCaseResults(TestFile testFile, TestSuite testSuite, File file) {
        testSuite.totalCases += testFile.totalCases;
        String[] stringArray = TestDriver.getSystemInformation();
        String string = "";
        int n = 0;
        while (n < testFile.caseVector.size()) {
            TestCase testCase = (TestCase)testFile.caseVector.elementAt(n);
            if (!testCase.passed.equals("true") && !testFile.passed) {
                string = String.valueOf(string) + "<a name=" + testSuite.name + "-" + testFile.name + ">";
                string = String.valueOf(string) + "<tt>";
                string = String.valueOf(string) + "(" + stringArray[0] + "), ";
            }
            if (testCase.passed.equals("true")) {
                if (!testFile.passed) {
                    string = String.valueOf(string) + "-pass-, ";
                }
                ++testSuite.casesPassed;
                ++testFile.casesPassed;
            } else {
                if (!testFile.passed) {
                    string = String.valueOf(string) + "*FAIL*, ";
                }
                ++testSuite.casesFailed;
                ++testFile.casesFailed;
            }
            string = String.valueOf(string) + testCase.name + "," + testCase.description + "," + testCase.expect + "," + testCase.actual + "," + testCase.reason + "\n";
            if (!testCase.passed.equals("true")) {
                string = String.valueOf(string) + "</tt><br>\n";
                TestDriver.getLog(file, CASE_LOG_NAME).writeLine(string.toString());
            } else {
                string = "";
            }
            ++n;
        }
    }

    public static void writeCaseResults(TestFile testFile, String string, File file) {
        String[] stringArray = TestDriver.getSystemInformation();
        String string2 = "";
        int n = 0;
        while (n < testFile.caseVector.size()) {
            TestCase testCase = (TestCase)testFile.caseVector.elementAt(n);
            if (!testCase.passed.equals("true")) {
                string2 = String.valueOf(string2) + "<tt>";
                string2 = String.valueOf(string2) + "(" + stringArray[0] + "), ";
                string2 = String.valueOf(string2) + "*FAIL*, ";
                string2 = String.valueOf(string2) + testCase.name + "," + testCase.description + "," + testCase.expect + "," + testCase.actual + "," + testCase.reason + "\n";
                string2 = String.valueOf(string2) + "</tt><br>\n";
                TestDriver.getLog(file, CASE_LOG_NAME).writeLine(string2.toString());
            }
            ++n;
        }
    }

    public static void writeDateToLogs(String string, File file) {
        Date date = new Date();
        String[] stringArray = TestDriver.getSystemInformation();
        String string2 = "<tt></tt>" + string + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + date.toString();
        TestDriver.getLog(file, SUMMARY_LOG_NAME).writeLine(string2);
        TestDriver.getLog(file, FILE_LOG_NAME).writeLine(string2);
        TestDriver.getLog(file, SUITE_LOG_NAME).writeLine(string2);
        TestDriver.getLog(file, CASE_LOG_NAME).writeLine(string2);
    }

    public static void writeFileResult(TestFile testFile, TestSuite testSuite, File file) {
        String string;
        String string2 = string = testSuite == null ? "" : testSuite.name;
        if (!testFile.passed) {
            String string3 = "";
            string3 = String.valueOf(string3) + "<tt ><font color=" + (testFile.passed ? "#00dd00>PASSED</font>&nbsp;" : "#dd0000>FAILED</font>&nbsp;") + "<a href='case.html#" + string + "-" + testFile.name + "'>" + string + " " + testFile.name + "</a > " + testFile.exception + "\n";
            if (!testFile.bugnumber.equals("")) {
                string3 = String.valueOf(string3) + "&nbsp;(<a href='http://scopus.mcom.com/bugsplat/show_bug.cgi?id=" + testFile.bugnumber + "'>" + testFile.bugnumber + "</a>)";
            }
            TestDriver.getLog(file, FILE_LOG_NAME).writeLine(string3.toString());
        }
    }

    public void writeLogHeaders(File file) {
        String string = "<table><tr><th>Test Driver <td>" + this.getClass().toString() + "</tr>" + "<tr><th>Output Directory <td>" + this.OUTPUT_DIRECTORY + "</tr>" + (this.EXECUTABLE == null ? "<tr><th>OptLevel <td>" + this.OPT_LEVEL + "</tr>" + "<tr><th>DebugLevel <td>" + this.DEBUG_LEVEL + "</tr>" : "<tr><th>Executable <td>" + this.EXECUTABLE + "</tr>") + "<tr><th>Java Version        <td>" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "</tr>" + "<tr><th>Test File Directory <td>" + this.TEST_DIRECTORY + "</tr>" + "<tr><th>Helper Functions <td>" + this.HELPER_FUNCTIONS + "</tr>" + "<tr><th>Free Memory      <td>" + this.FREE_MEMORY + "</tr>" + "<tr><th>Total JVM Memory <td>" + this.TOTAL_MEMORY + "</tr>" + "</table>";
        TestDriver.getLog(this.OUTPUT_DIRECTORY, SUITE_LOG_NAME).writeLine(string);
        TestDriver.getLog(this.OUTPUT_DIRECTORY, CASE_LOG_NAME).writeLine(string);
        TestDriver.getLog(this.OUTPUT_DIRECTORY, FILE_LOG_NAME).writeLine(string);
        TestDriver.getLog(this.OUTPUT_DIRECTORY, SUMMARY_LOG_NAME).writeLine(string);
        TestDriver.getLog(this.OUTPUT_DIRECTORY, SUMMARY_LOG_NAME).writeLine("<table width=100%><tr bgColor=#ffffcc ><th rowspan=2 width=15%> Suite<th rowspan=2 width=20%> Files<th rowspan=2 width=10%> Cases<th colspan=2 width=20% > Passed<th colspan=2 width=20%> Failed<th rowspan=2 width=15%> Result</tr><tr><th width=10%> #<th width=10%> %<th width=10%> #<th width=10%> %</tr></table>");
    }

    public static void writeSuiteResult(TestSuite testSuite, File file) {
        if (testSuite.size() <= 0) {
            return;
        }
        String string = "";
        string = String.valueOf(string) + "<tt>" + (testSuite.passed ? "<font color=#00dd00>passed</font>" : "<font color=#dd0000>FAILED</font>") + "&nbsp;" + "<a href='./../../" + testSuite.name + "'>" + testSuite.name + "</a></b>";
        if (!testSuite.passed) {
            int n = 0;
            while (n < testSuite.size()) {
                TestFile testFile = (TestFile)testSuite.elementAt(n);
                if (!testFile.passed) {
                    string = String.valueOf(string) + "&nbsp;<a href='case.html#" + testSuite.name + "-" + testFile.name + "'>" + testFile.name + "</a>";
                    if (!testFile.bugnumber.equals("")) {
                        string = String.valueOf(string) + "&nbsp;(<a href='http://scopus.mcom.com/bugsplat/show_bug.cgi?id=" + testFile.bugnumber + "'>" + testFile.bugnumber + "</a>)";
                    }
                }
                ++n;
            }
        }
        string = String.valueOf(string) + "</tt><br >";
        TestDriver.getLog(file, SUITE_LOG_NAME).writeLine(string.toString());
    }

    public static void writeSuiteSummary(TestSuite testSuite, File file) {
        if (testSuite.size() <= 0) {
            return;
        }
        String string = "";
        TestDriver.p("total :" + testSuite.totalCases);
        TestDriver.p("passed :" + testSuite.casesPassed);
        TestDriver.p("failed :" + testSuite.casesFailed);
        double d = Math.round((double)testSuite.casesPassed / (double)testSuite.totalCases * 10000.0) / 100L;
        double d2 = Math.round((double)testSuite.casesFailed / (double)testSuite.totalCases * 10000.0) / 100L;
        string = String.valueOf(string) + "<table  width=100%>";
        string = String.valueOf(string) + "<th bgcolor=#ffffcc width=15%>" + testSuite.name;
        string = String.valueOf(string) + "<th width=15% bgcolor=#ffffcc >" + testSuite.size() + "<th width=10% bgcolor=#ffffcc >" + testSuite.totalCases + "<th width=10% bgcolor=#ffffcc >" + testSuite.casesPassed + "<th width=10% bgcolor=#ffffcc >" + d + "<th width=10% bgcolor=#ffffcc >" + testSuite.casesFailed + "<th width=10% bgcolor=#ffffcc >" + d2 + "<th width=15% bgcolor=#ffffcc >" + (testSuite.passed ? "<font color=#006600 >PASSED</font >" : "<font color=#990000 >FAILED</font >") + "</tr></table>";
        int n = 0;
        while (n < testSuite.size()) {
            TestFile testFile = (TestFile)testSuite.elementAt(n);
            double d3 = 0.0;
            double d4 = 0.0;
            if (testFile.totalCases > 0) {
                d3 = Math.round((double)testFile.casesPassed / (double)testFile.totalCases * 10000.0) / 100L;
                d4 = Math.round((double)testFile.casesFailed / (double)testFile.totalCases * 10000.0) / 100L;
            }
            string = String.valueOf(string) + "<table  width=100%><tr><td width=15%><td width=15% ><a href='case.html#" + testSuite.name + "-" + testFile.name + "'>" + testFile.name + "</a>" + "<td width=10%>" + testFile.totalCases + "<td width=10% bgColor=#ccffcc >" + testFile.casesPassed + "<td width=10% bgColor=#ccffcc >" + d3 + "<td width=10% bgColor=#ffcccc >" + testFile.casesFailed + "<td width=10% bgColor=#ffcccc >" + d4 + "<td width=15%>" + (testFile.passed ? "<font color=#006600 >PASSED</font >" : "<font color=#990000 >FAILED</font >") + (testFile.reason.equals("") ? "" : ":  " + testFile.reason) + (testFile.exception.equals("") ? "" : ":<br>" + testFile.exception) + "<tr ></table>";
            ++n;
        }
        TestDriver.getLog(file, SUMMARY_LOG_NAME).writeLine(string.toString());
    }

    public void writeTinderboxHeader(String string) {
        String string2 = "--------------------------------------------------------------";
        String string3 = string == null ? "ns/js/rhino" : "ns/js/ref";
        String string4 = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        String string5 = String.valueOf(System.getProperty("java.vendor")) + " " + System.getProperty("java.version");
        System.out.println(string2);
        System.out.println("Product            " + string3);
        System.out.println("Operating System   " + string4);
        System.out.println("Java Version       " + string5);
        System.out.println("Free Memory        " + this.FREE_MEMORY);
        System.out.println("Total JVM Memory   " + this.TOTAL_MEMORY);
        System.out.println("Test Driver        " + this.getClass().getName());
        System.out.println("Output Directory   " + this.OUTPUT_DIRECTORY);
        System.out.println("Path to Executable " + this.EXECUTABLE);
        if (string3.equals("ns/js/rhino")) {
            System.out.println("Optimization Level " + this.OPT_LEVEL);
            System.out.println("Debug level        " + this.DEBUG_LEVEL);
        }
        System.out.println("Test Directory     " + this.TEST_DIRECTORY);
        System.out.println(string2);
    }

    public void writeTinderboxSuiteName(TestSuite testSuite) {
        System.out.println("Suite              " + testSuite.name);
    }

    public void writeTinderboxSuiteResult(TestSuite testSuite) {
        String string = "--------------------------------------------------------------";
        System.out.println("Result             " + (testSuite.passed ? "PASSED" : "FAILED"));
        if (!testSuite.passed) {
            System.out.println("Failed Files       ");
            int n = 0;
            while (n < testSuite.size()) {
                TestFile testFile = (TestFile)testSuite.elementAt(n);
                if (!testFile.passed) {
                    System.out.println(String.valueOf(testFile.name) + (testFile.bugnumber.equals("") ? "" : " http://scopus.mcom.com/bugsplat/show_bug.cgi?id=" + testFile.bugnumber + " "));
                }
                ++n;
            }
        }
        System.out.println(string);
    }
}

