/* xpm2wico - .xpm to Windows .ico format converter
 *
 * Copyright (C) 2001 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef XPM2ICO_H
#define XPM2ICO_H

typedef unsigned char Byte;
typedef unsigned short Word;

#if defined(__alpha) || (defined(_MIPS_SZLONG) && _MIPS_SZLONG == 64)
typedef unsigned int DWord;
typedef int Long;
#else
typedef unsigned long DWord;
typedef long Long;
#endif

typedef struct _IconDir IconDir;
typedef struct _IconDirectoryEntry IconDirEntry;
typedef struct _BitmapInfoHeader BitmapInfoHeader;
typedef struct _RGBQuad RGBQuad;

struct _IconDir
{
  Word idReserved;
  Word idType;
  Word idCount;
  IconDirEntry   *idEntries;
};

struct _IconDirectoryEntry
{
  Byte bWidth;
  Byte bHeight;
  Byte bColorCount;
  Byte bReserved;
  Word wPlanes;
  Word wBitCount;
  DWord dwBytesInRes;
  DWord dwImageOffset;
};

struct _BitmapInfoHeader
{
  DWord biSize;
  Long biWidth;
  Long biHeight;
  Word biPlanes;
  Word biBitCount;
  DWord biCompression;
  DWord biSizeImage;
  Long biXPelsPerMeter;
  Long biYPelsPerMeter;
  DWord biClrUsed;
  DWord biClrImportant;
};

struct _RGBQuad
{
  Byte rgbBlue;
  Byte rgbGreen;
  Byte rgbRed;
  Byte rgbReserved;
};

#endif
