;;; Disarchive
;;; Copyright © 2020, 2021 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Disarchive.
;;;
;;; Disarchive is free software: you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation, either version 3 of the License, or
;;; (at your option) any later version.
;;;
;;; Disarchive is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Disarchive.  If not, see <http://www.gnu.org/licenses/>.

(define-module (disarchive scripts assemble)
  #:use-module (disarchive)
  #:use-module (disarchive utils)
  #:use-module (ice-9 match)
  #:export (assemble-main))

(define (make-resolver input)
  (lambda (addresses output)
    (copy-recursively input output #:log (%make-void-port "w"))))

(define (assemble-main . args)
  (%disarchive-log-port (current-error-port))
  (match args
    ((specification input output)
     (disarchive-assemble specification output
                          #:resolver (make-resolver input)))
    (_ (display "Usage: disarchive assemble SPECIFICATION INPUT OUTPUT\n"))))
