/* Copyright (C) 2022-2024 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */


package org.gprofng.mpmt.navigation;

import org.gprofng.analyzer.AnEnvironment;
import org.gprofng.mpmt.AnLocale;
import org.gprofng.mpmt.AnWindow;
import org.gprofng.mpmt.util.gui.AnUtility;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.event.MouseInputAdapter;

public class TopNavigationPanel extends javax.swing.JPanel {
  private AnWindow anWindow;
  private JButton previousViewButton;
  private JButton nextViewButton;

  /** Creates new form TopNavigationPanel */
  public TopNavigationPanel(final AnWindow anWindow) {
    this.anWindow = anWindow;
    initComponents();

    previousViewButton = AnWindow.getInstance().getPreviousViewAction().createActionButton();
    GridBagConstraints gridBagConstraints = new GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = GridBagConstraints.LINE_END;
    add(previousViewButton, gridBagConstraints);

    nextViewButton = AnWindow.getInstance().getNextViewAction().createActionButton();
    gridBagConstraints = new GridBagConstraints();
    gridBagConstraints.gridx = 2;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.insets = new Insets(0, 2, 0, 0);
    gridBagConstraints.anchor = GridBagConstraints.LINE_END;
    add(nextViewButton, gridBagConstraints);

    label.setFont(label.getFont().deriveFont(Font.BOLD));
    setBackground(AnEnvironment.NAVIGATION_PANEL_SECTION_BACKGROUND_COLOR);
    //        seperator.setForeground(AnEnvironment.VIEW_SELECTED_BORDER_COLOR);
    setBorder(
        BorderFactory.createMatteBorder(
            0, 0, 1, 0, AnEnvironment.NAVIGATION_SPLIT_PANE_DIVIDER_COLOR));
    label.setText(AnLocale.getString("Views"));
    AnUtility.setAccessibleContext(label.getAccessibleContext(), label.getText());
    label.setDisplayedMnemonic(AnLocale.getString('W', "MainPanelViewsMN"));
    label.setLabelFor(showTabConfigurationButton);
    //        label.setFont(label.getFont().deriveFont(((float)label.getFont().getSize()+1)));
    showTabConfigurationButton.setBackground(
        AnEnvironment.NAVIGATION_PANEL_SECTION_BACKGROUND_COLOR);
    showTabConfigurationButton.setToolTipText(AnLocale.getString("More views..."));
    showTabConfigurationButton.addActionListener(
        new ActionListener() {
          @Override
          public void actionPerformed(ActionEvent e) {
            anWindow
                .getViewsPanel()
                .toggleViewsConfigurationPopup(showTabConfigurationButton, 15, 15);
          }
        });
    showTabConfigurationButton.addMouseListener(
        new MouseInputAdapter() {
          @Override
          public void mouseEntered(MouseEvent evt) {
            JButton btn = (JButton) evt.getSource();
            if (btn.isEnabled()) {
              btn.setBorderPainted(true);
              btn.setContentAreaFilled(true);
            }
          }

          @Override
          public void mouseExited(MouseEvent evt) {
            JButton btn = (JButton) evt.getSource();
            if (btn.isEnabled()) {
              btn.setBorderPainted(false);
              btn.setContentAreaFilled(false);
            }
          }
        });

    addMouseListener(
        new MouseAdapter() {
          @Override
          public void mouseClicked(MouseEvent e) {
            if (e.getButton() == MouseEvent.BUTTON3) {
              anWindow
                  .getViewsPanel()
                  .showViewsConfigurationPopup(
                      TopNavigationPanel.this, e.getPoint().x + 5, e.getPoint().y + 5);
            }
          }
        });
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    label = new javax.swing.JLabel();
    showTabConfigurationButton = new javax.swing.JButton();

    setLayout(new java.awt.GridBagLayout());

    label.setText("NOI18N");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
    add(label, gridBagConstraints);

    showTabConfigurationButton.setIcon(
        new javax.swing.ImageIcon(
            getClass().getResource("/org/gprofng/mpmt/icons/more_icon.png")));
    showTabConfigurationButton.setBorderPainted(false);
    showTabConfigurationButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
    showTabConfigurationButton.setOpaque(false);
    showTabConfigurationButton.addActionListener(
        new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
            showTabConfigurationButtonActionPerformed(evt);
          }
        });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 10;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
    add(showTabConfigurationButton, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  private void showTabConfigurationButtonActionPerformed(
      java.awt.event.ActionEvent evt) { // GEN-FIRST:event_showTabConfigurationButtonActionPerformed
    //        showTabConfigurationActionPerformed(true,
    // showTabConfigurationButton.getLocation().x+10,
    // showTabConfigurationButton.getLocation().y+10);
  } // GEN-LAST:event_showTabConfigurationButtonActionPerformed

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel label;
  private javax.swing.JButton showTabConfigurationButton;
  // End of variables declaration//GEN-END:variables
}
