#include <config.h>
#include <samplerate.h>
#include "filter.h"
#include "sample.h"

struct filter_format {
    struct filter filter;
    enum sample_type format;
    size_t bufsz;
    void *inbuf;
};

struct filter *
filter_format_new(struct filter *src,
                  size_t sz,
                  enum sample_type format) {
    struct filter *f = filter_new(src, sz);

    if(!f) 
        return NULL;

    f->read = filter_format_read;
    f->write = filter_format_write;
    f->seek = filter_format_seek;
    f->destroy = filter_format_destroy;
    f->get_format = filter_format_get_format;
    f->get_channels = src->get_channels;

    ((struct filter_format *)f)->format = format;
    ((struct filter_format *)f)->bufsz = 16384; 
    ((struct filter_format *)f)->inbuf = 
        mem_alloc(f->src->get_format(f->src) * 
                  f->src->get_channels(f->src) * 16384);
    
    return f;
}

void
filter_format_destroy(struct filter *f) {
    mem_free(((struct filter_format *)f)->inbuf);
    f->src->destroy(f);
}

long long
filter_format_read(struct filter *f, 
                   void *buf, 
                   long long *count) {
    long long c = CLAMP(*count, 0, ((struct filter_format *)f)->bufsz);
    long long r;

    r = f->src->read(f->src, ((struct filter_format *)f)->inbuf, &c);

    if(r <= 0)
        return r;

    sample_convert(f->src->get_format(f->src), 
                   ((struct filter_format *)f)->format,
                   ((struct filter_format *)f)->inbuf,
                   buf,
                   r * f->src->get_channels(f->src));

    *count = c;

    return r;
}

long long
filter_resample_write(struct filter *f, 
                      void *buf, 
                      long long *count) {
    return -ENOSYS;
}


long long
filter_resample_seek(struct filter *f, 
                     long long *count,
                     int whence) {
    return -ENOSYS;
}

enum sample_type
filter_format_get_format(struct filter *f) {
    return ((struct filter_format *)f)->format;
}

