#include <stdio.h>
#include <stdlib.h>				/* for rand */
#include <time.h>				/* for time */

#include <gh.h>

/* Guile 1.2 does not include the "random" or "randomize" Scheme
   primitives, so I need to fake it here. */

SCM
scm_random (SCM s_n)
{
  int result;
  int n;

  n = gh_scm2int (s_n);
  result = (int) ((double)rand() / ((double)RAND_MAX + 1.0) * n);

  /* If you're worried about using floating point, you could use
     result = (int) (rand() / (RAND_MAX / n + 1)); */

  /* Both methods obviously require knowing RAND_MAX (which ANSI
     #defines in <stdlib.h>), and assume that N is much less than
     RAND_MAX. */

  /* References: K&R2 Sec. 7.8.7 p. 168; PCS Sec. 11 p. 172. */

  return (gh_int2scm (n));
}

SCM
scm_randomize (void)
{
  time_t t;

  time (&t);
  srand ((int) t);

  return (SCM_BOOL_T);
}
