/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog;

import java.io.InputStream;
import java.util.Properties;

public final class Version {
    private Version() {
    }

    public static String getVersion() {
        if (VersionInternal.type == null || VersionInternal.type.length() == 0) {
            return String.format("%d.%d.%d", VersionInternal.major, VersionInternal.minor, VersionInternal.revision);
        }
        return String.format("%d.%d.%d %s", VersionInternal.major, VersionInternal.minor, VersionInternal.revision, VersionInternal.type);
    }

    public static int getMajor() {
        return VersionInternal.major;
    }

    public static int getMinor() {
        return VersionInternal.minor;
    }

    public static int getRevision() {
        return VersionInternal.revision;
    }

    public static int intEncoded() {
        return Version.getMajor() * 10000 + Version.getMinor() * 100 + Version.getRevision();
    }

    public static String getReleaseType() {
        return VersionInternal.type;
    }

    private static final class VersionInternal {
        static int major;
        static int minor;
        static int revision;
        static String type;

        private VersionInternal() {
        }

        static {
            type = null;
            Properties prop = new Properties();
            InputStream is = VersionInternal.class.getResourceAsStream("version.properties");
            if (is != null) {
                try {
                    prop.load(is);
                    String base = "gnu.prolog";
                    major = Integer.parseInt(prop.getProperty("gnu.prolog.version.major", Integer.toString(major)));
                    minor = Integer.parseInt(prop.getProperty("gnu.prolog.version.minor", Integer.toString(minor)));
                    revision = Integer.parseInt(prop.getProperty("gnu.prolog.version.revision", Integer.toString(revision)));
                    type = prop.getProperty("gnu.prolog.version.type", type);
                    is.close();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }
}

