/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.RelativeTimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelativeTime
implements Comparable<RelativeTime> {
    private static final Logger logger = LoggerFactory.getLogger(RelativeTime.class);
    public static final RelativeTime MICROSECOND = new RelativeTime(1L);
    public static final RelativeTime MILLISECOND = MICROSECOND.multiply(1000);
    public static final RelativeTime SECOND = MILLISECOND.multiply(1000);
    public static final RelativeTime MINUTE = SECOND.multiply(60);
    public static final RelativeTime HOUR = MINUTE.multiply(60);
    public static final RelativeTime DAY = HOUR.multiply(24);
    public static final RelativeTime WEEK = DAY.multiply(7);
    public static final RelativeTime MONTH = DAY.multiply(30);
    public static final RelativeTime YEAR = DAY.multiply(365);
    public static final RelativeTime ZERO = new RelativeTime(0L);
    public static final RelativeTime FOREVER = new RelativeTime(Long.MAX_VALUE);
    public static final RelativeTime STD_BACKOFF = MILLISECOND;
    public static final RelativeTime STD_BACKOFF_MAX = MINUTE.multiply(15);
    private final long rel_value_us;

    public RelativeTime(long abs_value) {
        this.rel_value_us = abs_value;
    }

    public static RelativeTime fromMilliseconds(long ms) {
        return new RelativeTime(ms * 1000L);
    }

    public static RelativeTime fromMicroseconds(long us) {
        return new RelativeTime(us);
    }

    public RelativeTime add(RelativeTime other) {
        if (this.rel_value_us == Long.MAX_VALUE || other.rel_value_us == Long.MAX_VALUE) {
            return FOREVER;
        }
        long new_rel_value = this.rel_value_us + other.rel_value_us;
        if (new_rel_value < this.rel_value_us) {
            logger.warn("time overflow");
            return FOREVER;
        }
        return new RelativeTime(new_rel_value);
    }

    public RelativeTime divide(int factor) {
        if (factor == 0 || this.rel_value_us == Long.MAX_VALUE) {
            return FOREVER;
        }
        return new RelativeTime(this.rel_value_us / (long)factor);
    }

    public long getMicroseconds() {
        return this.rel_value_us;
    }

    public static RelativeTime max(RelativeTime t1, RelativeTime t2) {
        return t1.rel_value_us >= t2.rel_value_us ? t1 : t2;
    }

    public static RelativeTime min(RelativeTime t1, RelativeTime t2) {
        return t1.rel_value_us <= t2.rel_value_us ? t1 : t2;
    }

    public RelativeTime multiply(int factor) {
        if (factor == 0) {
            return ZERO;
        }
        long ret = this.rel_value_us * (long)factor;
        if (ret / (long)factor != this.rel_value_us) {
            logger.warn("time overflow");
            return FOREVER;
        }
        return new RelativeTime(ret);
    }

    public RelativeTime subtract(RelativeTime other) {
        if (this.rel_value_us >= other.rel_value_us) {
            return ZERO;
        }
        if (this.rel_value_us == Long.MAX_VALUE) {
            return this;
        }
        return new RelativeTime(this.rel_value_us - other.rel_value_us);
    }

    public AbsoluteTime toAbsolute() {
        return AbsoluteTime.now().add(this);
    }

    public boolean isForever() {
        return this.rel_value_us == RelativeTime.FOREVER.rel_value_us;
    }

    public boolean equals(Object o) {
        return o instanceof RelativeTime && ((RelativeTime)o).rel_value_us == this.rel_value_us;
    }

    public int hashCode() {
        return (int)this.rel_value_us;
    }

    @Override
    public int compareTo(RelativeTime other) {
        if (this.rel_value_us < other.rel_value_us) {
            return -1;
        }
        if (this.rel_value_us > other.rel_value_us) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        if (this.isForever()) {
            return "RelativeTime(FOREVER)";
        }
        return "RelativeTime(" + this.rel_value_us + ")";
    }

    public RelativeTimeMessage toNetwork() {
        long rval = this.rel_value_us;
        assert (rval >= 0L);
        if (rval == RelativeTime.FOREVER.rel_value_us) {
            rval = -1L;
        }
        return new RelativeTimeMessage(rval);
    }

    public static RelativeTime fromNetwork(RelativeTimeMessage m) {
        if (m.value__ < 0L) {
            return FOREVER;
        }
        return new RelativeTime(m.value__);
    }

    public RelativeTime backoff() {
        return RelativeTime.min(STD_BACKOFF_MAX, this.multiply(2));
    }

    public long getSeconds() {
        return this.rel_value_us / 1000000L;
    }

    public static RelativeTime fromSeconds(long i) {
        RelativeTime relativeTime = new RelativeTime(i * 1000L * 1000L);
        return relativeTime;
    }
}

