/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.testing;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.gnunet.testing.TestingSetup;
import org.gnunet.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingSubsystem {
    private static final Logger logger = LoggerFactory.getLogger(TestingSubsystem.class);
    private Process p;
    private BufferedReader reader;
    private OutputStreamWriter writer;
    private Configuration cfg;

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public TestingSubsystem(String service) {
        this(service, null);
    }

    public TestingSubsystem(String service, String configFilename) {
        String cfgFileName;
        String started;
        String[] args = configFilename == null ? new String[]{"gnunet-testing", "-r", service} : new String[]{"gnunet-testing", "-r", service, "-c", configFilename};
        try {
            this.p = Runtime.getRuntime().exec(args);
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.p.getInputStream(), Charsets.UTF_8));
        this.writer = new OutputStreamWriter(this.p.getOutputStream(), Charsets.UTF_8);
        try {
            started = this.reader.readLine();
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        if (started == null || !started.equals("ok")) {
            throw new TestingSetup.SetupException("could not start service ('" + started + "')");
        }
        try {
            cfgFileName = this.reader.readLine();
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        if (cfgFileName == null) {
            throw new TestingSetup.SetupException("could not start subsystem for testing: no config file received from helper");
        }
        this.cfg = new Configuration();
        this.cfg.parse(cfgFileName);
    }

    public void destroy() {
        try {
            this.writer.write("q\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        try {
            this.p.waitFor();
        }
        catch (InterruptedException e) {
            throw new TestingSetup.SetupException(e);
        }
        if (this.p.exitValue() != 0) {
            throw new TestingSetup.SetupException("gnunet-testing exit value unsuccessful");
        }
    }

    public void restart() {
        String response;
        try {
            this.writer.write("r\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        logger.debug("waiting for gnunet-testing to respond to restart");
        try {
            response = this.reader.readLine();
        }
        catch (IOException e) {
            throw new TestingSetup.SetupException(e);
        }
        if (response == null || !response.equals("restarted")) {
            throw new TestingSetup.SetupException("wrapper did not cooperate");
        }
        logger.debug("restart successful");
    }
}

