/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class IntegerUtil {
    public static long readLong(ByteBuffer srcBuf, boolean isSigned, int byteSize) {
        int s;
        int b;
        long val = 0L;
        int first = srcBuf.position();
        int last = first + byteSize - 1;
        while (srcBuf.position() != last) {
            b = srcBuf.get();
            s = b >= 0 ? b : 256 + b;
            val |= (long)s;
            val <<= 8;
        }
        b = srcBuf.get();
        s = b >= 0 ? b : 256 + b;
        val |= (long)s;
        if (isSigned) {
            long sign = srcBuf.get(first) & 0x80;
            val |= sign << 7;
        }
        return val;
    }

    public static void writeLong(long val, ByteBuffer dstBuf, boolean isSigned, int byteSize) {
        long myval = val;
        for (int last = dstBuf.position() + byteSize - 1; last >= dstBuf.position(); --last) {
            dstBuf.put(last, (byte)(myval & 0xFFL));
            myval >>>= 8;
        }
        if (isSigned) {
            byte sign = (byte)(val >>> 56 & 0x80L);
            dstBuf.put(dstBuf.position() + byteSize - 1, (byte)(dstBuf.get(dstBuf.position() + byteSize - 1) & ~sign));
            dstBuf.put(dstBuf.position(), (byte)(dstBuf.get(dstBuf.position()) | sign));
        }
        dstBuf.position(dstBuf.position() + byteSize);
    }

    public static void writeBitInteger(BigInteger big, ByteBuffer dstBuf, boolean isSigned, int byteSize) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static BigInteger readBigInteger(ByteBuffer srcBuf, boolean isSigned, int byteSize) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

