/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.consensus;

import com.google.common.base.Preconditions;
import org.gnunet.consensus.ConsensusCallback;
import org.gnunet.consensus.ConsensusElement;
import org.gnunet.consensus.InsertDoneCallback;
import org.gnunet.consensus.messages.ConcludeDoneMessage;
import org.gnunet.consensus.messages.ConcludeMessage;
import org.gnunet.consensus.messages.InsertElementMessage;
import org.gnunet.consensus.messages.JoinMessage;
import org.gnunet.consensus.messages.NewElementMessage;
import org.gnunet.mq.Envelope;
import org.gnunet.mq.NotifySentHandler;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consensus {
    private static final Logger logger = LoggerFactory.getLogger(Consensus.class);
    private Client client;
    private ConsensusCallback consensusCallback;

    public Consensus(Configuration cfg, PeerIdentity[] peers, HashCode sessionId, AbsoluteTime startTime, AbsoluteTime deadline) {
        this.client = new Client("consensus", cfg);
        this.client.installReceiver(new ConsensusMessageReceiver());
        String peersString = "";
        for (PeerIdentity pi : peers) {
            peersString = peersString + pi + ", ";
        }
        logger.info("starting consensus with {} peers given to consensus ({})", (Object)peers.length, (Object)peersString);
        JoinMessage m = new JoinMessage();
        m.numPeers = peers.length;
        m.peers = peers;
        m.sessionId = sessionId;
        m.startTime = startTime.asMessage();
        m.deadline = deadline.asMessage();
        this.client.send(m);
    }

    public void insertElement(ConsensusElement element) {
        this.insertElement(element, null);
    }

    public void insertElement(ConsensusElement element, final InsertDoneCallback idc) {
        InsertElementMessage m = new InsertElementMessage();
        m.elementData = element.data;
        m.elementType = element.elementType;
        Envelope ev = new Envelope(m);
        if (null != idc) {
            ev.notifySent(new NotifySentHandler(){

                @Override
                public void onSent() {
                    idc.onInsertDone();
                }
            });
        }
        this.client.send(ev);
    }

    public void conclude(ConsensusCallback concludeCallback) {
        Preconditions.checkNotNull((Object)concludeCallback, (Object)"conclude with null callback");
        Preconditions.checkState((null == this.consensusCallback ? 1 : 0) != 0, (Object)"called conclude twice");
        this.consensusCallback = concludeCallback;
        ConcludeMessage m = new ConcludeMessage();
        this.client.send(m);
    }

    public void destroy() {
        this.client.disconnect();
        this.client = null;
    }

    private class ConsensusMessageReceiver
    extends RunaboutMessageReceiver {
        private ConsensusMessageReceiver() {
        }

        public void visit(ConcludeDoneMessage m) {
            if (null == Consensus.this.consensusCallback) {
                logger.error("unexpected conclude done message");
                return;
            }
            Consensus.this.consensusCallback.onDone();
        }

        public void visit(NewElementMessage m) {
            ConsensusElement element = new ConsensusElement(m.elementData, m.elementType);
            element.elementType = m.elementType;
            element.data = m.elementData;
            Consensus.this.consensusCallback.onElement(element);
        }

        @Override
        public void handleError() {
            System.out.println("Error receiving from consensus service.");
            Consensus.this.consensusCallback.onElement(null);
        }
    }
}

