.\" Copyright (c) 1993 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution .in +0.9i
.TH query-pr 1 "October 1993" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
query-pr \- query problem reports in the 
.B GNATS
database
.SH SYNOPSIS
.hy 0
.na
.B query\-pr
.RS
[
.B \-c \fIcategory\fB | \-\-category=\fIcategory\fB
]
.br
[
.B \-s \fIstate\fB | \-\-state=\fIstate\fB
]
.br
[
.B \-r \fIresponsible\fB | \-\-responsible=\fIresponsible\fB
]
.br
[
.B \-S \fIsubmitter\fB | \-\-submitter=\fIsubmitter\fB
]
.br
[
.B \-C [\fIyes\fB|\fIno\fB] | \-\-confidential[=\fIyes\fB|\fIno\fB]
]
.br
[
.B \-e \fIseverity\fB | \-\-severity=\fIseverity\fB
]
.br
[
.B \-p \fIpriority\fB | \-\-priority=\fIpriority\fB
]
.br
[
.B \-O \fIname\fB | \-\-originator=\fIname\fB
]
.br
[
.B \-t \fItext\fP | \-\-text=\fItext\fP
]
.br
[
.B \-m \fItext\fP | \-\-multitext=\fItext\fP
]
.br
[
.B \-R | \-\-restricted
]
.br
[
.B \-F | \-\-full
] [
.B \-q | \-\-summary
] [
.B \-i | \-\-sql
]
.br
[
.B \-P | \-\-print\-path
]
.br
[
.B \-d \fIdirectory\fB | \-\-directory=\fIdirectory\fB
]
.br
[
.B \-o \fIoutfile\fB | \-\-output=\fIoutfile\fB
]
.br
[
.B \-V | \-\-version
]
[
.B \-h | \-\-help 
]
.br
[
.I gnats-id
.I .\|.\|.
]

.ad b
.hy 1
.SH DESCRIPTION
Queries the 
.B GNATS
database according to options and displays Problem Reports on standard output.
If you specify particular PR numbers (with the
.IR gnats-id .\|.\|.
arguments),
.B query\-pr
restricts its search to only those PRs.
Using
.B query\-pr
with no options or
.I gnats-id .\|.\|.
arguments displays a summary of every PR in the database.
.LP
All options are connected with a logical
.BR AND .
For example,
.RS
.B query\-pr \-\-category=\fIcategory\fB \-\-responsible=\fIresponsible\fR
.RE
only prints PRs which have a 
.B >Category:
field of
.I category
and a 
.B >Responsible:
field of
.IR responsible .
.SH OPTIONS
.TP 0.5i
.B \-c \fIcategory\fB, \-\-category=\fIcategory\fB
Search only for PRs with a
.B >Category:
field of 
.IR category .
.TP
.B \-s \fIstate\fB, \-\-state=\fIstate\fB
Search only for PRs with a
.B >State:
field of 
.IR state .
.TP
.B \-r \fIresponsible\fB, \-\-responsible=\fIresponsible\fB
Search only for PRs with a
.B >Responsible:
field of 
.IR responsible .
.TP
.B \-S \fIsubmitter\fB, \-\-submitter=\fIsubmitter\fB
Search only for PRs with a
.B >Submitter\-Id:
field of 
.IR submitter .
.TP
.B \-C [\fIyes\fB|\fIno\fB], \-\-confidential[=\fIyes\fB|\fIno\fB]
Search only for PRs with a 
.B >Confidential:
field of either
.I yes
or 
.IR no ,
respectively.  If this option is not given, all PRs will be eligible
for the search, regardless of their confidentiality.
.TP
.B \-e \fIseverity\fB, \-\-severity=\fIseverity\fB
Search only for PRs with a
.B >Severity:
field of
.IR severity .
.TP
.B \-p \fIpriority\fB, \-\-priority=\fIpriority\fB
Search only for PRs with a
.B >Priority:
field of
.IR priority .
.TP
.B \-O \fIname\fB, \-\-originator=\fIname\fB
Search for \fIname\fP in the
.B >Originator:
field of each PR.  \fIname\fP need only be enough to uniquely identify the
person.  For example, to find "Steve Williams", you could use a
\fIname\fP of "Steve W".
Use another search option (e.g.
.B \-\-state\c
\&), to speed the search.  Using
.B \-O
by itself can be slow with a large database.  You must enclose the
name with double-quotes to make sure your shell passes it as a single
string, and not as separate arguments to
.BR query\-pr .
.TP
.B \-t \fItext\fP, \-\-text=\fItext\fP
Search single-line text fields in all PRs for the regular 
expression \fItext\fP.
.TP
.B \-m \fItext\fP, \-\-multitext=\fItext\fP
Search multiple-line text fields in all PRs for the regular
expression \fItext\fP.
.TP
.B \-R, \-\-restricted
Omit from the search any PR marked
.BR ">Confidential: yes" .
This is equivalent to specifying
.BR \-\-confidential=no .
This also disallows the use of the options
.br
.BI --outfile= outfile
and
.BI --directory= directory\fR.
.TP
.B \-F, \-\-full
Prints the full Problem Report rather than just a summary.
.TP
.B \-q, \-\-summary
Give a short summary line for PRs. 
.TP
.B \-i, \-\-sql
Prints data in a format readable by a relational database (see
the GNATS manual
.I Keeping Track
for a full explanation).
.TP
.B \-P, \-\-print\-path
Print the path used to find each PR.
.TP
.B \-d \fIdirectory\fB, \-\-directory=\fIdirectory\fB
Changes the search directory to 
.IR directory .
.TP
.B \-o \fIoutfile\fB, \-\-output=\fIoutfile\fB
Print all output to
.I outfile
rather than to the standard output.
.TP
.B \-V, \-\-version
Prints the version number of
.BR query\-pr .
.TP
.B \-h, \-\-help 
Prints a brief usage summary.
.SH QUERY BY MAIL
.B query-pr
can also be accessed by electronic mail, if your version
of GNATS is configured for this.  To use this feature, simply send
mail to the address 
.BI query-pr@ your-site
with command line arguments or options in the 
.B Subject:
line of the mail header.  GNATS replies to your mail with the results
of your query.  The default settings for the
.B query-pr
mail server are shown below; to override the
.B --state
parameter, specify
.BI --state= state
in the
.B Subject:
line of the mail header.  You can not query on confidential Problem
Reports by mail.
.TP 1i
.B --restricted --state="open|analyzed|feedback|suspended"
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (l),
.BR send-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
