/* -*- mode: c++ -*- 
*/
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
// -*- Mode: c++ -*-
#ifndef _CACCESSORCOLLECTION
#define _CACCESSORCOLLECTION

#include <map>
#include "CAccessorProxy.h"

class CXMLElement;

/** This is in fact a collection of collections.

    The accessorcollection contains CAccessorProxys
    
*/  
class CAccessorCollection{
  /** A helper for building up an CXMLElement which will
      later serve as configuration for the new CAccessorProxy
  */
  CXMLElement* mCollectionInConstruction;
  


  /** this is mainly a map from string to accessor proxy
      we would like to destroy this in a decent way */
  class CContent:public map<string,CAccessorProxy*>{
  public:
    /** */
    ~CContent();
  };
  /**  */
  CContent mIDToProxy;
  /**  */
  CAccessorProxy* mCurrentProxy;

  /** for easier read access from the outside */
  typedef CContent::const_iterator const_iterator;

public:
  /** for reading all accessors*/
  CContent::const_iterator begin()const;
  /** for reading all accessors*/
  CContent::const_iterator end()const;
  /**  
       The Accessor collection gets its
       configuration out of the same
       file as the CSessionManager
  */
  CAccessorCollection(string inFileName);
  /**  
       add an accessor to a collection to our list of proxies.
  */
  void addCollection(CXMLElement* inCollectionElement);
  /**  get the proxy on which is presently worked on
   */
  CAccessorProxy& getCurrentProxy();
  /**  get a proxy for a given collectionID*/
  CAccessorProxy& getProxy(const string& inID);
  /**  simply take the first.*/
  string getDefaultAccessorID()const;
  /**  some tags plus our content */
  string toXML(bool isPrivate=false)const;
  /**  The content of this as an CXMLElement */
  CXMLElement* toXMLElement()const;
  /** 
      get list of all algorithms
   */
  list<string>* getAllQueryMethods()const;
  /** 
      get the XMLElement in construction
  */
  CXMLElement* getCollectionInConstruction();
  /** 
      set the element 
  */
  void startCollectionConstruction(CXMLElement* inRoot);
};

#endif
