;-*- Mode:     Lisp -*-
;;;; Author:   Paul Dietz
;;;; Created:  Sat Apr 19 22:03:01 2003
;;;; Contains: Tests of LIST-LENGTH

(in-package :cl-test)

(deftest list-length-nil
  (list-length nil)
  0)

(deftest list-length-list
  (list-length '(a b c d e f))
  6)

;; check that list-length returns nil
;; on a circular list

(deftest list-length-circular-list
  (let ((x (cons nil nil)))
    (let ((y (list* 1 2 3 4 5 6 7 8 9 x)))
      (setf (cdr x) y)
      (let ((z (list* 'a 'b 'c 'd 'e y)))
	(list-length z))))
  nil)

(deftest list-length.order.1
  (let ((i 0))
    (values (list-length (progn (incf i) '(a b c))) i))
  3 1)


(deftest list-length.4
  (list-length (copy-tree '(a b c)))
  3)

;; Check that list-length produces a type-error
;; on arguments that are not proper lists or circular lists

(deftest list-length.error.1
  (loop
   for x in (list 'a 1 1.0 #\w (make-array '(10))
		  '(a b . c) (symbol-package 'cons))
   count (not (eqt (catch-type-error (list-length x))
		   'type-error)))
  0)

(deftest list-length.error.2
  (classify-error (list-length))
  program-error)

(deftest list-length.error.3
  (classify-error (list-length nil nil))
  program-error)

(deftest list-length.error.4
  (classify-error (list-length 'a))
  type-error)

(deftest list-length.error.5
  (classify-error (locally (list-length 'a) t))
  type-error)

(deftest list-length-symbol
  (classify-error (list-length 'a))
  type-error)

(deftest list-length-dotted-list
  (classify-error (list-length (copy-tree '(a b c d . e))))
  type-error)
