/*
 *	This defines a VAX-11 "C" runtime compatible stdio interface
 */
#ifndef __STDIO_DEFINED
#define __STDIO_DEFINED

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	The maximum number of files we can have open at a time
 */
#define _NFILE 20

/*
 *	STDIO buffer size (sure wish it could be 1Kb)
 */
#ifndef BUFSIZ
#define BUFSIZ 512
#endif
/*
 *	This is what the VAX-11 "C" runtime stdio FILE structure looks like
 */
struct	_iobuf 	{
	int	_cnt;			/* # of characters in the buffer */
	char	*_ptr;			/* Pointer into the buffer	 */
	char	*_base;			/* Pointer to start of buffer	 */
	char	_flag;			/* STDIO flags			 */
#define	_IOREAD		01			/* Open for reading	 */
#define	_IOWRT		02			/* Open for writing	 */
#define	_IONBF		04			/* No buffer		 */
#define	_IOMYBUF	010			/* Using "my" buffer	 */
#define	_IOEOF		020			/* At End Of File	 */
#define	_IOERR		040			/* I/O error has occured */
#define	_IOSTRG		0100			/* Doing I/O to a string */
#define	_IORW		0200			/* Open for read/write	 */
	char	_file;			/* File descriptor		 */
	};

/*
 *	Instead of passing around pointers to _iobuf structures, VAX-11 "C"
 *	passes around pointers to pointers.
 */
typedef struct _iobuf *FILE;
typedef struct {unsigned : 32; unsigned : 32;} fpos_t;

/*
 *	Also, stdin/stdout/stderr need to be defined
 *	[We also use a hack here that makes the GCC assembler modify
 *	 the psect attributes to match those of the VAX-11 "C" runtime]
 */
extern FILE *stdin __asm("_$$PsectAttributes_NOSHR$$stdin");
extern FILE *stdout __asm("_$$PsectAttributes_NOSHR$$stdout");
extern FILE *stderr __asm("_$$PsectAttributes_NOSHR$$stderr");

/*
 *	Define NULL and EOF
 */
#ifndef NULL  /* in case stddef.h defines it */
#define	NULL		0
#endif
#define	EOF		(-1)

/*
 *	Define the stdio macros
 */
#define getc(p)		fgetc(p)
#define getchar()	fgetc(stdin)
#define putc(x,p)	fputc(x,p)
#define putchar(x)	fputc(x,stdout)
#define feof(p)		(((*p)->_flag&_IOEOF)!=0)
#define ferror(p)	(((*p)->_flag&_IOERR)!=0)
#define fileno(p)	((*p)->_file)
#define clearerr(p)	((*p)->_flag &= ~(_IOERR|_IOEOF))
/*
 *	Declare stdio routines
 */
extern	int    fclose(FILE*);
extern	FILE*  fdopen(int, const char*);
extern	int    fflush(FILE*);
extern	int    fgetc(FILE*);
extern	char*  fgets(char*, int, FILE *);
extern	FILE*  fopen(const char*, const char*);
extern	int    fputc(int, FILE*);
extern	int    fputs(const char*, FILE*);
extern	size_t fread(void*, size_t, size_t, FILE*);
extern	FILE*  freopen(const char*, const char*, FILE*, ...);
extern	int    fscanf(FILE *, const char *, ...);
extern	int    fseek(FILE*, long, int);
extern	long   ftell(FILE *);
extern	size_t fwrite(const void*, size_t, size_t, FILE*);
extern	char*  gets(char*);
extern	int    getw(FILE*);
extern	int    pclose(FILE*);
extern	void   perror(const char*);
extern	FILE*  popen(const char*, const char*);
extern	int    printf(const char*, ...);
extern	int    puts(const char*);
extern	int    putw(int, FILE*);
extern	int    rewind(FILE*);
extern	int    scanf(const char *, ...);
extern	void   setbuf(FILE*, char*);
extern	void   setbuffer(FILE*, char*, int);
extern	int    setlinebuf(FILE*);
extern	int    setvbuf(FILE*, char*, int, size_t);
extern	int    sscanf(const char *, const char *, ...);
extern	FILE*  tmpfile();
extern	int    ungetc(int, FILE*);

extern	int    fprintf(FILE*, const char*, ...);
extern	int    sprintf(char *, const char*, ...);


#ifdef __cplusplus
}
#endif

#endif	__STDIO_DEFINED
