/* java-chartables.h -- Character tables for java.lang.Character -*- c++ -*-
   Copyright (C) 2002 Free Software Foundation, Inc.
   *** This file is generated by scripts/MakeCharTables.java ***

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#ifndef __JAVA_CHARTABLES_H__
#define __JAVA_CHARTABLES_H__

// These tables are automatically generated by scripts/MakeCharTables.java.
// This is in turn parsing gnu.java.lang.CharData, which is generated by
// scripts/unicode-muncher.pl.  The Unicode data comes from
// www.unicode.org; this header is based on
// gnu/gcj/convert/UnicodeData-3.0.0.txt. JDK 1.4 uses Unicode version 3.0.0.
// DO NOT EDIT the tables.  Instead, fix the upstream scripts and run
// them again.

// The data is stored in C style arrays of the appropriate CNI types, to
// guarantee that the data is constant and non-relocatable.  The field
// <code>blocks</code> stores the offset of a block of 2<supSHIFT</sup>
// characters within <code>data</code>. The data field, in turn, stores
// information about each character in the low order bits, and an offset
// into the attribute tables <code>upper</code>, <code>lower</code>,
// <code>numValue</code>, and <code>direction</code>.  Notice that the
// attribute tables are much smaller than 0xffff entries; as many characters
// in Unicode share common attributes.  Finally, there is a listing for
// <code>title</code> exceptions (most characters just have the same title
// case as upper case).

// This file should only be included by natCharacter.cc

/**
 * The character shift amount to look up the block offset. In other words,
 * <code>(char) (blocks[ch >> SHIFT] + ch)</code> is the index where
 * <code>ch</code> is described in <code>data</code>.
 */
#define SHIFT 5

/**
 * The mapping of character blocks to their location in <code>data</code>.
 * Each entry has been adjusted so that a modulo 16 sum with the desired
 * character gives the actual index into <code>data</code>.
 */
static const jchar blocks[] = {
    450, 450, 449, 300, 299, 416, 504, 638, 513, 656,
    439, 713, 343, 681, 575, 440, 257, 599, 761, 761,
    880, 867, 65167, 830, 65413, 65381, 64949, 64929, 65469, 702,
    65470, 65513, 65192, 65326, 559, 65185, 65437, 65121, 65449, 64288,
    195, 269, 254, 64353, 64346, 261, 259, 248, 65163, 547,
    600, 449, 502, 470, 65249, 547, 64938, 64341, 355, 65123,
    246, 253, 65027, 64995, 64963, 64931, 64899, 64867, 64835, 64803,
    64771, 64739, 95, 74, 165, 307, 65032, 93, 335, 418,
    63081, 291, 290, 63681, 65104, 258, 257, 64067, 64648, 65191,
    192, 64673, 64399, 62589, 153, 64273, 65050, 64802, 64297, 53,
    62393, 65105, 64712, 65461, 62265, 64146, 65413, 65333, 64078, 63334,
    65317, 64209, 64355, 64564, 65247, 63331, 64682, 64130, 64953, 63203,
    65087, 64705, 65097, 63467, 63247, 62184, 64921, 62947, 63844, 64508,
    64913, 62819, 62787, 62524, 62518, 61291, 63588, 63556, 64594, 63492,
    63460, 64521, 63396, 61084, 64394, 63300, 63476, 63236, 63428, 63372,
    62571, 62668, 63276, 63044, 62459, 63047, 62019, 62916, 62884, 60577,
    62819, 62788, 62756, 62724, 62692, 62660, 62628, 62596, 62564, 62532,
    62500, 62468, 62436, 62404, 62372, 62340, 62308, 62276, 62244, 62083,
    63345, 62148, 62116, 63281, 61123, 61091, 61059, 61027, 61924, 62620,
    62783, 60745, 62161, 61764, 59629, 59422, 61668, 62865, 60675, 60643,
    60611, 60579, 60547, 60515, 60483, 60451, 60419, 60387, 60355, 60323,
    60291, 60259, 60227, 60195, 60163, 60131, 60099, 60067, 60035, 60003,
    59971, 59939, 59907, 59875, 59843, 59811, 59779, 59747, 59715, 59683,
    59651, 59619, 59587, 59555, 59523, 59491, 59459, 59427, 59395, 59363,
    58625, 58593, 58561, 58529, 61393, 58465, 58433, 58407, 61313, 61265,
    61265, 61265, 61265, 61249, 57773, 61248, 61248, 61248, 57824, 58239,
    61184, 59859, 60389, 58591, 61134, 61279, 58512, 61247, 61155, 61302,
    61038, 61290, 61303, 61298, 61067, 61389, 61047, 60959, 60961, 61279,
    61399, 61072, 61389, 61403, 61283, 57891, 57859, 57827, 60709, 60727,
    60691, 61206, 61186, 60737, 60727, 60717, 60453, 60421, 60389, 60357,
    60360, 60022, 60259, 60262, 59824, 60165, 60133, 59875, 57155, 57123,
    57091, 57059, 59658, 59933, 60242, 60233, 60223, 60127, 56835, 56803,
    59685, 59653, 59621, 59589, 59557, 59525, 59493, 59461, 56515, 56483,
    56451, 56419, 56387, 56355, 56323, 56291, 56259, 56227, 56195, 56163,
    56131, 56099, 56067, 56035, 56003, 55971, 55939, 55907, 55875, 55843,
    55811, 55779, 55747, 55715, 55683, 55651, 55619, 55587, 55555, 55523,
    55491, 55459, 55427, 55395, 55363, 55331, 55299, 55267, 55235, 55203,
    55171, 55139, 58027, 57989, 57957, 57962, 57893, 57861, 57829, 57797,
    57765, 57733, 57736, 56713, 58274, 57293, 55587, 55556, 58178, 55491,
    55460, 56529, 56492, 54907, 55332, 55300, 57954, 52958, 54275, 54243,
    57616, 57571, 57797, 57521, 57521, 57688, 57105, 57390, 57357, 57325,
    57293, 56934, 57229, 57197, 57167, 57134, 54628, 54596, 54564, 54532,
    54500, 54468, 54436, 54404, 54372, 54340, 54308, 54276, 54244, 54212,
    54180, 54148, 54116, 54084, 54052, 54020, 53988, 53956, 53924, 53892,
    53860, 53828, 53796, 53764, 53732, 53700, 53668, 53636, 53604, 53572,
    53540, 53508, 53476, 53444, 53412, 53380, 53348, 53316, 53284, 53252,
    53220, 53188, 53156, 53124, 53092, 53060, 53028, 52996, 52964, 52932,
    52900, 52868, 52836, 52804, 52772, 52740, 52708, 52676, 52644, 52612,
    52580, 52548, 52516, 52484, 52452, 52420, 52388, 52356, 52324, 52292,
    52260, 52228, 52196, 52164, 52132, 52100, 52068, 52036, 52004, 51972,
    51940, 51908, 51876, 51844, 51812, 51780, 51748, 51716, 51684, 51652,
    51620, 51588, 51556, 51524, 51492, 51460, 51428, 51396, 51364, 51332,
    51300, 51268, 51236, 51204, 51172, 51140, 51108, 51076, 51044, 51012,
    50980, 50948, 50916, 50884, 50852, 50820, 50788, 50756, 50724, 50692,
    50660, 50628, 50596, 50564, 50532, 50500, 50468, 50436, 50404, 50372,
    50340, 50308, 50276, 50244, 50212, 50180, 50148, 50116, 50084, 50052,
    50020, 49988, 49956, 49924, 49892, 49860, 49828, 49796, 49764, 49732,
    49700, 49668, 49636, 49604, 49572, 49540, 49508, 49476, 49444, 49412,
    49380, 49348, 49316, 49284, 49252, 49220, 49188, 49156, 49124, 49092,
    49060, 49028, 48996, 48964, 48932, 48900, 48868, 48836, 48804, 48772,
    48740, 48708, 48676, 48644, 48612, 48580, 48548, 48516, 48484, 48452,
    48420, 48388, 48356, 48324, 48292, 48260, 48228, 48196, 48164, 48132,
    48100, 45792, 47107, 47075, 47972, 47940, 47908, 47876, 47844, 47812,
    47780, 47748, 47716, 47684, 47652, 47620, 47588, 47556, 47524, 47492,
    47460, 47428, 47396, 47364, 47332, 47300, 47268, 47236, 47204, 47172,
    47140, 47108, 47076, 47044, 47012, 46980, 46948, 46916, 46884, 46852,
    46820, 46788, 46756, 46724, 46692, 46660, 46628, 46596, 46564, 46532,
    46500, 46468, 46436, 46404, 46372, 46340, 46308, 46276, 46244, 46212,
    46180, 46148, 46116, 46084, 46052, 46020, 45988, 45956, 45924, 45892,
    45860, 45828, 45796, 45764, 45732, 45700, 45668, 45636, 45604, 45572,
    45540, 45508, 45476, 45444, 45412, 45380, 45348, 45316, 45284, 45252,
    45220, 45188, 45156, 45124, 45092, 45060, 45028, 44996, 44964, 44932,
    44900, 44868, 44836, 44804, 44772, 44740, 44708, 44676, 44644, 44612,
    44580, 44548, 44516, 44484, 44452, 44420, 44388, 44356, 44324, 44292,
    44260, 44228, 44196, 44164, 44132, 44100, 44068, 44036, 44004, 43972,
    43940, 43908, 43876, 43844, 43812, 43780, 43748, 43716, 43684, 43652,
    43620, 43588, 43556, 43524, 43492, 43460, 43428, 43396, 43364, 43332,
    43300, 43268, 43236, 43204, 43172, 43140, 43108, 43076, 43044, 43012,
    42980, 42948, 42916, 42884, 42852, 42820, 42788, 42756, 42724, 42692,
    42660, 42628, 42596, 42564, 42532, 42500, 42468, 42436, 42404, 42372,
    42340, 42308, 42276, 42244, 42212, 42180, 42148, 42116, 42084, 42052,
    42020, 41988, 41956, 41924, 41892, 41860, 41828, 41796, 41764, 41732,
    41700, 41668, 41636, 41604, 41572, 41540, 41508, 41476, 41444, 41412,
    41380, 41348, 41316, 41284, 41252, 41220, 41188, 41156, 41124, 41092,
    41060, 41028, 40996, 40964, 40932, 40900, 40868, 40836, 40804, 40772,
    40740, 40708, 40676, 40644, 40612, 40580, 40548, 40516, 40484, 40452,
    40420, 40388, 40356, 40324, 40292, 40260, 40228, 40196, 40164, 40132,
    40100, 40068, 40036, 40004, 39972, 39940, 39908, 39876, 39844, 39812,
    39780, 39748, 39716, 39684, 39652, 39620, 39588, 39556, 39524, 39492,
    39460, 39428, 39396, 39364, 39332, 39300, 39268, 39236, 39204, 39172,
    39140, 39108, 39076, 39044, 39012, 38980, 38948, 38916, 38884, 38852,
    38820, 38788, 38756, 38724, 38692, 38660, 38628, 38596, 38564, 38532,
    38500, 38468, 38436, 38404, 38372, 38340, 38308, 38276, 38244, 38212,
    38180, 38148, 38116, 38084, 38052, 38020, 37988, 37956, 37924, 37892,
    37860, 37828, 37796, 37764, 37732, 37700, 37668, 37636, 37604, 37572,
    37540, 37508, 37476, 37444, 37412, 37380, 37348, 37316, 37284, 37252,
    37220, 37188, 37156, 37124, 37092, 37060, 37028, 36996, 36964, 36932,
    36900, 36868, 36836, 36804, 36772, 36740, 36708, 36676, 36644, 36612,
    36580, 36548, 36516, 36484, 36452, 36420, 36388, 36356, 36324, 36292,
    36260, 36228, 36196, 36164, 36132, 36100, 36068, 36036, 36004, 35972,
    35940, 35908, 35876, 35844, 35812, 35780, 35748, 35716, 35684, 35652,
    35620, 35588, 35556, 35524, 35492, 35460, 35428, 35396, 35364, 35332,
    35300, 35268, 35236, 35204, 35172, 35140, 35108, 35076, 35044, 35012,
    34980, 34948, 34916, 34884, 34852, 34820, 34788, 34756, 34724, 34692,
    34660, 34628, 34596, 34564, 34532, 34500, 34468, 34436, 34404, 34372,
    34340, 34308, 34276, 34244, 34212, 34180, 34148, 34116, 34084, 34052,
    34020, 33988, 33956, 33924, 33892, 33860, 33828, 33796, 33764, 33732,
    33700, 33668, 33636, 33604, 33572, 33540, 33508, 33476, 33444, 33412,
    33380, 33348, 33316, 33284, 33252, 33220, 33188, 33156, 33124, 33092,
    33060, 33028, 32996, 32964, 32932, 32900, 32868, 32836, 32804, 32772,
    32740, 32708, 32676, 32644, 32612, 32580, 32548, 32516, 32484, 32452,
    32420, 32388, 32356, 32324, 32292, 32260, 32228, 32196, 32164, 32132,
    32100, 32068, 32036, 32004, 31972, 31940, 31908, 31876, 31844, 31812,
    31780, 31748, 31716, 31684, 31652, 31620, 31588, 31556, 31524, 31492,
    31460, 31428, 31396, 31364, 31332, 31300, 31268, 31236, 31204, 31172,
    31140, 31108, 31076, 31044, 31012, 30980, 30948, 30916, 30884, 30852,
    30820, 30788, 30756, 30724, 30692, 30660, 30628, 30596, 30564, 30532,
    30500, 30468, 30436, 30404, 30372, 30340, 30308, 30276, 30244, 30212,
    30180, 30148, 30116, 30084, 30052, 30020, 29988, 29956, 29924, 29892,
    29860, 29828, 29796, 29764, 29732, 29700, 29668, 29636, 29604, 29572,
    29540, 29508, 29476, 29444, 29412, 29380, 29348, 29316, 29284, 29252,
    29220, 29188, 29156, 29124, 29092, 29060, 29028, 28996, 28964, 28932,
    28900, 28868, 28836, 28804, 28772, 28740, 28708, 28676, 28644, 28612,
    28580, 28548, 28516, 28484, 28452, 28420, 28388, 28356, 28324, 28292,
    28260, 28228, 28196, 28164, 28132, 28100, 28068, 28036, 28004, 27972,
    27940, 27908, 27876, 27844, 27812, 27780, 27748, 27716, 27684, 27652,
    27620, 27588, 27556, 27524, 27492, 27460, 27428, 27396, 27364, 27332,
    27300, 27268, 27236, 27204, 27172, 27140, 27108, 24816, 26115, 26083,
    26980, 26948, 26916, 26884, 26852, 26820, 26788, 26756, 26724, 26692,
    26660, 26628, 26596, 26564, 26532, 26500, 26468, 26436, 26404, 26372,
    26340, 26308, 26276, 26244, 26212, 26180, 26148, 26116, 26084, 26052,
    26020, 25988, 25956, 25924, 25892, 25860, 27424, 28123, 28310, 24803,
    24771, 24739, 24707, 24675, 24643, 24611, 24579, 24547, 24515, 24483,
    24451, 24419, 24387, 24355, 24323, 24291, 24259, 24227, 24195, 24163,
    24131, 24099, 24067, 24035, 24003, 23971, 23939, 23907, 23875, 23843,
    23811, 23779, 23747, 23715, 23683, 23651, 23619, 23587, 23555, 23523,
    23491, 23459, 23427, 23395, 23363, 23331, 23299, 23267, 23235, 23203,
    23171, 23139, 23107, 23075, 23043, 23011, 23908, 23876, 23844, 23812,
    23780, 23748, 23716, 23684, 23652, 23620, 23588, 23556, 23524, 23492,
    23460, 23428, 23396, 23364, 23332, 23300, 23268, 23236, 23204, 23172,
    23140, 23108, 23076, 23044, 23012, 22980, 22948, 22916, 22884, 22852,
    22820, 22788, 22756, 22724, 22692, 22660, 22628, 22596, 22564, 22532,
    22500, 22468, 22436, 22404, 22372, 22340, 22308, 22276, 22244, 22212,
    22180, 22148, 22116, 22084, 22052, 22020, 21988, 21956, 21924, 21892,
    21860, 21828, 21796, 21764, 21732, 21700, 21668, 21636, 21604, 21572,
    21540, 21508, 21476, 21444, 21412, 21380, 21348, 21316, 21284, 21252,
    21220, 21188, 21156, 21124, 21092, 21060, 21028, 20996, 20964, 20932,
    20900, 20868, 20836, 20804, 20772, 20740, 20708, 20676, 20644, 20612,
    20580, 20548, 20516, 20484, 20452, 20420, 20388, 20356, 20324, 20292,
    20260, 20228, 20196, 20164, 20132, 20100, 20068, 20036, 20004, 19972,
    19940, 19908, 19876, 19844, 19812, 19780, 19748, 19716, 19684, 19652,
    19620, 19588, 19556, 19524, 19492, 19460, 19428, 19396, 19364, 19332,
    19300, 19268, 19236, 19204, 19172, 19140, 19108, 19076, 19044, 19012,
    18980, 18948, 18916, 18884, 18852, 18820, 18788, 18756, 18724, 18692,
    18660, 18628, 18596, 18564, 18532, 18500, 18468, 18436, 18404, 18372,
    18340, 18308, 18276, 18244, 18212, 18180, 18148, 18116, 18084, 18052,
    18020, 17988, 17956, 17924, 17892, 17860, 17828, 17796, 17764, 17732,
    17700, 17668, 17636, 17604, 17572, 17540, 17508, 17476, 17444, 17412,
    17380, 17348, 17316, 17284, 17252, 17220, 17188, 17156, 17124, 17092,
    17060, 17028, 16996, 16964, 16932, 16900, 16868, 16836, 16804, 16772,
    16740, 16708, 16676, 16644, 16612, 16580, 16548, 16516, 16484, 16452,
    16420, 16388, 16356, 16324, 16292, 16260, 16228, 16196, 16164, 16132,
    16100, 16068, 16036, 16004, 15972, 15940, 15908, 15876, 15844, 15812,
    15780, 15748, 15716, 15684, 15652, 15620, 15588, 15556, 15524, 15492,
    15460, 15428, 15396, 15364, 15332, 15300, 15268, 15236, 15204, 15172,
    15140, 15108, 15076, 15044, 15012, 14980, 14948, 14916, 14884, 14852,
    14820, 14788, 14756, 14724, 14692, 14660, 14628, 14596, 14564, 14532,
    14500, 14468, 14436, 14404, 14372, 14340, 14308, 14276, 14244, 14212,
    14180, 14148, 14116, 14084, 14052, 14020, 13988, 13956, 13924, 13892,
    13860, 13828, 13796, 13764, 13732, 13700, 13668, 13636, 13604, 13572,
    13540, 13508, 13476, 13444, 13412, 13380, 13348, 13316, 13284, 13252,
    13220, 13188, 13156, 13124, 13092, 13060, 13028, 12996, 12964, 12932,
    12900, 12868, 12836, 12804, 12772, 10482, 11779, 11747, 15397, 15365,
    15333, 15301, 15269, 15237, 15205, 15173, 15141, 15109, 15077, 15045,
    15013, 14981, 14949, 14917, 14885, 14853, 14821, 14789, 14757, 14725,
    14693, 14661, 14629, 14597, 14565, 14533, 14501, 14469, 14437, 14405,
    14373, 14341, 14309, 14277, 14245, 14213, 14181, 14149, 14117, 14085,
    14053, 14021, 13989, 13957, 13925, 13893, 13861, 13829, 13797, 13765,
    13733, 13701, 13669, 13637, 13605, 13573, 13541, 13509, 13477, 13445,
    13413, 13381, 13381, 13349, 13317, 13285, 13253, 13221, 13189, 13157,
    13125, 13093, 13061, 13029, 12997, 12965, 12933, 12901, 12869, 12837,
    12805, 12773, 12741, 12709, 12677, 12645, 12613, 12581, 12549, 12517,
    12485, 12453, 12421, 12389, 12357, 12325, 12293, 12261, 12229, 12197,
    12165, 12133, 12101, 12069, 12037, 12005, 11973, 11941, 11909, 11877,
    11845, 11813, 11781, 11749, 11717, 11685, 11653, 11621, 11589, 11557,
    11525, 11493, 11461, 11429, 11397, 11365, 11333, 11301, 11269, 11237,
    11205, 11173, 11141, 11109, 11077, 11045, 11013, 10981, 10949, 10917,
    10885, 10853, 10821, 10789, 10757, 10725, 10693, 10661, 10629, 10597,
    10565, 10533, 10501, 10469, 10437, 10405, 10373, 10341, 10309, 10277,
    10245, 10213, 10181, 10149, 10117, 10085, 10053, 10021, 9989, 9957,
    9925, 9893, 9861, 9829, 9797, 9765, 9733, 9701, 9669, 9637,
    9605, 9573, 9541, 9509, 9477, 9445, 9413, 9381, 9349, 9317,
    9285, 9253, 9221, 9189, 9157, 9125, 9093, 9061, 9029, 8997,
    8965, 8933, 8901, 8869, 8837, 8805, 8773, 8741, 8709, 8677,
    8645, 8613, 8581, 8549, 8517, 8485, 8453, 8421, 8389, 8357,
    8325, 8293, 8261, 8229, 8197, 8165, 8133, 8101, 8069, 8037,
    8005, 7973, 7941, 7909, 7877, 7845, 7813, 7781, 7749, 7717,
    7685, 7653, 7621, 7589, 7557, 7525, 7493, 7461, 7429, 7397,
    7365, 7333, 7301, 7269, 7237, 7205, 7173, 7141, 7109, 7077,
    7045, 7013, 4196, 4164, 4132, 4100, 4068, 4036, 4004, 3972,
    3940, 1640, 2947, 2915, 2883, 2851, 2819, 2787, 2674, 6469,
    2641, 3350, 3318, 3244, 3235, 3222, 3190, 3158, 3126, 3094,
    3062, 3030, 2998, 2966, 2934, 2904, 2854, 2838, 2738, 2774,
    2710, 706, 1987, 5733, 5729, 1023, 2550, 2518, 2486, 1500,
    2994, 5537, 4032, 448, 433, 2501, 2086, 4735,
  };
/** Length of blocks. */
static const int blocks_length = 2048;

/**
 * Information about each character.  The low order 5 bits form the
 * character type, the next bit is a flag for non-breaking spaces, and the
 * next bit is a flag for mirrored directionality.  The high order 9 bits
 * form the offset into the attribute tables.  Note that this limits the
 * number of unique character attributes to 512, which is not a problem
 * as of Unicode version 3.2.0, but may soon become one.
 */
static const jchar data[] = {
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290,
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290,
    12161, 12290, 15872, 15872, 12161, 12290, 15872, 15872, 15872, 15872,
    15872, 15872, 14853, 14853, 15872, 15872, 15872, 14853, 14853, 14853,
    15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 15872, 14853, 14853, 14853, 15872, 15872, 15872, 15872, 23176,
    23176, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    15872, 15872, 20632, 15872, 15872, 15872, 15872, 17798, 15872, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 15872, 15872,
    14853, 14853, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    15872, 15872, 15872, 15872, 20738, 20738, 20738, 20738, 20738, 20738,
    20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738,
    20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738, 20738,
    20738, 20738, 20738, 20738, 20738, 10498, 15872, 20632, 10772, 15872,
    15872, 15872, 15872, 15872, 15872, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17926, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 6683, 6683, 15872,
    15872, 15872, 15872, 17668, 15872, 15872, 15872, 664, 15872, 664,
    25877, 26006, 664, 6807, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 17668, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 17668, 17668, 6683, 6683, 6683,
    6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683,
    6683, 17668, 17668, 6683, 6683, 6683, 6683, 6683, 6683, 6683,
    6683, 6683, 6683, 6683, 6683, 6683, 6683, 10498, 28930, 10498,
    15872, 10498, 10498, 29441, 29441, 29441, 29441, 29187, 6683, 6683,
    6683, 27778, 27778, 10498, 10498, 15872, 15872, 10498, 10498, 27905,
    27905, 29569, 29569, 15872, 6683, 6683, 6683, 6914, 7042, 7170,
    7298, 7426, 7554, 7682, 7810, 7938, 8066, 8194, 8322, 8450,
    8578, 8706, 8834, 8962, 9090, 9218, 9346, 9474, 9602, 9730,
    9858, 9986, 10114, 1109, 3225, 1238, 3225, 15, 15, 15,
    15, 15, 271, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 143,
    271, 143, 399, 271, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 271, 271,
    271, 143, 524, 664, 664, 792, 922, 792, 664, 664,
    1109, 1238, 664, 1305, 1432, 1556, 1432, 1688, 1801, 1929,
    2057, 2185, 2313, 2441, 2569, 2697, 2825, 2953, 1432, 664,
    3161, 3225, 3161, 664, 3329, 3457, 3585, 3713, 3841, 3969,
    4097, 4225, 4353, 4481, 4609, 4737, 4865, 4993, 5121, 5249,
    5377, 5505, 5633, 5761, 5889, 6017, 6145, 6273, 6401, 6529,
    1109, 664, 1238, 6683, 6807, 664, 664, 664, 3225, 1109,
    1238, 15872, 664, 664, 664, 664, 664, 664, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 10284, 664, 922, 922,
    922, 922, 10396, 10396, 6683, 10396, 10498, 10717, 3225, 10772,
    10396, 6683, 10908, 1305, 11019, 11147, 6683, 11266, 10396, 664,
    6683, 11403, 10498, 11614, 11659, 11659, 11659, 664, 664, 1305,
    1556, 3225, 3225, 3225, 15872, 664, 922, 792, 664, 15872,
    15872, 15872, 15872, 21253, 21253, 21253, 15872, 21253, 15872, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 15872, 15872, 15872, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 15872, 20252, 20252,
    20097, 20097, 20097, 20097, 20097, 20097, 20097, 20097, 20097, 20097,
    20097, 20097, 20097, 20097, 20097, 20097, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 3225,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 10498, 12929, 12161,
    12290, 12161, 12290, 13057, 12161, 12290, 13185, 13185, 12161, 12290,
    10498, 13313, 13441, 13569, 12161, 12290, 13185, 13697, 13826, 13953,
    14081, 12161, 12290, 10498, 10498, 13953, 14209, 10498, 14337, 12290,
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 10498, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 15872, 15872, 15872, 15872, 15872, 15872, 23305, 23433, 23561,
    23689, 23817, 23945, 24073, 24201, 24329, 24457, 17798, 17798, 14853,
    14853, 14853, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 6683, 6683, 18049, 664, 18177, 18177, 18177,
    15872, 18305, 15872, 18433, 18433, 10498, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777,
    11777, 11777, 11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906,
    11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906,
    11906, 11906, 11906, 11906, 11906, 3225, 11906, 11906, 11906, 11906,
    11906, 11906, 11906, 12034, 11906, 11906, 18818, 11906, 11906, 11906,
    11906, 11906, 11906, 11906, 11906, 11906, 18946, 19074, 19074, 15872,
    19202, 19330, 19457, 19457, 19457, 19586, 19714, 10498, 15872, 15872,
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290,
    12161, 12290, 12161, 12290, 12161, 12290, 10498, 15105, 15235, 15362,
    12161, 12290, 15617, 15745, 12161, 12290, 12161, 12290, 12161, 12290,
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290,
    12417, 12546, 12161, 12290, 12161, 12290, 12161, 12290, 10498, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 19842, 19970, 15490, 10498, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 23056, 23056, 23056, 23056, 23056, 23056, 32139, 15872, 15872,
    15872, 32267, 32395, 32523, 32651, 32779, 32907, 1305, 1305, 3225,
    1109, 1238, 10498, 14853, 14853, 14853, 14853, 15105, 15235, 15362,
    15105, 15235, 15362, 15105, 15235, 15362, 12161, 12290, 12161, 12290,
    12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290,
    12161, 12290, 15490, 12161, 12290, 20252, 17798, 17798, 17798, 17798,
    15872, 20359, 20359, 15872, 15872, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12673,
    12161, 12290, 12161, 12290, 12161, 12290, 12802, 12161, 12290, 12161,
    12290, 12161, 12290, 14465, 12161, 12290, 14465, 10498, 10498, 12161,
    12290, 14465, 12161, 12290, 14593, 14593, 12161, 12290, 12161, 12290,
    14721, 12161, 12290, 10498, 14853, 12161, 12290, 10498, 14978, 19457,
    12161, 12290, 12161, 12290, 15872, 15872, 12161, 12290, 15872, 15872,
    12161, 12290, 15872, 15872, 15872, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 1432, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    21144, 15872, 15872, 15872, 21144, 21144, 21144, 21144, 21144, 21144,
    21144, 21144, 21144, 21144, 21144, 21144, 21144, 21144, 15872, 23056,
    21253, 17798, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 15872, 15872, 23056, 19457, 19457, 19457, 19457, 19457, 19457,
    19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457,
    19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457, 19457,
    19457, 19457, 19457, 19457, 19457, 19457, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 15872, 14853, 15872, 15872, 15872, 15872,
    15872, 23305, 23433, 23561, 23689, 23817, 23945, 24073, 24201, 24329,
    24457, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 10498, 10498, 10498, 16002, 16130, 10498, 16258,
    16258, 10498, 16386, 10498, 16514, 10498, 10498, 10498, 10498, 16258,
    10498, 10498, 16642, 10498, 10498, 10498, 10498, 16770, 16898, 10498,
    10498, 10498, 10498, 10498, 16898, 10498, 10498, 17026, 10498, 10498,
    17154, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498,
    10498, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 10498, 10498, 10498, 10498, 10498, 15872, 15872,
    15872, 15872, 15872, 20997, 17798, 20997, 20997, 15872, 20997, 20997,
    15872, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997,
    20997, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21144, 21253, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    20359, 20359, 17798, 20359, 20359, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 11659, 11659, 11659,
    11659, 11659, 11659, 11659, 11659, 11659, 11659, 11659, 11659, 33419,
    17282, 10498, 10498, 17282, 10498, 10498, 10498, 10498, 17282, 10498,
    17410, 17410, 10498, 10498, 10498, 10498, 10498, 10498, 17538, 10498,
    10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498,
    10498, 10498, 10498, 15872, 15872, 17668, 17668, 17668, 17668, 17668,
    17668, 17668, 17668, 17668, 6683, 6683, 17668, 17668, 17668, 17668,
    17668, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683,
    17668, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 20481, 20481,
    20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481,
    20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481, 20481,
    20481, 15872, 15872, 17668, 20632, 20632, 20632, 20632, 20632, 20632,
    11777, 11777, 15872, 11777, 11777, 11777, 11777, 11777, 11777, 11777,
    11777, 11777, 18562, 18690, 18690, 18690, 10498, 11906, 11906, 11906,
    11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906, 11906,
    11906, 11906, 11906, 19970, 19970, 19970, 19970, 19970, 19970, 19970,
    19970, 19970, 19970, 19970, 19970, 19970, 19970, 19970, 19970, 17798,
    17798, 17798, 17798, 17798, 20632, 17798, 17798, 14853, 14853, 14853,
    14853, 15872, 15872, 15872, 15872, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 15872, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 15872, 17798, 17798,
    17798, 20888, 17798, 17798, 20888, 17798, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 20997, 20997, 20997,
    20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997,
    20997, 20997, 20997, 15872, 15872, 15872, 15872, 15872, 20997, 20997,
    20997, 20888, 20888, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 23433, 23561, 23689, 23817, 23945, 24073,
    24201, 24329, 24457, 25355, 25483, 25611, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 17798,
    23176, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    15872, 14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 15872,
    15872, 15872, 14853, 14853, 15872, 14853, 15872, 14853, 14853, 14853,
    14853, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    15872, 15872, 15872, 15872, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 23176, 23176,
    23176, 23176, 15872, 17798, 17798, 17798, 15872, 17798, 17798, 17798,
    17798, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 17798, 17798,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 17798,
    23176, 23176, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 15872, 15872, 14853, 14853, 15872, 15872, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 15872, 15872,
    23176, 23176, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 14853, 14853,
    14853, 15872, 15872, 15872, 15872, 23305, 23433, 23561, 23689, 23817,
    23945, 24073, 24201, 24329, 24457, 20252, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 21513, 21641, 21769, 21897, 22025, 22153, 22281, 22409, 22537,
    22665, 792, 22808, 22808, 21144, 15872, 15872, 17798, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 15872, 15872, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 25877, 26006,
    21380, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 23176, 23176, 20632, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 17798, 17798, 23176,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 14853,
    15872, 14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 20632, 20632,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 17798, 17798, 17798,
    17798, 17798, 21380, 21380, 17798, 17798, 10396, 17798, 17798, 17798,
    17798, 15872, 15872, 1801, 1929, 2057, 2185, 2313, 2441, 2569,
    2697, 2825, 2953, 21253, 21253, 21253, 22940, 22940, 15872, 14853,
    14853, 14853, 15872, 14853, 15872, 14853, 15872, 15872, 14853, 14853,
    15872, 14853, 14853, 14853, 14853, 17798, 14853, 14853, 17798, 17798,
    17798, 17798, 17798, 17798, 15872, 17798, 17798, 14853, 15872, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 15872, 15872,
    17798, 17798, 23176, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 17798, 14853,
    23176, 23176, 23176, 23176, 23176, 15872, 17798, 23176, 23176, 15872,
    23176, 23176, 17798, 17798, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 23176, 23176, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    14853, 15872, 20632, 20632, 20632, 20632, 20632, 20632, 20632, 20632,
    23433, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 25355,
    26123, 26251, 26379, 26507, 26635, 26763, 26891, 27019, 25483, 27147,
    15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 15872, 15872, 14853, 14853, 14853, 14853, 15872,
    15872, 17798, 14853, 23176, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 23176, 23176, 23176, 23176, 17798, 15872, 15872, 14853,
    17798, 17798, 17798, 17798, 15872, 15872, 15872, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 15872, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 15872, 14853, 15872, 15872, 15872, 14853,
    14853, 14853, 14853, 15872, 15872, 17798, 15872, 23176, 23176, 23176,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872,
    14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872,
    14853, 15872, 14853, 14853, 14853, 14853, 15872, 15872, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 15872, 14853, 15872, 14853, 14853,
    14853, 14853, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 17798, 14853, 14853, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 15872, 15872, 15872, 15872, 922, 922, 922, 922, 922,
    922, 922, 922, 922, 922, 922, 922, 922, 922, 922,
    922, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 14853, 14853, 17798,
    17798, 20632, 20632, 23305, 23433, 23561, 23689, 23817, 23945, 24073,
    24201, 24329, 24457, 20632, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 664,
    664, 792, 922, 792, 664, 664, 25877, 26006, 664, 1305,
    1432, 1556, 1432, 1688, 1801, 1929, 2057, 2185, 2313, 2441,
    2569, 2697, 2825, 2953, 1432, 664, 3225, 3225, 3225, 664,
    664, 664, 664, 664, 664, 10772, 664, 664, 664, 664,
    23056, 23056, 23056, 23056, 15872, 23305, 23433, 23561, 23689, 23817,
    23945, 24073, 24201, 24329, 24457, 15872, 15872, 15872, 15872, 15872,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 15872, 14853, 14853, 14853, 14853, 14853, 15872, 15872, 15872,
    15872, 23176, 17798, 17798, 17798, 17798, 15872, 15872, 23176, 23176,
    15872, 15872, 23176, 23176, 17798, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 23176, 15872, 15872, 15872, 15872, 14853,
    14853, 15872, 14853, 15872, 15872, 14853, 14853, 15872, 14853, 15872,
    15872, 14853, 15872, 15872, 15872, 15872, 15872, 15872, 14853, 14853,
    14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 14853, 14853, 15872, 14853, 14853, 15872, 14853, 14853, 15872,
    15872, 17798, 15872, 23176, 23176, 17798, 17798, 15872, 15872, 15872,
    15872, 17798, 17798, 15872, 15872, 17798, 17798, 17798, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 14853,
    14853, 14853, 14853, 15872, 14853, 15872, 14853, 14853, 17798, 17798,
    15872, 15872, 23305, 23433, 23561, 23689, 23817, 23945, 24073, 24201,
    24329, 24457, 14853, 14853, 922, 922, 24587, 24715, 24843, 24971,
    25099, 25227, 20252, 15872, 15872, 15872, 15872, 15872, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 15872, 14853, 14853, 15872, 14853,
    14853, 14853, 14853, 14853, 15872, 15872, 17798, 14853, 23176, 23176,
    17798, 17798, 17798, 17798, 17798, 15872, 17798, 17798, 23176, 15872,
    23176, 23176, 17798, 15872, 15872, 14853, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 23305, 23433, 23561, 23689, 23817, 23945, 24073, 24201, 24329,
    24457, 25099, 25099, 25099, 25099, 25099, 25099, 25099, 25099, 25099,
    25099, 20252, 17798, 20252, 17798, 20252, 17798, 25877, 26006, 25877,
    26006, 23176, 23176, 17798, 17798, 17798, 15872, 15872, 15872, 23176,
    23176, 15872, 15872, 23176, 23176, 17798, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 17798, 23176, 15872, 15872, 15872, 15872,
    14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 15872, 14853,
    14853, 15872, 23176, 17798, 17798, 17798, 17798, 23176, 17798, 15872,
    15872, 15872, 17798, 17798, 23176, 17798, 15872, 15872, 15872, 15872,
    15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 23176, 23176, 23176, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 23176, 23176, 15872, 15872, 15872, 23176, 23176, 23176,
    15872, 23176, 23176, 23176, 17798, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 23176, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 15872, 17668,
    15872, 17798, 17798, 17798, 17798, 17798, 17798, 15872, 15872, 23305,
    23433, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 15872,
    15872, 14853, 14853, 15872, 15872, 15872, 15872, 23305, 23433, 23561,
    23689, 23817, 23945, 24073, 24201, 24329, 24457, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 17798, 17798, 17798, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 20359, 20359, 20359, 23176,
    17798, 17798, 17798, 15872, 15872, 23176, 23176, 23176, 15872, 23176,
    23176, 23176, 17798, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 23176, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872, 15872,
    15872, 17798, 15872, 15872, 15872, 15872, 23176, 23176, 23176, 17798,
    17798, 17798, 15872, 17798, 15872, 23176, 23176, 23176, 23176, 23176,
    23176, 23176, 23176, 17798, 23176, 23176, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 17798, 17798, 17798, 20632, 20632, 20632,
    20632, 20632, 20632, 20632, 922, 20632, 15872, 15872, 15872, 14853,
    14853, 14853, 14853, 14853, 14853, 17668, 17798, 17798, 17798, 17798,
    17798, 17798, 17798, 17798, 20632, 23305, 23433, 23561, 23689, 23817,
    23945, 24073, 24201, 24329, 24457, 20632, 20632, 15872, 15872, 15872,
    15872, 14853, 20252, 20252, 20252, 20632, 20632, 20632, 20632, 20632,
    20632, 20632, 20632, 25784, 20632, 20632, 20632, 20632, 20632, 20632,
    20252, 20252, 20252, 20252, 20252, 17798, 17798, 20252, 20252, 20252,
    20252, 20252, 20252, 17798, 20252, 20252, 20252, 20252, 20252, 20252,
    15872, 15872, 20252, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 15872, 15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 15872, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    15872, 15872, 15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 6807, 17668, 17668, 17668, 15872, 23305, 23433, 23561,
    23689, 23817, 23945, 24073, 24201, 24329, 24457, 20632, 20632, 20632,
    20632, 20632, 20632, 14853, 14853, 14853, 14853, 14853, 14853, 23176,
    23176, 17798, 17798, 15872, 15872, 15872, 15872, 15872, 15872, 524,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 25877, 26006, 15872, 15872,
    15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 20632, 20632, 20632, 27275, 27403, 27531, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 17798, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161, 12290, 12161,
    12290, 12161, 12290, 12161, 12290, 12161, 12290, 10498, 10498, 10498,
    10498, 10498, 27650, 15872, 15872, 15872, 15872, 27778, 27778, 27778,
    27778, 27778, 27778, 27778, 27778, 27905, 27905, 27905, 27905, 27905,
    27905, 27905, 27905, 27778, 27778, 27778, 27778, 27778, 27778, 27778,
    27778, 27905, 27905, 27905, 27905, 27905, 27905, 27905, 27905, 27778,
    27778, 27778, 27778, 27778, 27778, 15872, 15872, 27905, 27905, 27905,
    27905, 27905, 27905, 15872, 15872, 10498, 27778, 10498, 27778, 10498,
    27778, 10498, 27778, 15872, 27905, 15872, 27905, 15872, 27905, 15872,
    27905, 27778, 27778, 27778, 27778, 27778, 27778, 27778, 27778, 27905,
    27905, 27905, 27905, 27905, 27905, 27905, 27905, 28034, 28034, 28162,
    28162, 28162, 28162, 28290, 28290, 28418, 28418, 28546, 28546, 28674,
    28674, 15872, 15872, 27778, 27778, 27778, 27778, 27778, 27778, 27778,
    27778, 28803, 28803, 28803, 28803, 28803, 28803, 28803, 28803, 27778,
    27778, 27778, 27778, 27778, 27778, 27778, 27778, 28803, 28803, 28803,
    28803, 28803, 28803, 28803, 28803, 27778, 27778, 10498, 28930, 10498,
    15872, 10498, 10498, 27905, 27905, 29057, 29057, 29187, 6683, 29314,
    6683, 6914, 7042, 7170, 7298, 7426, 7554, 7682, 7810, 7938,
    8066, 8194, 8322, 8450, 8578, 8706, 8834, 8962, 9090, 9218,
    9346, 9474, 9602, 9730, 9858, 9986, 10114, 25877, 3225, 26006,
    3225, 15872, 27778, 27778, 10498, 10498, 10498, 29698, 10498, 10498,
    27905, 27905, 29825, 29825, 29953, 6683, 6683, 6683, 15872, 15872,
    10498, 28930, 10498, 15872, 10498, 10498, 30081, 30081, 30209, 30209,
    29187, 6683, 6683, 15872, 524, 524, 524, 524, 524, 524,
    524, 30380, 524, 524, 524, 30476, 23056, 23056, 30608, 30736,
    10772, 30900, 10772, 10772, 10772, 10772, 664, 664, 31005, 31134,
    25877, 31005, 31005, 31134, 25877, 31005, 664, 664, 664, 664,
    664, 664, 664, 664, 31245, 31374, 31504, 31632, 31760, 31888,
    32016, 30380, 792, 792, 792, 792, 792, 664, 664, 664,
    664, 10717, 11614, 664, 664, 664, 664, 6807, 32139, 11403,
    11019, 11147, 32267, 32395, 32523, 32651, 32779, 32907, 1305, 1305,
    3225, 1109, 1238, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 15872, 15872, 15872, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 15872, 15872, 15872, 15872,
    15872, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 19457, 10396,
    10396, 10396, 10396, 19457, 10396, 10396, 10498, 19457, 19457, 19457,
    10498, 10498, 19457, 19457, 19457, 10498, 10396, 19457, 10396, 10396,
    10396, 19457, 19457, 19457, 19457, 19457, 10396, 10396, 41098, 41226,
    41354, 41482, 41610, 41738, 41866, 41994, 42122, 17798, 17798, 17798,
    17798, 17798, 17798, 10772, 17668, 17668, 17668, 17668, 17668, 10396,
    10396, 42250, 42378, 42506, 15872, 15872, 15872, 10396, 10396, 10396,
    10396, 15872, 10396, 10396, 10396, 10396, 15872, 15872, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 3225, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 3225, 3225, 10396, 10396,
    3225, 10396, 3225, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 3225, 10396,
    10396, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 37642, 37770, 37898, 38026, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 3225, 3225, 3225, 3225, 3225, 10396, 10396, 10396, 10396,
    10396, 3225, 3225, 10396, 10396, 10396, 10396, 19457, 10396, 33025,
    10396, 19457, 10396, 33153, 33281, 19457, 19457, 10908, 10498, 19457,
    19457, 10396, 19457, 10498, 14853, 14853, 14853, 14853, 10498, 10396,
    15872, 15872, 15872, 15872, 15872, 33546, 33674, 33802, 33930, 34058,
    34186, 34314, 34442, 34570, 34698, 34826, 34954, 35082, 35210, 35338,
    35466, 35594, 35722, 35850, 35978, 36106, 36234, 36362, 36490, 36618,
    36746, 36874, 37002, 37130, 37258, 37386, 37514, 3225, 3225, 3161,
    3161, 3225, 3225, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3225, 3225, 3225, 3225, 3225, 3161, 3161, 3161,
    3161, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225,
    3161, 3161, 3161, 3161, 3161, 3225, 3225, 3161, 3161, 3225,
    3225, 3225, 3225, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3225, 3225, 3161, 3161,
    3161, 3161, 3225, 3225, 3225, 3225, 3225, 3161, 3225, 3225,
    3225, 3225, 3225, 3225, 3225, 10396, 10396, 3225, 10396, 10396,
    3225, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 3225, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 15872, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 3225, 3161, 3161, 3161, 3161, 3225, 3225, 3225, 3161,
    3161, 3161, 3161, 3161, 3161, 3225, 3225, 3225, 3161, 1305,
    1305, 3225, 3161, 3161, 3225, 3225, 3225, 3161, 3161, 3161,
    3161, 3225, 3161, 3225, 3161, 3225, 3225, 3225, 3225, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3225, 3225,
    3225, 3225, 3225, 3161, 3225, 3161, 3161, 3161, 3161, 3161,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 1109, 1238, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 15872, 15872, 15872, 15872, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 39580,
    39580, 39580, 39580, 39580, 39580, 39580, 39580, 39580, 39580, 39580,
    39580, 39580, 39580, 39580, 39580, 39708, 39708, 39708, 39708, 39708,
    39708, 39708, 39708, 39708, 39708, 39708, 39708, 39708, 39708, 39708,
    39708, 32139, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 3161, 3225, 3161, 3225, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3225, 3225, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3225, 3225, 3161, 3161, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 922, 922, 3225, 6683, 10396, 922, 922,
    15872, 10396, 3225, 3225, 3225, 3225, 10396, 10396, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 23056, 23056,
    23056, 10396, 10396, 15872, 15872, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 15872, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 15872, 10396, 15872, 10396,
    10396, 10396, 10396, 15872, 15872, 15872, 10396, 15872, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 33419,
    39819, 39947, 40075, 40203, 40331, 40459, 40587, 40715, 40843, 33419,
    39819, 39947, 40075, 40203, 40331, 40459, 40587, 40715, 40843, 10396,
    15872, 15872, 15872, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 3161, 3161, 3161, 3161, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 20252, 10396, 10396, 10396,
    10396, 10396, 15872, 15872, 15872, 15872, 15872, 25099, 25099, 25099,
    25099, 25099, 25099, 25099, 25099, 25099, 25099, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 15872,
    15872, 15872, 20252, 24587, 24715, 24843, 24971, 42635, 42763, 42891,
    43019, 43147, 25355, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    10396, 15872, 10396, 10396, 10396, 15872, 10396, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 11403, 11019, 11147, 32267, 32395, 32523, 32651, 32779,
    32907, 38155, 38283, 38411, 38539, 38667, 38795, 38923, 39051, 39179,
    39307, 39435, 11403, 11019, 11147, 32267, 32395, 32523, 32651, 32779,
    32907, 38155, 38283, 38411, 38539, 38667, 38795, 38923, 39051, 39179,
    39307, 39435, 20252, 20252, 20252, 20252, 524, 664, 664, 664,
    10396, 17668, 14853, 40970, 1109, 1238, 1109, 1238, 1109, 1238,
    1109, 1238, 1109, 1238, 10396, 10396, 1109, 1238, 1109, 1238,
    1109, 1238, 1109, 1238, 10772, 25877, 26006, 26006, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 15872,
    15872, 15872, 15872, 17798, 17798, 6683, 6683, 17668, 17668, 15872,
    14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853, 14853,
    14853, 14853, 14853, 14853, 14853, 15872, 20252, 20252, 25099, 25099,
    25099, 25099, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252,
    20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 20252, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 43283, 43283, 43283,
    43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283,
    43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283,
    43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43283, 43410,
    43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410,
    43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410,
    43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410, 43410,
    43410, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997,
    1305, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997, 20997,
    20997, 20997, 20997, 20997, 15872, 20997, 20997, 20997, 20997, 20997,
    15872, 20997, 15872, 17798, 17798, 17798, 17798, 15872, 15872, 15872,
    15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 15872, 664,
    10772, 10772, 6807, 6807, 25877, 26006, 25877, 26006, 25877, 26006,
    25877, 26006, 25877, 26006, 25877, 26006, 15872, 15872, 15872, 15872,
    664, 664, 664, 664, 6807, 6807, 6807, 1432, 664, 1432,
    15872, 664, 1432, 664, 664, 10772, 25877, 26006, 25877, 26006,
    25877, 26006, 792, 664, 3329, 3457, 3585, 3713, 3841, 3969,
    4097, 4225, 4353, 4481, 4609, 4737, 4865, 4993, 5121, 5249,
    5377, 5505, 5633, 5761, 5889, 6017, 6145, 6273, 6401, 6529,
    25877, 664, 26006, 6683, 6807,
  };
/** Length of data. */
static const int data_length = 5345;

/**
 * This is the attribute table for computing the numeric value of a
 * character.  The value is -1 if Unicode does not define a value, -2
 * if the value is not a positive integer, otherwise it is the value.
 */
static const jshort numValue[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
    -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
    34, 35, -1, -1, -1, -1, -1, -1, 2, 3, -1, 1, -1,
    -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3,
    4, -1, 16, 10, 100, 1000, -1, -1, -1, 20, 30, 40, 50,
    60, 70, 80, 90, 10000, 17, 18, 19, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
    12, 50, 100, 500, 1000, 1, 2, 3, 4, 5, 6, 7, 8,
    9, 10, 11, 12, 50, 100, 500, 1000, 1000, 5000, 10000, -1, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, -1, -1, 2,
    3, 4, 5, 6, 7, 8, 9, 10, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 10, 20, 30, 5, 6, 7, 8, 9,
    -1, -1,
  };
/** Length of numValue. */
static const int numValue_length = 340;

/**
 * This is the attribute table for computing the uppercase representation
 * of a character.  The value is the difference between the character and
 * its uppercase version.
 */
static const jshort upper[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32,
    -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32,
    -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 743, 0, 0,
    0, 0, -32, 121, 0, -1, 0, -232, 0, -300, 0, 0, 0,
    0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0, 0,
    56, 0, -1, -2, -79, 0, 0, 0, -210, -206, -205, -202, -203,
    -207, -209, -211, -213, -214, -218, -217, -219, 0, 0, 84, 0, 0,
    0, 0, -38, -37, -31, -64, -63, -62, -57, 0, -47, -54, -86,
    -80, 0, 0, 0, 0, 0, -48, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -59, 8, 0, 74, 86,
    100, 128, 112, 126, 0, 9, 0, 0, -7205, 0, 0, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -16, -16, -16, -16, -16, -16, -16, -16,
    -16, -16, -16, -16, -16, -16, -16, -16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -26, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
  };
/** Length of upper. */
static const int upper_length = 340;

/**
 * This is the attribute table for computing the lowercase representation
 * of a character.  The value is the difference between the character and
 * its lowercase version.
 */
static const jshort lower[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 32, 0, 0, 1, 0, -199, 0, -121, 0, 210, 206, 205,
    79, 202, 203, 207, 0, 211, 209, 213, 214, 218, 217, 219, 0,
    0, 2, 1, 0, 0, -97, -56, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 37,
    64, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 80, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, -8, 0, -74, -9, 0, -86, -100, 0, -112,
    -7, -128, -126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -7517, -8383,
    -8262, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
  };
/** Length of lower. */
static const int lower_length = 340;

/**
 * This is the attribute table for computing the directionality class
 * of a character.  At present, the value is in the range 0 - 18 if the
 * character has a direction, otherwise it is -1.
 */
static const jbyte direction[] = {
    9, 11, 10, 12, 12, 13, 5, 5, 13, 13, 5, 7, 5, 4, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 13, 0, 13,
    13, 5, 3, 3, 0, 3, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 1, 1, 2, 2, 2,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 9, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 12, 9, 0, 1, 13, 13, 13, 12, 10, 14, 16, 18, 15, 17, 3,
    3, 3, 3, 3, 3, 3, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0,
  };
/** Length of direction. */
static const int direction_length = 340;

/**
 * This is the listing of titlecase special cases (all other character
 * can use <code>upper</code> to determine their titlecase).  The listing
 * is a sequence of character pairs; converting the first character of the
 * pair to titlecase produces the second character.
 */
static const jchar title[] = {
    452, 453, 453, 453, 454, 453, 455, 456, 456, 456,
    457, 456, 458, 459, 459, 459, 460, 459, 497, 498,
    498, 498, 499, 498,
  };
/** Length of title. */
static const int title_length = 24;

#endif /* __JAVA_CHARTABLES_H__ */
