Name:		freedink-dfarc
Version:	3.2.2
Release:	1%{?dist}
Summary:	Frontend and .dmod installer for GNU FreeDink

Group:		Amusements/Games
License:	GPLv3+
URL:		http://www.freedink.org/
Source0:	ftp://ftp.gnu.org/gnu/freedink/dfarc-%{version}.tar.gz
#Source0:	http://www.freedink.org/snapshots/dfarc-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if 0%{?suse_version}
BuildRequires:  bzip2, wxGTK-devel >= 2.6, intltool, gettext, gcc-c++
BuildRequires:  desktop-file-utils, update-desktop-files, 
%else
BuildRequires:	bzip2-devel, wxGTK-devel >= 2.6, intltool, gettext, desktop-file-utils
# Note: intltool F8 doesn't depend on gettext, F9's does.
# ('intltool' requires 'gettext' at configure time)
%endif
Requires:	xdg-utils

%description
DFArc2 makes it easy to play and manage the Dink Smallwood game and
it's numerous Dink Modules (or D-Mods).

%prep
%setup -q -n dfarc-%{version}


%build
# Don't install desktop files, use %post instead
%configure --disable-desktopfiles
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
%find_lang dfarc
desktop-file-validate %{buildroot}/%{_datadir}/applications/%name.desktop
%if 0%{?suse_version}
%suse_update_desktop_file -i %name
%endif


%clean
rm -rf $RPM_BUILD_ROOT


%post
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#desktop-database
update-desktop-database &> /dev/null || :
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#GTK.2B_icon_cache
touch --no-create %{_datadir}/icons/hicolor
if [ -x %{_bindir}/gtk-update-icon-cache ] ; then
  %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#mimeinfo
update-mime-database %{_datadir}/mime &> /dev/null || :

%postun
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#desktop-database
update-desktop-database &> /dev/null || :
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#GTK.2B_icon_cache
touch --no-create %{_datadir}/icons/hicolor
if [ -x %{_bindir}/gtk-update-icon-cache ] ; then
  %{_bindir}/gtk-update-icon-cache --quiet %{_datadir}/icons/hicolor || :
fi
# http://fedoraproject.org/wiki/Packaging/ScriptletSnippets#mimeinfo
update-mime-database %{_datadir}/mime &> /dev/null || :


%files -f dfarc.lang
%defattr(-,root,root,-)
%doc AUTHORS COPYING NEWS README THANKS TODO TRANSLATIONS.txt ChangeLog
%{_bindir}/*
%{_datadir}/applications/*
%{_datadir}/mime/packages/*
%{_datadir}/pixmaps/*
# Don't include system directories, only added files:
%{_datadir}/icons/hicolor/32x32/mimetypes/*
%{_mandir}/man1/*
# Done using 'find_lang' in 'install':
#%%lang(fr) %{_datadir}/locale/fr/LC_MESSAGES/*
#%%lang(pl) %{_datadir}/locale/pl/LC_MESSAGES/*


%changelog
* Wed Jun 03 2009 Sylvain Beucler <beuc@beuc.net> - 3.2.2-1
- New upstream release

* Wed Sep 24 2008 Sylvain Beucler <beuc@beuc.net> - 3.2.1-2
- Fix update-mime-database call (was conditional due to typo)
- Fix macros in comments
- Tidy changelog

* Tue Sep 23 2008 Sylvain Beucler <beuc@beuc.net> - 3.2.1-1
- New upstream release
- Fix source URI
- Clarify wxGlade upstream developer-only dependency
- Use 'install -p' to preserve timestamps
- Validate desktop files> * Desktop file
- Rebuild MIME cache after installing desktop files
- Add ChangeLog to the docs
- Don't own _datadir/icons/hicolor directories

* Sun Sep 20 2008 Sylvain Beucler <beuc@beuc.net> - 3.2-1
- New upstream release

* Thu Aug 28 2008 Sylvain Beucler <beuc@beuc.net> 3.0-1
- Initial package
