/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.io.IOException;

public class LibraryBackup {
    public static final LibraryBackup[] NULL_ARRAY = new LibraryBackup[0];
    public static final ImmutableArrayList<LibraryBackup> EMPTY_LIST = ImmutableArrayList.of(new LibraryBackup[0]);
    public final ImmutableLibrary d;
    public final boolean modified;
    public final LibId[] referencedLibs;

    public LibraryBackup(ImmutableLibrary d, boolean modified, LibId[] referencedLibs) {
        this.d = d;
        this.modified = modified;
        this.referencedLibs = referencedLibs;
    }

    LibraryBackup withModified() {
        if (this.modified) {
            return this;
        }
        return new LibraryBackup(this.d, true, this.referencedLibs);
    }

    LibraryBackup withRenamedIds(IdMapper idMapper) {
        ImmutableLibrary d = this.d.withRenamedIds(idMapper);
        LibId[] referencedLibs = null;
        for (int i = 0; i < this.referencedLibs.length; ++i) {
            LibId oldLibId = this.referencedLibs[i];
            LibId newLibId = idMapper.get(oldLibId);
            if (newLibId != oldLibId && referencedLibs == null) {
                referencedLibs = new LibId[this.referencedLibs.length];
                System.arraycopy(this.referencedLibs, 0, referencedLibs, 0, referencedLibs.length);
            }
            if (referencedLibs == null) continue;
            referencedLibs[i] = newLibId;
        }
        if (referencedLibs == null) {
            referencedLibs = this.referencedLibs;
        }
        if (this.d == d && this.referencedLibs == referencedLibs) {
            return this;
        }
        LibraryBackup newBackup = new LibraryBackup(d, true, referencedLibs);
        newBackup.check();
        return newBackup;
    }

    void write(IdWriter writer) throws IOException {
        this.d.write(writer);
        writer.writeBoolean(this.modified);
        writer.writeInt(this.referencedLibs.length);
        for (int i = 0; i < this.referencedLibs.length; ++i) {
            writer.writeLibId(this.referencedLibs[i]);
        }
    }

    static LibraryBackup read(IdReader reader) throws IOException {
        ImmutableLibrary d = ImmutableLibrary.read(reader);
        boolean modified = reader.readBoolean();
        int refsLength = reader.readInt();
        LibId[] refs = new LibId[refsLength];
        for (int i = 0; i < refsLength; ++i) {
            refs[i] = reader.readLibId();
        }
        return new LibraryBackup(d, modified, refs);
    }

    public void check() {
        this.d.check();
        for (LibId libId : this.referencedLibs) {
            assert (libId != null);
        }
    }

    public String toString() {
        return this.d.toString();
    }
}

