/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.dialogs.LanguageScripts;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ToolbarTab
extends PreferencePanel
implements TreeSelectionListener {
    private CommandTree commandsTree;
    private List<DraggableToolbarEntry> sampleToolbarComponents;
    private Map<String, ToolBar.EToolBarButton> knownButtons;
    private Map<String, EMenuItem> menuEntries;
    private Map<String, String> commandToIconMap;
    private MenuTreeNode currentTreeNode;
    private PreferencesFrame trueParent;
    private static ImageIcon menuIcon = Resources.getResource(ToolBar.class, "ButtonMenu.gif");
    private static ImageIcon trashIcon = Resources.getResource(ToolBar.class, "IconTrash.gif");
    private static ImageIcon separatorIcon = Resources.getResource(ToolBar.class, "IconSeparator.gif");
    private static ImageIcon separatorButton = Resources.getResource(ToolBar.class, "ButtonSeparator.gif");
    private JButton attachImage;
    private JScrollPane commandsPane;
    private JPanel currentToolbar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel separatorLabel;
    private JPanel toolbar;
    private JLabel trashLabel;

    public ToolbarTab(PreferencesFrame parent, boolean modal, PreferencesFrame trueParent) {
        super(parent, modal);
        this.trueParent = trueParent;
        this.initComponents();
        this.separatorLabel.setIcon(separatorIcon);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.separatorLabel, 0x40000000, new SeparatorDrag());
        this.trashLabel.setIcon(trashIcon);
        TrashDropTarget dropTarget = new TrashDropTarget();
        new DropTarget(this.trashLabel, 2, dropTarget, true);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.toolbar;
    }

    @Override
    public String getName() {
        return "Toolbar";
    }

    @Override
    public void init() {
        this.knownButtons = new HashMap<String, ToolBar.EToolBarButton>();
        List<ToolBar.EToolBarButton> allButtons = ToolBar.getAllButtons();
        for (ToolBar.EToolBarButton b : allButtons) {
            this.knownButtons.put(b.getMenuName() + ":" + b.getText().replace("_", ""), b);
        }
        this.commandsTree = new CommandTree();
        this.buildCommandsTree();
        this.commandToIconMap = ToolBar.getCommandToIconMap();
        for (String command : this.commandToIconMap.keySet()) {
            String fileName = this.commandToIconMap.get(command);
            ToolBar.EToolBarButton but = this.knownButtons.get(command);
            if (but == null) {
                int lastColon = command.lastIndexOf(58);
                String menuName = lastColon < 0 ? "" : command.substring(0, lastColon);
                String commandName = command.substring(lastColon + 1);
                EMenuItem mi = this.menuEntries.get(command);
                if (mi == null) continue;
                but = new ToolBar.EToolBarGeneralMenuButton(commandName, "ButtonUnknown", menuName, mi);
                this.knownButtons.put(command, but);
            }
            ImageIcon icon = ToolBar.getProperSizeIcon(fileName);
            but.setIcon(icon, fileName);
        }
        this.commandsTree.setCellRenderer(new MyRenderer());
        this.commandsPane.setViewportView(this.commandsTree);
        for (String iconCommand : this.knownButtons.keySet()) {
            if (this.menuEntries.get(iconCommand) != null) continue;
            System.out.println("WARNING: Icon mapped to command '" + iconCommand + "' which does not exist");
        }
        this.currentToolbar.setLayout(new GridBagLayout());
        ToolBar.EToolBarButton[] currentButtons = ToolBar.getToolbarButtons();
        this.sampleToolbarComponents = new ArrayList<DraggableToolbarEntry>();
        for (int i = 0; i < currentButtons.length; ++i) {
            ToolBar.EToolBarButton b = currentButtons[i];
            DraggableToolbarEntry j = new DraggableToolbarEntry(i, b);
            this.sampleToolbarComponents.add(j);
        }
        this.buildSampleToolbar();
    }

    @Override
    public void term() {
        ToolBar.setCommandToIconMap(this.commandToIconMap);
        ToolBar.EToolBarButton[] newButtons = new ToolBar.EToolBarButton[this.sampleToolbarComponents.size()];
        for (int i = 0; i < this.sampleToolbarComponents.size(); ++i) {
            newButtons[i] = this.sampleToolbarComponents.get(i).getToolbarButton();
        }
        ToolBar.setToolbarButtons(newButtons);
    }

    @Override
    public boolean resetThis() {
        this.sampleToolbarComponents.clear();
        ToolBar.EToolBarButton[] factorySet = ToolBar.getFactoryButtons();
        for (int i = 0; i < factorySet.length; ++i) {
            this.sampleToolbarComponents.add(new DraggableToolbarEntry(i, factorySet[i]));
        }
        this.buildSampleToolbar();
        this.trueParent.pack();
        return true;
    }

    @Override
    public void reset() {
        ToolBar.EToolBarButton[] buts;
        ToolBar.EToolBarButton[] fButs = ToolBar.getFactoryButtons();
        boolean same = fButs.equals(buts = ToolBar.getToolbarButtons());
        if (!same) {
            ToolBar.setToolbarButtons(ToolBar.getFactoryButtons());
        }
    }

    private void buildSampleToolbar() {
        this.currentToolbar.removeAll();
        int i = 0;
        while (i < this.sampleToolbarComponents.size()) {
            DraggableToolbarEntry j = this.sampleToolbarComponents.get(i);
            j.setIndex(i);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = i++;
            gbc.gridy = 0;
            this.currentToolbar.add((Component)j, gbc);
        }
    }

    private void dropButton(String droppedButton) {
        if (droppedButton.startsWith("#")) {
            int index = TextUtils.atoi(droppedButton.substring(1));
            this.sampleToolbarComponents.remove(index);
            this.buildSampleToolbar();
            this.trueParent.pack();
        }
    }

    private void droppedAt(int index, String what, boolean before) {
        if (!before) {
            ++index;
        }
        if (what.startsWith("#")) {
            int startLoc = TextUtils.atoi(what.substring(1));
            DraggableToolbarEntry j = this.sampleToolbarComponents.get(startLoc);
            this.sampleToolbarComponents.remove(startLoc);
            if (startLoc < index) {
                --index;
            }
            this.sampleToolbarComponents.add(index, j);
        } else if (what.equals("SEPARATOR")) {
            DraggableToolbarEntry j = new DraggableToolbarEntry(0, null);
            this.sampleToolbarComponents.add(index, j);
        } else {
            ToolBar.EToolBarButton but = this.knownButtons.get(what);
            if (but == null) {
                int lastColon = what.lastIndexOf(58);
                String menuName = lastColon < 0 ? "" : what.substring(0, lastColon);
                String commandName = what.substring(lastColon + 1);
                EMenuItem mi = this.menuEntries.get(what);
                but = new ToolBar.EToolBarGeneralMenuButton(commandName, "ButtonUnknown", menuName, mi);
                this.knownButtons.put(what, but);
            }
            DraggableToolbarEntry j = new DraggableToolbarEntry(0, but);
            this.sampleToolbarComponents.add(index, j);
        }
        this.buildSampleToolbar();
        this.trueParent.pack();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.currentTreeNode = null;
        TreePath path = e.getPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
        Object n = node.getUserObject();
        if (!(n instanceof MenuTreeNode)) {
            return;
        }
        MenuTreeNode mtn = (MenuTreeNode)n;
        if (mtn.menuName.endsWith("--")) {
            return;
        }
        this.currentTreeNode = mtn;
    }

    private void attachImageToCommand() {
        if (this.currentTreeNode == null) {
            Job.getUserInterface().showErrorMessage("Must select a command from the 'Commands' tree first", "Cannot Set Image");
            return;
        }
        String fileName = OpenFile.chooseInputFile(FileType.ANY, "Image to attach to command", null);
        if (fileName == null) {
            return;
        }
        ImageIcon icon = ToolBar.getProperSizeIcon(fileName);
        if (icon != null) {
            String what = this.currentTreeNode.menuName;
            ToolBar.EToolBarButton but = this.knownButtons.get(what);
            if (but == null) {
                int lastColon = what.lastIndexOf(58);
                String menuName = lastColon < 0 ? "" : what.substring(0, lastColon);
                String commandName = what.substring(lastColon + 1);
                EMenuItem mi = this.menuEntries.get(what);
                but = new ToolBar.EToolBarGeneralMenuButton(commandName, "ButtonUnknown", menuName, mi);
                this.knownButtons.put(what, but);
            }
            but.setIcon(icon, fileName);
            this.commandToIconMap.put(what, fileName);
            this.commandsTree.updateUI();
        }
    }

    private void buildCommandsTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.menuEntries = new HashMap<String, EMenuItem>();
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top == null) {
            return;
        }
        EMenuBar mb = top.getEMenuBar();
        if (mb == null) {
            return;
        }
        for (EMenuItem menu : mb.getItems()) {
            DefaultMutableTreeNode menuNode = new DefaultMutableTreeNode(new MenuTreeNode(menu, menu.getText()));
            rootNode.add(menuNode);
            this.addMenu(menuNode, (EMenu)menu, menu.getText());
        }
        EMenu hiddenMenu = mb.getHiddenMenu();
        if (hiddenMenu != null) {
            DefaultMutableTreeNode menuNode = new DefaultMutableTreeNode(new MenuTreeNode(hiddenMenu, hiddenMenu.getText()));
            rootNode.add(menuNode);
            this.addMenu(menuNode, hiddenMenu, hiddenMenu.getText());
        }
        this.commandsTree.setModel(new DefaultTreeModel(rootNode));
        this.commandsTree.getSelectionModel().setSelectionMode(1);
        this.commandsTree.setRootVisible(false);
        this.commandsTree.setShowsRootHandles(true);
        this.commandsTree.addTreeSelectionListener(this);
    }

    private void addMenu(DefaultMutableTreeNode parentNode, EMenu menu, String menuName) {
        for (EMenuItem menuItem : menu.getItems()) {
            String menuItemName = menuName + ":" + menuItem.getText();
            DefaultMutableTreeNode menuItemNode = new DefaultMutableTreeNode(new MenuTreeNode(menuItem, menuItemName));
            parentNode.add(menuItemNode);
            if (menuItem instanceof EMenu) {
                this.addMenu(menuItemNode, (EMenu)menuItem, menuItemName);
                continue;
            }
            this.menuEntries.put(menuItemName, menuItem);
        }
        if (parentNode.toString().equals("Tools | Languages")) {
            for (LanguageScripts.ScriptBinding script : LanguageScripts.getScripts()) {
                String scriptName = script.fileName;
                int lastColon = scriptName.lastIndexOf(58);
                int lastSlash = scriptName.lastIndexOf(47);
                int lastBS = scriptName.lastIndexOf(92);
                int finalPos = Math.max(lastColon, Math.max(lastSlash, lastBS));
                scriptName = scriptName.substring(finalPos + 1);
                FileType type = FileType.JAVA;
                if (scriptName.toLowerCase().endsWith(".bsh")) {
                    scriptName = scriptName.substring(0, scriptName.length() - 4);
                } else if (scriptName.toLowerCase().endsWith(".py") || scriptName.toLowerCase().endsWith(".jy")) {
                    scriptName = scriptName.substring(0, scriptName.length() - 3);
                    type = FileType.JYTHON;
                }
                ToolMenu.DynamicLanguageMenuItem menuItem = new ToolMenu.DynamicLanguageMenuItem(scriptName, script.fileName, type);
                DefaultMutableTreeNode menuItemNode = new DefaultMutableTreeNode(new MenuTreeNode(menuItem, scriptName));
                parentNode.add(menuItemNode);
                this.menuEntries.put(scriptName, menuItem);
            }
        }
    }

    private void initComponents() {
        this.toolbar = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.currentToolbar = new JPanel();
        this.commandsPane = new JScrollPane();
        this.trashLabel = new JLabel();
        this.separatorLabel = new JLabel();
        this.attachImage = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ToolbarTab.this.closeDialog(evt);
            }
        });
        this.toolbar.setLayout(new GridBagLayout());
        this.jLabel1.setText("To add commands, drag them from the \"Commands\" to the \"Toolbar\".");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.toolbar.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("To remove commands, drag them from the \"Toolbar\" to the trash.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.toolbar.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("To rearrange icons, drag them around the \"Toolbar\".");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.toolbar.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("To add separators, drag the \"Sep\" icon to the \"Toolbar\".");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.toolbar.add((Component)this.jLabel4, gridBagConstraints);
        this.currentToolbar.setBorder(BorderFactory.createTitledBorder("Toolbar:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.toolbar.add((Component)this.currentToolbar, gridBagConstraints);
        this.commandsPane.setBorder(BorderFactory.createTitledBorder("Commands:"));
        this.commandsPane.setMinimumSize(new Dimension(32, 150));
        this.commandsPane.setPreferredSize(new Dimension(32, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.toolbar.add((Component)this.commandsPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(4, 20, 4, 10);
        this.toolbar.add((Component)this.trashLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(4, 10, 4, 20);
        this.toolbar.add((Component)this.separatorLabel, gridBagConstraints);
        this.attachImage.setText("Attach Image to Command...");
        this.attachImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarTab.this.attachImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        this.toolbar.add((Component)this.attachImage, gridBagConstraints);
        this.getContentPane().add((Component)this.toolbar, new GridBagConstraints());
        this.pack();
    }

    private void attachImageActionPerformed(ActionEvent evt) {
        this.attachImageToCommand();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private class SeparatorDrag
    implements DragSourceListener,
    DragGestureListener {
        private SeparatorDrag() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            StringSelection transferable = new StringSelection("TOOLBARBUTTON SEPARATOR");
            e.startDrag(null, separatorIcon.getImage(), new Point(0, 0), transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    private class TrashDropTarget
    implements DropTargetListener {
        private boolean trashHighlighted = false;

        private TrashDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (this.dragAction(e)) {
                return;
            }
            DropTarget dt = (DropTarget)e.getSource();
            if (dt.getComponent() == ToolbarTab.this.trashLabel) {
                this.eraseDragImage(dt);
                Graphics2D g2 = (Graphics2D)ToolbarTab.this.trashLabel.getGraphics();
                g2.setColor(Color.RED);
                g2.drawRect(0, 0, ToolbarTab.this.trashLabel.getWidth() - 1, ToolbarTab.this.trashLabel.getHeight() - 1);
                this.trashHighlighted = true;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.eraseDragImage((DropTarget)e.getSource());
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropTarget dt;
            Component but;
            dtde.acceptDrop(2);
            this.eraseDragImage((DropTarget)dtde.getSource());
            String droppedButton = this.getDraggedObject(dtde.getTransferable(), dtde.getCurrentDataFlavors());
            if (droppedButton != null && (but = (dt = (DropTarget)dtde.getSource()).getComponent()) != null) {
                ToolbarTab.this.dropButton(droppedButton);
                dtde.dropComplete(true);
                return;
            }
            dtde.dropComplete(false);
        }

        private boolean dragAction(DropTargetDragEvent e) {
            String droppedButton = this.getDraggedObject(e.getTransferable(), e.getCurrentDataFlavors());
            if (droppedButton != null) {
                e.acceptDrag(e.getDropAction());
                return false;
            }
            e.rejectDrag();
            return true;
        }

        private String getDraggedObject(Transferable tra, DataFlavor[] flavors) {
            if (flavors.length <= 0) {
                return null;
            }
            if (flavors[0].isFlavorTextType()) {
                String buttonName;
                Object obj = null;
                try {
                    obj = tra.getTransferData(flavors[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (obj instanceof String && (buttonName = (String)obj).startsWith("TOOLBARBUTTON #")) {
                    String bn = buttonName.substring(14);
                    return bn;
                }
            }
            return null;
        }

        private void eraseDragImage(DropTarget dt) {
            if (!this.trashHighlighted) {
                return;
            }
            Rectangle pathBounds = new Rectangle(0, 0, ToolbarTab.this.trashLabel.getWidth(), ToolbarTab.this.trashLabel.getHeight());
            ToolbarTab.this.trashLabel.paintImmediately(pathBounds);
            this.trashHighlighted = false;
        }
    }

    private class CommandTree
    extends JTree
    implements DragSourceListener {
        CommandTree() {
            this.setTransferHandler(new MyTransferHandler(this.getTransferHandler()));
            this.setDragEnabled(true);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        private class MyTransferHandler
        extends TransferHandler {
            private TransferHandler real;

            MyTransferHandler(TransferHandler real) {
                this.real = real;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (ToolbarTab.this.currentTreeNode == null) {
                    return null;
                }
                StringSelection transferable = new StringSelection("TOOLBARBUTTON " + ToolbarTab.this.currentTreeNode.menuName);
                return transferable;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return this.real.canImport(comp, transferFlavors);
            }

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                this.real.exportAsDrag(comp, e, action);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                this.real.exportToClipboard(comp, clip, action);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return this.real.getSourceActions(c);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                return this.real.getVisualRepresentation(t);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                return this.real.importData(comp, t);
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!(value instanceof DefaultMutableTreeNode)) {
                return this;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getChildCount() > 0) {
                this.setIcon(menuIcon);
            } else {
                Object nodeInfo = node.getUserObject();
                if (nodeInfo instanceof MenuTreeNode) {
                    MenuTreeNode mtn = (MenuTreeNode)nodeInfo;
                    if (mtn.menuItem == EMenuItem.SEPARATOR) {
                        this.setIcon(null);
                    } else {
                        ToolBar.EToolBarButton but = ToolbarTab.this.knownButtons.get(mtn.menuName);
                        if (but != null) {
                            this.setIcon(but.getIcon());
                        } else {
                            this.setIcon(ToolBar.getUnknownIcon());
                        }
                    }
                }
            }
            return this;
        }
    }

    private class DraggableToolbarEntry
    extends JLabel
    implements DragGestureListener,
    DragSourceListener {
        private DragSource dragSource;
        private int editIndex;
        private ToolBar.EToolBarButton toolbarButton;

        public DraggableToolbarEntry(int editIndex, ToolBar.EToolBarButton toolbarButton) {
            this.editIndex = editIndex;
            this.toolbarButton = toolbarButton;
            ImageIcon icon = toolbarButton == null ? separatorButton : toolbarButton.getIcon();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            BufferedImage originalImage = new BufferedImage(width, height, 2);
            Graphics g = originalImage.getGraphics();
            g.drawImage(icon.getImage(), 0, 0, null);
            Raster originalData = originalImage.getData();
            int border = 4;
            BufferedImage biggerImage = new BufferedImage(width + border * 2, height + border * 2, 2);
            WritableRaster biggerRaster = biggerImage.getRaster();
            int[] sArray = new int[4];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    originalData.getPixel(x, y, sArray);
                    biggerRaster.setPixel(x + border, y + border, sArray);
                }
            }
            this.setIcon(new ImageIcon(biggerImage));
            if (toolbarButton != null) {
                this.setToolTipText(toolbarButton.getText());
            }
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            ToolBarDropTarget dropTarget = new ToolBarDropTarget();
            new DropTarget(this, 2, dropTarget, true);
        }

        public void setIndex(int i) {
            this.editIndex = i;
        }

        public ToolBar.EToolBarButton getToolbarButton() {
            return this.toolbarButton;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            StringSelection transferable = new StringSelection("TOOLBARBUTTON #" + this.editIndex);
            this.dragSource.startDrag(e, DragSource.DefaultMoveDrop, transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        private class ToolBarDropTarget
        implements DropTargetListener {
            private JLabel lastButtonDrawn = null;

            private ToolBarDropTarget() {
            }

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                this.dragAction(e);
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                if (this.dragAction(e)) {
                    return;
                }
                DropTarget dt = (DropTarget)e.getSource();
                if (dt.getComponent() instanceof JLabel) {
                    JLabel but = (JLabel)dt.getComponent();
                    this.eraseDragImage(dt);
                    Graphics2D g2 = (Graphics2D)but.getGraphics();
                    g2.setColor(Color.RED);
                    int x = 0;
                    if (e.getLocation().x > but.getWidth() / 2) {
                        x = but.getWidth() - 2;
                    }
                    g2.drawRect(x, 0, 1, but.getHeight());
                    this.lastButtonDrawn = but;
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent e) {
                this.dragAction(e);
            }

            @Override
            public void dragExit(DropTargetEvent e) {
                this.eraseDragImage((DropTarget)e.getSource());
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                DropTarget dt;
                Component but;
                dtde.acceptDrop(2);
                this.eraseDragImage((DropTarget)dtde.getSource());
                String droppedButton = this.getDraggedObject(dtde.getTransferable(), dtde.getCurrentDataFlavors());
                if (droppedButton != null && (but = (dt = (DropTarget)dtde.getSource()).getComponent()) != null) {
                    int index = -1;
                    for (int i = 0; i < but.getParent().getComponentCount(); ++i) {
                        if (but.getParent().getComponent(i) != but) continue;
                        index = i;
                        break;
                    }
                    boolean before = true;
                    if (dtde.getLocation().x > but.getWidth() / 2) {
                        before = false;
                    }
                    if (index >= 0) {
                        ToolbarTab.this.droppedAt(index, droppedButton, before);
                    }
                    dtde.dropComplete(true);
                    return;
                }
                dtde.dropComplete(false);
            }

            private boolean dragAction(DropTargetDragEvent e) {
                String droppedButton = this.getDraggedObject(e.getTransferable(), e.getCurrentDataFlavors());
                if (droppedButton != null) {
                    e.acceptDrag(e.getDropAction());
                    return false;
                }
                e.rejectDrag();
                return true;
            }

            private String getDraggedObject(Transferable tra, DataFlavor[] flavors) {
                if (flavors.length <= 0) {
                    return null;
                }
                if (flavors[0].isFlavorTextType()) {
                    String buttonName;
                    Object obj = null;
                    try {
                        obj = tra.getTransferData(flavors[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (obj instanceof String && (buttonName = (String)obj).startsWith("TOOLBARBUTTON ")) {
                        return buttonName.substring(14);
                    }
                }
                return null;
            }

            private void eraseDragImage(DropTarget dt) {
                if (this.lastButtonDrawn == null) {
                    return;
                }
                Rectangle pathBounds = new Rectangle(0, 0, this.lastButtonDrawn.getWidth(), this.lastButtonDrawn.getHeight());
                this.lastButtonDrawn.paintImmediately(pathBounds);
                this.lastButtonDrawn = null;
            }
        }
    }

    private class MenuTreeNode {
        private EMenuItem menuItem;
        private String menuName;

        MenuTreeNode(EMenuItem menuItem, String menuName) {
            this.menuItem = menuItem;
            this.menuName = menuName;
        }

        public String toString() {
            if (this.menuItem != EMenuItem.SEPARATOR) {
                StringBuffer buf = new StringBuffer(this.menuItem.getDescription());
                return buf.toString();
            }
            return "---------------";
        }
    }
}

