/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4Pow<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> x;
    public final Svex<N> y;

    private Vec4Pow(Svex<N> x, Svex<N> y) {
        super(FUNCTION, x, y);
        this.x = x;
        this.y = y;
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_POW, 2, "4vec-pow");
        }

        public <N extends SvarName> Vec4Pow<N> build(Svex<N>[] args) {
            return new Vec4Pow<N>(args[0], args[1]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 base = args[0];
            Vec4 exp = args[1];
            if (base.isVec2() && exp.isVec2()) {
                BigInteger basev = ((Vec2)base).getVal();
                int expv = ((Vec2)exp).getVal().intValueExact();
                if (expv >= 0 || basev.abs().equals(BigInteger.ONE)) {
                    return Vec2.valueOf(basev.pow(expv));
                }
                if (basev.signum() != 0) {
                    return Vec2.ZERO;
                }
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            return new BigInteger[]{this.v4maskAllOrNone(mask), this.v4maskAllOrNone(mask)};
        }
    }
}

