/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wiretype;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.HashMap;

public class Wire {
    public final Name name;
    public final int width;
    public final int low_idx;
    public final int delay;
    public final boolean revp;
    public final Wiretype wiretype;

    public Wire(Name name, int width) {
        this(name, width, 0, 0, false, Wiretype.WIRE);
    }

    public Wire(Name name, int width, int low_idx, int delay, boolean revp, Wiretype wiretype) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (width <= 0) {
            throw new IllegalArgumentException();
        }
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        if (wiretype == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.width = width;
        this.low_idx = low_idx;
        this.delay = delay;
        this.revp = revp;
        this.wiretype = wiretype;
    }

    public Wire(ACL2Object impl) {
        ACL2Object cons0 = ACL2.car(impl);
        this.name = Name.fromACL2(ACL2.car(cons0));
        ACL2Object cons01 = ACL2.cdr(cons0);
        this.width = ACL2.car(cons01).intValueExact();
        Util.check(this.width >= 1);
        this.low_idx = ACL2.cdr(cons01).intValueExact();
        if (ACL2.consp(ACL2.cdr(impl)).bool()) {
            ACL2Object cons1 = ACL2.cdr(impl);
            Util.check(!ACL2.NIL.equals(ACL2.car(cons1)) || !ACL2.NIL.equals(ACL2.cdr(cons1)));
            if (ACL2.symbolp(ACL2.car(cons1)).bool()) {
                Util.checkNil(ACL2.car(cons1));
                this.delay = 0;
            } else {
                this.delay = ACL2.car(cons1).intValueExact();
            }
            if (ACL2.consp(ACL2.cdr(cons1)).bool()) {
                ACL2Object cons11 = ACL2.cdr(cons1);
                if (ACL2.NIL.equals(ACL2.car(cons11))) {
                    Util.checkNil(ACL2.car(cons11));
                    this.revp = false;
                } else {
                    this.revp = true;
                }
                this.wiretype = Wiretype.valueOf(ACL2.cdr(cons11));
            } else {
                Util.checkNil(ACL2.cdr(cons1));
                this.revp = false;
                this.wiretype = Wiretype.valueOf(ACL2.NIL);
            }
        } else {
            Util.checkNil(ACL2.cdr(impl));
            this.delay = 0;
            this.revp = false;
            this.wiretype = Wiretype.valueOf(ACL2.NIL);
        }
    }

    public ACL2Object getACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object rep00 = this.name.getACL2Object(backedCache);
        ACL2Object rep010 = ACL2Object.valueOf(this.width);
        ACL2Object rep110 = ACL2Object.valueOf(this.low_idx);
        ACL2Object rep10 = ACL2.cons(rep010, rep110);
        ACL2Object rep0 = ACL2.cons(rep00, rep10);
        ACL2Object rep01 = this.delay > 0 ? ACL2Object.valueOf(this.delay) : ACL2.NIL;
        ACL2Object rep011 = ACL2Object.valueOf(this.revp);
        ACL2Object rep111 = this.wiretype.getACL2Object();
        ACL2Object rep11 = ACL2.NIL.equals(rep011) && ACL2.NIL.equals(rep111) ? ACL2.NIL : ACL2.cons(rep011, rep111);
        ACL2Object rep1 = ACL2.NIL.equals(rep01) && ACL2.NIL.equals(rep11) ? ACL2.NIL : ACL2.cons(rep01, rep11);
        ACL2Object rep = ACL2.cons(rep0, rep1);
        return rep;
    }

    public int getFirstIndex() {
        if (this.revp) {
            throw new UnsupportedOperationException();
        }
        return this.low_idx + this.width - 1;
    }

    public int getSecondIndex() {
        if (this.revp) {
            throw new UnsupportedOperationException();
        }
        return this.low_idx;
    }

    public String toString(int width, int rsh) {
        if (this.width == 1 && this.low_idx == 0 && width == 1 && rsh == 0) {
            return this.name.toString();
        }
        if (this.revp) {
            throw new UnsupportedOperationException();
        }
        return this.name + "[" + (String)(width == 1 ? "" : this.low_idx + rsh + width - 1 + ":") + (this.low_idx + rsh) + "]";
    }

    public String toString(BigInteger mask) {
        if (this.revp) {
            throw new UnsupportedOperationException();
        }
        String s = this.name.toString();
        if (mask == null) {
            mask = BigInteger.ZERO;
        }
        BigInteger maskH = mask.shiftRight(this.width);
        mask = BigIntegerUtil.loghead(this.width, mask);
        Object indices = "";
        int ind = 0;
        boolean first = true;
        while (true) {
            if (mask.signum() != 0) {
                int n = mask.getLowestSetBit();
                assert (n >= 0);
                mask = mask.shiftRight(n);
                int indL = ind += n;
                if (BigIntegerUtil.MINUS_ONE.equals(mask)) {
                    if (!first) {
                        indices = "," + (String)indices;
                    }
                    indices = ":" + Integer.toString(this.low_idx + indL) + (String)indices;
                } else {
                    n = mask.not().getLowestSetBit();
                    assert (n >= 0);
                    mask = mask.shiftRight(n);
                    if (indL == 0 && (ind += n) == this.width && this.width == 1 && maskH.signum() == 0) {
                        Util.check(mask.signum() == 0);
                        Util.check(((String)indices).isEmpty());
                        return s;
                    }
                    Util.check(!this.revp);
                    if (first) {
                        first = false;
                    } else {
                        indices = "," + (String)indices;
                    }
                    indices = indL == ind - 1 ? Integer.toString(this.low_idx + indL) + (String)indices : Integer.toString(this.low_idx + ind - 1) + ":" + Integer.toString(this.low_idx + indL) + (String)indices;
                    continue;
                }
            }
            if (maskH.signum() == 0) break;
            indices = "/*?*/" + (String)indices;
            mask = maskH;
            maskH = BigInteger.ZERO;
        }
        return s + "[" + (String)indices + "]";
    }

    public String toLispString(int width, int rsh) {
        return this.toString(BigIntegerUtil.logheadMask(width).shiftLeft(rsh));
    }

    public String toString() {
        Util.checkNil(this.wiretype.getACL2Object());
        Util.check(this.delay == 0);
        Object s = this.name.toString();
        if (this.width != 1) {
            Util.check(!this.revp);
            s = (String)s + "[" + (this.low_idx + this.width - 1) + ":" + this.low_idx + "]";
        } else if (this.low_idx != 0) {
            s = (String)s + "[" + this.low_idx + "]";
        }
        return s;
    }

    public boolean equals(Object o) {
        if (o instanceof Wire) {
            Wire that = (Wire)o;
            return this.getACL2Object().equals(that.getACL2Object());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.name.hashCode();
        return hash;
    }
}

